/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class VfrPointsPainter
extends VfrPainter {
    private Set<VfrPointDTO> pointsList;
    private static final Font AIRPORT_POINT_LABEL_FONT = new Font("SansSerif", 1, 10);
    private boolean singleAirport = false;

    public VfrPointsPainter(GpsArea visibleArea, Set<VfrPointDTO> points) {
        this.visibleArea = visibleArea;
        this.pointsList = points;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (VfrPointDTO wp : this.pointsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            g.setColor(SettingsBean.getInstance().getColorTheme().getAirspacePointColor());
            GraphicsUtil.fillTriangle(g, x, y, 5);
            if (!this.singleAirport && !SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setFont(AIRPORT_POINT_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(wp.getName(), g);
            this.applyTextLabelsRotation(g, x, y);
            GraphicsUtil.drawOutlinedString(g, x + 8, y + (int)Math.round(rect.getHeight() / 2.0), wp.getName(), AIRPORT_POINT_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getAirspacePointColor(), null, 2.0f);
            this.removeTextLabelsRotation(g, x, y);
        }
    }

    public boolean hasPoints() {
        return this.pointsList != null && this.pointsList.size() > 0;
    }
}

