/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public abstract class VfrPainter
implements PriorityPainter<JXMapViewer> {
    private int priority = 0;
    protected GpsArea visibleArea;

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        this.draw(g, map, this.visibleArea == null ? MapFrame.getInstance().getVisibleArea() : this.visibleArea);
    }

    public abstract void draw(Graphics2D var1, JXMapViewer var2, GpsArea var3);

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void removeTextLabelsRotation(Graphics2D g, int x, int y) {
        double rotation;
        if (SettingsBean.getInstance().getTextLabelsRotationAngle() != null && !Double.isNaN(rotation = Math.toRadians(-SettingsBean.getInstance().getTextLabelsRotationAngle().doubleValue()))) {
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
        }
    }

    protected void applyTextLabelsRotation(Graphics2D g, int x, int y) {
        double rotation;
        if (SettingsBean.getInstance().getTextLabelsRotationAngle() != null && !Double.isNaN(rotation = Math.toRadians(SettingsBean.getInstance().getTextLabelsRotationAngle()))) {
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
        }
    }
}

