/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.gui.map.painter.bean.UserTrackBean;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class UserTrackPainter
extends VfrPainter {
    private UserTrackBean[] track;
    private static final BasicStroke BASIC_STROKE_1 = new BasicStroke(1.0f);
    private boolean paintMarker = false;

    public UserTrackPainter(GpsArea visibleArea, List<ExtConnectBean> userTrack) {
        this.visibleArea = visibleArea;
        this.track = this.getUserTrackBeanArray(userTrack);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setStroke(new BasicStroke(4.0f));
        this.drawTrack(g, map, visibleArea, Color.BLACK);
        g.setStroke(new BasicStroke(2.0f));
        this.drawTrack(g, map, visibleArea, null);
        if (SimConnectUtil.getInstance().getSelectedUserTrackPoint() != null) {
            if (this.paintMarker) {
                this.drawMarker(SimConnectUtil.getInstance().getSelectedUserTrackPoint(), g, map, visibleArea);
            } else {
                this.drawUserPlane(SimConnectUtil.getInstance().getSelectedUserTrackPoint(), g, map, visibleArea);
            }
        }
    }

    private void drawUserPlane(int index, Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (visibleArea.contains(this.track[index].getPosition())) {
            Point2D wp = map.getTileFactory().geoToPixel(this.track[index].getPosition(), map.getZoom());
            int x = (int)Math.round(wp.getX());
            int y = (int)Math.round(wp.getY());
            GraphicsUtil.drawUserPlaneTop(g, x, y, this.track[index].getTrueHeading(), 4, true);
        }
    }

    private void drawMarker(int index, Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (visibleArea.contains(this.track[index].getPosition())) {
            Point2D wp = map.getTileFactory().geoToPixel(this.track[index].getPosition(), map.getZoom());
            int x = (int)Math.round(wp.getX());
            int y = (int)Math.round(wp.getY());
            g.setStroke(BASIC_STROKE_1);
            GraphicsUtil.drawMarker(g, x, y, 5, 21, SettingsBean.getInstance().getColorTheme().getMeteoMarkerColor(), SettingsBean.getInstance().getColorTheme().getMeteoMarkerBorderColor());
        }
    }

    private void drawTrack(Graphics2D g, JXMapViewer map, GpsArea visibleArea, Color color) {
        for (int i = 1; i < this.track.length; ++i) {
            if (this.track[i] == null || !visibleArea.contains(this.track[i].getPosition())) continue;
            Point2D wp1 = map.getTileFactory().geoToPixel(this.track[i - 1].getPosition(), map.getZoom());
            int x1 = (int)Math.round(wp1.getX());
            int y1 = (int)Math.round(wp1.getY());
            Point2D wp2 = map.getTileFactory().geoToPixel(this.track[i].getPosition(), map.getZoom());
            int x2 = (int)Math.round(wp2.getX());
            int y2 = (int)Math.round(wp2.getY());
            if (SimConnectUtil.getInstance().getSelectionStart() != null && SimConnectUtil.getInstance().getSelectionEnd() != null && i - 1 > SimConnectUtil.getInstance().getSelectionStart() && i - 1 <= SimConnectUtil.getInstance().getSelectionEnd()) {
                g.setColor(Color.BLUE);
            } else if (color == null) {
                if (!SettingsBean.getInstance().isConnectedToSimAndHasData() || !SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack()) {
                    g.setColor(this.track[i - 1].getColor());
                } else {
                    g.setColor(Color.WHITE);
                }
            } else {
                g.setColor(color);
            }
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private UserTrackBean[] getUserTrackBeanArray(List<ExtConnectBean> userTrack) {
        int i = 0;
        UserTrackBean[] track = new UserTrackBean[userTrack.size()];
        for (ExtConnectBean bean : userTrack.toArray(new ExtConnectBean[userTrack.size()])) {
            if (bean.getUserAlt() == null || bean.getUserLon() == null) continue;
            track[i] = new UserTrackBean(new GeoPosition(bean.getUserLat().floatValue(), bean.getUserLon().floatValue()));
            if (bean.getUserAltAboveTerrain() != null) {
                track[i].setColor(SettingsBean.getInstance().getColorTheme().getTrackColor(bean.getUserAltAboveTerrain().floatValue() + SimConnectUtil.getInstance().getGroundAltitudeOffset()));
            } else {
                track[i].setColor(Color.WHITE);
            }
            track[i].setTrueHeading(bean.getUserTrueHeading());
            ++i;
        }
        return track;
    }
}

