/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.UserPointsFilter;
import main.java.guru.vfrflight.core.dto.UserPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class UserPointsPainter
extends VfrPainter {
    private Set<UserPointDTO> pointsList;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);

    public UserPointsPainter(GpsArea visibleArea, Set<UserPointDTO> pointsList) {
        this.visibleArea = visibleArea;
        this.pointsList = pointsList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        UserPointsFilter filter = MapObjectsBean.getInstance().getUserPointsFilter();
        for (UserPointDTO wp : this.pointsList) {
            if (!wp.isInside(visibleArea) || !filter.checkDisplayUserPoint(wp)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color color = ColorUtil.COLOR_SET[Math.abs(StringUtil.nullToEmpty(wp.getTags()).hashCode()) % ColorUtil.COLOR_SET.length];
            Color strokeColor = ColorUtil.newColorWithOpacity(ColorUtil.newColorInverted(color), 0.3f);
            GraphicsUtil.drawUserPoint(g, x, y, color, strokeColor);
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setFont(LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(wp.getName(), g);
            this.applyTextLabelsRotation(g, x, y);
            if (strokeColor == null) {
                g.drawString(wp.getName(), (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25);
            } else {
                GraphicsUtil.drawBoxedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25, wp.getName(), LABEL_FONT, SettingsBean.getInstance().getColorTheme().getUserPointColorOnMap(), SettingsBean.getInstance().getColorTheme().getUserPointStrokeColorOnMap(), 2);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

