/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import main.java.guru.vfrflight.core.MouseCursorInfo;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class TextUnderCursorPainter
extends VfrPainter {
    private List<MouseCursorInfo> textUnderCursor;

    public TextUnderCursorPainter(GpsArea visibleArea, List<MouseCursorInfo> textUnderCursor) {
        this.visibleArea = visibleArea;
        this.textUnderCursor = textUnderCursor;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        Color stroke = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        Color color = Color.BLUE;
        for (MouseCursorInfo i : this.textUnderCursor) {
            if (!i.isShape() || !i.isInside(visibleArea)) continue;
            GraphicsUtil.drawMapShape(g, map, i.getShape(), false, Color.BLACK, null, new BasicStroke(13.0f), visibleArea);
            GraphicsUtil.drawMapShape(g, map, i.getShape(), false, i.getBackgroundColor(), null, new BasicStroke(7.0f), visibleArea);
        }
        for (MouseCursorInfo i : this.textUnderCursor) {
            if (!i.isPoint() || !i.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(i.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            GraphicsUtil.drawSimpleMarker(g, x, y, 7, color, stroke);
        }
    }
}

