/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.TerrainLayerFilter;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class TerrainPainter
implements PriorityPainter<JXMapViewer> {
    private TerrainMesh[] terrainMesh;
    private int priority = 0;
    private GpsArea visibleArea;

    public TerrainPainter(GpsArea visibleArea, TerrainMesh[] terrainMesh) {
        this.visibleArea = visibleArea;
        this.terrainMesh = terrainMesh;
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        this.draw(g, map);
    }

    private void draw(Graphics2D g2d, JXMapViewer map) {
        GpsArea visibleArea = this.visibleArea == null ? MapFrame.getInstance().getVisibleArea() : this.visibleArea;
        TerrainLayerFilter filter = MapObjectsBean.getInstance().getTerrainLayerFilter();
        if (filter.isSolidColor()) {
            g2d.setColor(Color.RED);
        }
        for (int i = 0; i < this.terrainMesh.length; ++i) {
            if (!this.terrainMesh[i].isInside(visibleArea) || !filter.checkDisplayTerrainMesh(this.terrainMesh[i])) continue;
            Point2D ptTopLeft = map.getTileFactory().geoToPixel(this.terrainMesh[i].getTopLeftCorner(), map.getZoom());
            Point2D ptBottomRight = map.getTileFactory().geoToPixel(this.terrainMesh[i].getBottomRightCorner(), map.getZoom());
            int w = Math.abs((int)ptTopLeft.getX() - (int)ptBottomRight.getX());
            int h = Math.abs((int)ptTopLeft.getY() - (int)ptBottomRight.getY());
            if (w <= 0 || h <= 0) continue;
            if (!filter.isSolidColor()) {
                g2d.setColor(this.terrainMesh[i].getColor());
            }
            if (w > 1 || h > 1) {
                g2d.fillRect((int)ptTopLeft.getX(), (int)ptTopLeft.getY(), w, h);
                continue;
            }
            g2d.drawLine((int)ptTopLeft.getX(), (int)ptTopLeft.getY(), (int)ptTopLeft.getX(), (int)ptTopLeft.getY());
        }
    }

    public TerrainMesh[] getTerrainMesh() {
        return this.terrainMesh;
    }

    public void setTerrainMesh(TerrainMesh[] terrainMesh) {
        this.terrainMesh = terrainMesh;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }
}

