/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class TerrainElevationsPainter
implements PriorityPainter<JXMapViewer> {
    private TerrainElevationDTO[] terrainElevations;
    private int priority = 0;
    private GpsArea visibleArea;

    public TerrainElevationsPainter(GpsArea visibleArea, TerrainElevationDTO[] terrainElevations) {
        this.visibleArea = visibleArea;
        this.terrainElevations = terrainElevations;
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        this.draw(g, map);
    }

    private void draw(Graphics2D g2d, JXMapViewer map) {
        GpsArea visibleArea = this.visibleArea == null ? MapFrame.getInstance().getVisibleArea() : this.visibleArea;
        for (int i = 0; i < this.terrainElevations.length; ++i) {
            if (!this.terrainElevations[i].isInside(visibleArea)) continue;
            Point2D ptTopLeft = map.getTileFactory().geoToPixel(this.terrainElevations[i].getArea().getTopLeft().geoPosition(), map.getZoom());
            Point2D ptBottomRight = map.getTileFactory().geoToPixel(this.terrainElevations[i].getArea().getBottomRight().geoPosition(), map.getZoom());
            int w = Math.abs((int)ptTopLeft.getX() - (int)ptBottomRight.getX());
            int h = Math.abs((int)ptTopLeft.getY() - (int)ptBottomRight.getY());
            if (w <= 0 || h <= 0) continue;
            g2d.setColor(this.terrainElevations[i].getColor());
            if (w > 1 || h > 1) {
                g2d.fillRect((int)ptTopLeft.getX(), (int)ptTopLeft.getY(), w, h);
                continue;
            }
            g2d.drawLine((int)ptTopLeft.getX(), (int)ptTopLeft.getY(), (int)ptTopLeft.getX(), (int)ptTopLeft.getY());
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }
}

