/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectTraffic;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class SimConnectTrafficPainter
extends VfrPainter {
    private SimConnectTraffic[] trafficList;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private GpsArea mapDisplayArea;

    public SimConnectTrafficPainter(GpsArea visibleArea, List<SimConnectTraffic> trafficList) {
        this.visibleArea = visibleArea;
        this.trafficList = trafficList.toArray(new SimConnectTraffic[trafficList.size()]);
        this.mapDisplayArea = null;
        int region = SettingsBean.getInstance().getParamMapRegionSelected();
        this.mapDisplayArea = region == 1 ? SettingsBean.getInstance().getMapObjectsUserRegion() : Constants.REGIONS[region];
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setFont(LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        for (SimConnectTraffic wp : this.trafficList) {
            if (!wp.isInside(visibleArea) || this.mapDisplayArea != null && !wp.isInside(this.mapDisplayArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPos(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color color = SettingsBean.getInstance().getColorTheme().getAiTrafficColor();
            if (wp.isOnGround() && SimConnectUtil.getInstance().getExtConnectBean().isOnGround()) {
                color = Color.RED;
            } else if (!wp.isOnGround() && SimConnectUtil.getInstance().getExtConnectBean().isOnGround() || wp.isOnGround() && !SimConnectUtil.getInstance().getExtConnectBean().isOnGround()) {
                color = Color.GREEN;
            } else if (wp.getAltDiffFt() != null && wp.getAltDiffFt() <= 1000.0) {
                color = Color.RED;
            } else if (wp.getAltDiffFt() != null && wp.getAltDiffFt() <= 2000.0) {
                color = Color.YELLOW;
            }
            if (wp.getNextPositionIn10Sec() != null) {
                g.setColor(Color.BLACK);
                g.setStroke(new BasicStroke(1.0f));
                Point2D nextPos = map.getTileFactory().geoToPixel(wp.getNextPositionIn10Sec(), map.getZoom());
                g.drawLine(x, y, (int)Math.round(nextPos.getX()), (int)Math.round(nextPos.getY()));
            }
            GraphicsUtil.drawUserPlaneTop(g, x, y, Float.valueOf((float)wp.getTrueHeading()), 2, false, color, SettingsBean.getInstance().getColorTheme().getAiTrafficStrokeColor());
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            this.applyTextLabelsRotation(g, x, y);
            GraphicsUtil.drawBoxedString(g, (int)((double)x - fm.getStringBounds(wp.getName(), g).getWidth() / 2.0), y + 30, wp.getName(), LABEL_FONT, Color.BLACK, SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 2);
            GraphicsUtil.drawBoxedString(g, (int)((double)x - fm.getStringBounds(wp.getSecondName(), g).getWidth() / 2.0), y + 45, wp.getSecondName(), LABEL_FONT, Color.BLACK, SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 2);
            double alt = wp.getAlt();
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                alt = UnitUtil.recalculateAltitude(alt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            }
            double gs = wp.getGs();
            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
            }
            GraphicsUtil.drawBoxedString(g, x + 30, y - 8, Math.round(gs) + SettingsBean.getInstance().getParamUnitsSpeed(), LABEL_FONT, Color.BLACK, SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 2);
            GraphicsUtil.drawBoxedString(g, x + 30, y + 4, Math.round(alt) + SettingsBean.getInstance().getParamUnitsAltitude(), LABEL_FONT, Color.BLACK, SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 2);
            double vs = 0.0;
            String vsUnit = null;
            int vsRounded = 0;
            if ("m".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                vs = UnitUtil.recalculateVerticalSpeed(wp.getVerticalSpeed(), "fpm", "m/s", false);
                vsUnit = "m/s";
                vsRounded = (int)Math.round(vs);
            } else {
                vs = wp.getVerticalSpeed();
                vsUnit = "fpm";
                vsRounded = (int)Math.round(vs / 100.0) * 100;
            }
            if (vsRounded != 0) {
                String sign = vsRounded > 0 ? "+" : "-";
                GraphicsUtil.drawBoxedString(g, x + 30, y + 16, sign + vsRounded + vsUnit, LABEL_FONT, Color.BLACK, SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 2);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

