/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class RunwaysExtensionsPainter
extends VfrPainter {
    private final RunwayExtensionDTO[] extensionsList;

    public RunwaysExtensionsPainter(GpsArea visibleArea, RunwayExtensionDTO[] extensionsList) {
        this.visibleArea = visibleArea;
        this.extensionsList = extensionsList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setStroke(new BasicStroke(3.0f));
        for (RunwayExtensionDTO wp : this.extensionsList) {
            if (!wp.isInside(visibleArea) || wp.getAirport() != null && !MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(wp.getAirport())) continue;
            for (int i = 1; i < wp.getVertices().length; ++i) {
                Point2D from = map.getTileFactory().geoToPixel(wp.getVertices()[i - 1], map.getZoom());
                Point2D to = map.getTileFactory().geoToPixel(wp.getVertices()[i], map.getZoom());
                int sx = (int)Math.round(from.getX());
                int sy = (int)Math.round(from.getY());
                int ex = (int)Math.round(to.getX());
                int ey = (int)Math.round(to.getY());
                g.setColor(wp.getColors()[i - 1]);
                g.drawLine(sx, sy, ex, ey);
            }
        }
    }
}

