/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.TrackGeoPosition;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class RoutePainter
implements PriorityPainter<JXMapViewer> {
    private List<TrackGeoPosition> track;
    private List<RouteSegment> segments;
    private List<SegmentLandmark> landmarks;
    private List<GpsPlace> selectedVors = null;
    private boolean onCalculatedFrame = false;
    private boolean showCrsAndDist = true;
    private boolean paintVorDistances = false;
    private boolean paintVorNames = false;
    private boolean paintDistanceAndTime = true;
    private boolean drawLandmarkLabels = true;
    private boolean drawDirectionArrow = false;
    private GpsArea visibleArea;
    private int priority = 0;
    private final Font landmarksLabelFont;
    private final Font trueHeadingLabelFont;
    private final Font magHeadingLabelFont;
    private final Font magHeadingSmallLabelFont;
    private final Font climbDescentLabelFont;
    private Double climbingSpeedKt;
    private Double descendingSpeedKt;
    private Double windSpeedKt;
    private Double windDirection;

    public RoutePainter(GpsArea visibleArea, List<TrackGeoPosition> track, int fontSizeModificator) {
        this.visibleArea = visibleArea;
        this.landmarksLabelFont = new Font("SansSerif", 1, 12 + fontSizeModificator);
        this.trueHeadingLabelFont = new Font("SansSerif", 1, 15 + fontSizeModificator);
        this.magHeadingLabelFont = new Font("SansSerif", 1, 24 + fontSizeModificator);
        this.magHeadingSmallLabelFont = new Font("Serif", 1, 15 + fontSizeModificator);
        this.climbDescentLabelFont = new Font("SansSerif", 1, 12 + fontSizeModificator);
        this.track = new ArrayList<TrackGeoPosition>(track);
        if (SettingsBean.getInstance().isCalculateRouteInRealTime()) {
            this.climbingSpeedKt = FlightPlanBean.getInstance().getRoute().getClimbingSpeed();
            this.descendingSpeedKt = FlightPlanBean.getInstance().getRoute().getDescendingSpeed();
            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                if (this.climbingSpeedKt != null) {
                    this.climbingSpeedKt = UnitUtil.recalculateSpeed(this.climbingSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
                }
                if (this.descendingSpeedKt != null) {
                    this.descendingSpeedKt = UnitUtil.recalculateSpeed(this.descendingSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
                }
            }
            this.windSpeedKt = FlightPlanBean.getInstance().getRoute().getWindSpeed();
            if (this.windSpeedKt != null && !"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                this.windSpeedKt = UnitUtil.recalculateWindSpeed(this.windSpeedKt, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
            }
            this.windDirection = FlightPlanBean.getInstance().getRoute().getWindDirection();
        }
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        if (this.segments == null) {
            this.segments = this.calculateSegments(map);
        }
        if (this.track.size() - 1 == this.segments.size()) {
            GpsArea visibleArea = this.visibleArea == null ? MapFrame.getInstance().getVisibleArea() : this.visibleArea;
            this.drawRoute(g, map, this.segments, visibleArea);
            if (this.showCrsAndDist || this.onCalculatedFrame) {
                this.drawHeading(g, map, this.segments, visibleArea);
            }
        }
    }

    private List<RouteSegment> calculateSegments(JXMapViewer map) {
        ArrayList<RouteSegment> segments = new ArrayList<RouteSegment>();
        for (int i = 1; i < this.track.size(); ++i) {
            TrackGeoPosition lastGp = this.track.get(i - 1);
            TrackGeoPosition gp = this.track.get(i);
            RouteSegment segment = new RouteSegment(GpsUtil.getLineSegment(new GpsPlace(new GpsCoord(lastGp.getLatitude()), new GpsCoord(lastGp.getLongitude())), new GpsPlace(new GpsCoord(gp.getLatitude()), new GpsCoord(gp.getLongitude()))));
            segment.setPhantom(gp.isPhantom());
            double magCrs = GpsUtil.normalizeCourse(segment.getCourse() - VfrUtil.getMagneticDeclination(segment));
            segment.setMagneticCourse(magCrs);
            segments.add(segment);
        }
        return segments;
    }

    private void drawRoute(Graphics2D g, JXMapViewer map, List<RouteSegment> segments, GpsArea visibleArea) {
        double r = 14.0;
        for (int i = 1; i < this.track.size(); ++i) {
            float[] dash;
            GeoPosition lastGp = this.track.get(i - 1);
            GeoPosition gp = this.track.get(i);
            Point2D lastPt = map.getTileFactory().geoToPixel(lastGp, map.getZoom());
            Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
            int x = (int)pt.getX();
            int y = (int)pt.getY();
            int lastX = (int)lastPt.getX();
            int lastY = (int)lastPt.getY();
            RouteSegment segment = segments.get(i - 1);
            if (segment.getCourse() == null || !segment.isInside(visibleArea)) continue;
            double crs = GpsUtil.normalizeCourse(segment.getCourse());
            GpsPoint delta = GpsUtil.getVectorCoords(14.0, crs);
            int dx = (int)Math.round(delta.getX());
            int dy = (int)Math.round(delta.getY());
            if (segment.isSelected()) {
                g.setColor(SettingsBean.getInstance().getColorTheme().getRouteBorderColor());
                if (!segment.isPhantom()) {
                    g.setStroke(new BasicStroke(6.0f));
                } else {
                    dash = new float[]{10.0f, 5.0f};
                    g.setStroke(new BasicStroke(6.0f, 0, 0, 3.0f, dash, 0.0f));
                }
                g.drawLine(lastX + dx, lastY + dy, x - dx, y - dy);
                g.setColor(SettingsBean.getInstance().getColorTheme().getRouteColor(true));
                g.setStroke(new BasicStroke(4.0f));
                g.drawLine(lastX + dx, lastY + dy, x - dx, y - dy);
            } else {
                if (!segment.isPhantom()) {
                    g.setStroke(new BasicStroke(7.0f));
                } else {
                    dash = new float[]{10.0f, 5.0f};
                    g.setStroke(new BasicStroke(4.0f, 0, 0, 3.0f, dash, 0.0f));
                }
                g.setColor(SettingsBean.getInstance().getColorTheme().getRouteBorderColor());
                g.drawLine(lastX + dx, lastY + dy, x - dx, y - dy);
                if (this.drawDirectionArrow) {
                    this.drawDirectionArrow(g, x - dx, y - dy, segment.getCourse(), null, SettingsBean.getInstance().getColorTheme().getRouteBorderColor());
                }
                if (!segment.isPhantom()) {
                    g.setStroke(new BasicStroke(3.0f));
                } else {
                    dash = new float[]{10.0f, 5.0f};
                    g.setStroke(new BasicStroke(2.0f, 0, 0, 3.0f, dash, 0.0f));
                }
                g.setColor(SettingsBean.getInstance().getColorTheme().getRouteColor(false));
                g.drawLine(lastX + dx, lastY + dy, x - dx, y - dy);
                if (this.drawDirectionArrow) {
                    this.drawDirectionArrow(g, x - dx, y - dy, segment.getCourse(), SettingsBean.getInstance().getColorTheme().getRouteColor(false), null);
                }
            }
            for (SegmentLandmark landmark : this.getLandmarks()) {
                Point2D wp2;
                if (landmark.getSegmentIndex() != i - 1) continue;
                double len = Math.sqrt(Math.pow(lastX - x, 2.0) + Math.pow(lastY - y, 2.0));
                double rad = landmark.getPosition() * len;
                delta = GpsUtil.getVectorCoords(rad, crs);
                int cx = (int)Math.round((double)lastX + delta.getX() - 1.0);
                int cy = (int)Math.round((double)lastY + delta.getY() - 1.0);
                Point2D wp1 = map.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), map.getZoom());
                GpsPoint closestPoint = GpsUtil.getPointOnSegment(wp1, wp2 = map.getTileFactory().geoToPixel(segment.getTo().geoPosition(), map.getZoom()), new GpsPoint(cx, cy), false);
                if (closestPoint != null) {
                    cx = (int)Math.round(closestPoint.getX());
                    cy = (int)Math.round(closestPoint.getY());
                }
                if (landmark.getDescription() != null && this.drawLandmarkLabels) {
                    String txt = landmark.getDescription();
                    g.setFont(this.landmarksLabelFont);
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D rect = fm.getStringBounds(txt, g);
                    g.setStroke(new BasicStroke(3.0f));
                    g.setColor(Color.BLACK);
                    g.drawLine(cx, cy, cx + 70, cy + 70);
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(Color.WHITE);
                    g.drawLine(cx, cy, cx + 70, cy + 70);
                    GraphicsUtil.drawBoxedString(g, cx - (int)(rect.getWidth() / 2.0) + 70, cy + 70, txt, this.landmarksLabelFont, Color.BLACK, Color.WHITE, 2, Color.BLACK);
                }
                double rotation = Math.toRadians(segment.getCourse());
                double rotation2 = Math.toRadians(-segment.getCourse().doubleValue());
                if (Double.isNaN(rotation) || Double.isNaN(rotation2)) continue;
                if (!this.onCalculatedFrame) {
                    g.translate(cx, cy);
                    g.rotate(rotation);
                    g.translate(-cx, -cy);
                    if (landmark.isSelected()) {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getLandmarkSelectionBorderColor());
                        g.setStroke(new BasicStroke(7.0f));
                        g.drawLine(cx - 5, cy, cx + 4, cy);
                    }
                    g.setColor(SettingsBean.getInstance().getColorTheme().getLandmarkColor());
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine(cx - 5, cy, cx + 4, cy);
                    g.translate(cx, cy);
                    g.rotate(rotation2);
                    g.translate(-cx, -cy);
                    continue;
                }
                Color landmarkColor = null;
                Color landmarkStrokeColor = null;
                if (!landmark.isMinuteInterval()) {
                    landmarkColor = SettingsBean.getInstance().getColorTheme().getLandmarkColor();
                    landmarkStrokeColor = SettingsBean.getInstance().getColorTheme().getLandmarkStrokeColor();
                } else {
                    landmarkColor = SettingsBean.getInstance().getColorTheme().getLandmarkFiveMinColor();
                    landmarkStrokeColor = SettingsBean.getInstance().getColorTheme().getLandmarkFiveMinStrokeColor();
                }
                g.setColor(landmarkColor);
                g.translate(cx, cy);
                g.rotate(rotation);
                g.translate(-cx, -cy);
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(cx - 5, cy, cx + 4, cy);
                String txt = FormatUtil.formatTimeLandmark(landmark.getPosition() * (double)segment.getT());
                g.setFont(this.landmarksLabelFont);
                FontMetrics fm = g.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(txt, g);
                GraphicsUtil.drawOutlinedString(g, cx - (int)rect.getWidth() - 10, cy + (int)Math.round(rect.getHeight() / 3.0), txt, this.landmarksLabelFont, landmarkColor, landmarkStrokeColor, 3.0f);
                g.translate(cx, cy);
                g.rotate(rotation2);
                g.translate(-cx, -cy);
                if (this.getSelectedVors() == null) continue;
                GpsPlace landmarkPlace = MapFrame.getInstance().getPointOnSegment(segment, segment.getDistance() * landmark.getPosition());
                if (segment.getFrom().getAlt() >= segment.getTo().getAlt()) {
                    landmarkPlace.setAlt(segment.getFrom().getAlt() - (segment.getFrom().getAlt() - segment.getTo().getAlt()) * landmark.getPosition());
                } else {
                    landmarkPlace.setAlt(segment.getTo().getAlt() - (segment.getTo().getAlt() - segment.getFrom().getAlt()) * (1.0 - landmark.getPosition()));
                }
                for (GpsPlace vor : this.getSelectedVors()) {
                    LineSegment seg = GpsUtil.getLineSegment(vor, landmarkPlace, true);
                    if (this.isPaintVorNames()) {
                        GraphicsUtil.drawVorRadial(g, cx, cy, seg, 0, this.isPaintVorDistances(), vor.getName(), false, false, false, vor.getMagvar());
                        continue;
                    }
                    GraphicsUtil.drawVorRadial(g, cx, cy, seg, 0, this.isPaintVorDistances(), false, false, vor.getMagvar());
                }
            }
        }
    }

    private void drawDirectionArrow(Graphics2D g, int cx, int cy, double course, Color color, Color strokeColor) {
        double rotation = Math.toRadians(course);
        double rotation2 = Math.toRadians(-course);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g.translate(cx, cy);
            g.rotate(rotation);
            g.translate(-cx, -cy);
            if (strokeColor != null) {
                g.setColor(strokeColor);
                g.setStroke(new BasicStroke(7.0f));
                g.drawLine(cx - 5, cy + 5, cx, cy);
                g.drawLine(cx, cy, cx + 5, cy + 5);
            }
            if (color != null) {
                g.setColor(color);
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(cx - 5, cy + 5, cx, cy);
                g.drawLine(cx, cy, cx + 5, cy + 5);
            }
            g.translate(cx, cy);
            g.rotate(rotation2);
            g.translate(-cx, -cy);
        }
    }

    private void drawHeading(Graphics2D g, JXMapViewer map, List<RouteSegment> segments, GpsArea visibleArea) {
        for (int i = 1; i < this.track.size(); ++i) {
            GeoPosition lastGp = this.track.get(i - 1);
            GeoPosition gp = this.track.get(i);
            Point2D lastPt = map.getTileFactory().geoToPixel(lastGp, map.getZoom());
            Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
            int x = (int)pt.getX();
            int y = (int)pt.getY();
            int lastX = (int)lastPt.getX();
            int lastY = (int)lastPt.getY();
            int cx = lastX + Math.round((x - lastX) / 2);
            int cy = lastY + Math.round((y - lastY) / 2);
            RouteSegment segment = segments.get(i - 1);
            if (segment.getCourse() == null || !segment.isInside(visibleArea)) continue;
            this.calculateClimbAndAngle(segment);
            int rotOffset = segment.getCourse() >= 180.0 && segment.getCourse() < 360.0 || this.onCalculatedFrame ? 0 : 180;
            StringBuilder txt = new StringBuilder();
            double dist = segment.getDistance();
            if (!SettingsBean.getInstance().calculateRouteInRealTime() && !"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                dist = UnitUtil.recalculateDistance(segment.getDistance(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            String segmentDistanceStr = NumberUtil.roundDouble(dist) + SettingsBean.getInstance().getParamUnitsDistance();
            if (this.onCalculatedFrame || !SettingsBean.getInstance().calculateRouteInRealTime()) {
                if (!this.onCalculatedFrame) {
                    if (segment.getMagneticCourse() == null) {
                        txt.append(SettingsBean.getInstance().getTrueTrackPrefix());
                        txt.append(FormatUtil.formattedCourse(segment.getCourse(), true));
                    } else {
                        txt.append(SettingsBean.getInstance().getMagTrackPrefix());
                        txt.append(FormatUtil.formattedCourse(segment.getMagneticCourse(), true));
                    }
                    txt.append("/");
                    txt.append(segmentDistanceStr);
                } else {
                    txt.append(FormatUtil.formattedCourse(segment.getKm(), false));
                    rotOffset -= 90;
                }
            } else {
                txt.append(SettingsBean.getInstance().getMagHdgPrefix());
                txt.append(FormatUtil.formattedCourse(segment.getKm(), false));
                txt.append(" / ");
                txt.append(segmentDistanceStr);
                txt.append(" / ");
                txt.append(FormatUtil.formatTimeLandmark(segment.getT()));
            }
            double rotation = Math.toRadians(segment.getCourse() + 90.0 + (double)rotOffset);
            double rotation2 = Math.toRadians(-segment.getCourse().doubleValue() - 90.0 - (double)rotOffset);
            if (Double.isNaN(rotation) || Double.isNaN(rotation2)) continue;
            g.translate(cx, cy);
            g.rotate(rotation);
            g.translate(-cx, -cy);
            String str = txt.toString();
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(str, g);
            if (this.onCalculatedFrame || !SettingsBean.getInstance().isCalculateRouteInRealTime()) {
                if (!this.onCalculatedFrame) {
                    GraphicsUtil.drawOutlinedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy - 5, str, this.trueHeadingLabelFont, SettingsBean.getInstance().getColorTheme().getTrueHeadingColor(), SettingsBean.getInstance().getColorTheme().getTrueHeadingStrokeColor(), 3.0f);
                } else {
                    g.setFont(this.magHeadingLabelFont);
                    int offsetX = 10;
                    int offsetY = (int)Math.round(g.getFontMetrics().getStringBounds(str, g).getHeight() / 2.0);
                    if (this.paintDistanceAndTime) {
                        String segmentTimeStr = FormatUtil.formatTimeLandmark(segment.getT());
                        g.setFont(this.magHeadingSmallLabelFont);
                        int segmentDistanceStrWidth = (int)Math.round(g.getFontMetrics().getStringBounds(segmentDistanceStr, g).getWidth());
                        int segmentTimeStrWidth = (int)Math.round(g.getFontMetrics().getStringBounds(segmentTimeStr, g).getWidth());
                        int offsetY2 = (int)Math.round(g.getFontMetrics().getStringBounds(segmentDistanceStr, g).getHeight());
                        int maxWidth = segmentDistanceStrWidth > segmentTimeStrWidth ? segmentDistanceStrWidth : segmentTimeStrWidth;
                        GraphicsUtil.drawOutlinedString(g, cx + offsetX + Math.round((maxWidth - segmentDistanceStrWidth) / 2), cy - offsetY + 1, segmentDistanceStr, this.magHeadingSmallLabelFont, SettingsBean.getInstance().getColorTheme().getMagHeadingColor(), SettingsBean.getInstance().getColorTheme().getMagHeadingStrokeColor(), 3.0f);
                        GraphicsUtil.drawOutlinedString(g, cx + offsetX + Math.round((maxWidth - segmentTimeStrWidth) / 2), cy - offsetY + offsetY2 + 1, segmentTimeStr, this.magHeadingSmallLabelFont, SettingsBean.getInstance().getColorTheme().getMagHeadingColor(), SettingsBean.getInstance().getColorTheme().getMagHeadingStrokeColor(), 3.0f);
                        offsetY2 = Math.round(offsetY2 / 2);
                        g.setStroke(new BasicStroke(3.0f));
                        g.setColor(SettingsBean.getInstance().getColorTheme().getMagHeadingStrokeColor());
                        g.drawLine(cx + offsetX, cy - offsetY2, cx + offsetX + maxWidth, cy - offsetY2);
                        g.setStroke(new BasicStroke(1.0f));
                        g.setColor(SettingsBean.getInstance().getColorTheme().getMagHeadingColor());
                        g.drawLine(cx + offsetX, cy - offsetY2, cx + offsetX + maxWidth, cy - offsetY2);
                        offsetX = offsetX + maxWidth + 3;
                    }
                    GraphicsUtil.drawOutlinedString(g, cx + offsetX, cy, str, this.magHeadingLabelFont, SettingsBean.getInstance().getColorTheme().getMagHeadingColor(), SettingsBean.getInstance().getColorTheme().getMagHeadingStrokeColor(), 3.0f);
                }
            } else {
                GraphicsUtil.drawOutlinedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy - 5, str, this.trueHeadingLabelFont, SettingsBean.getInstance().getColorTheme().getTrueHeadingColor(), SettingsBean.getInstance().getColorTheme().getTrueHeadingStrokeColor(), 3.0f);
            }
            if (!this.onCalculatedFrame && segment.getClimbRate() != null && segment.getClimbAngle() != null) {
                String text = FormatUtil.formatClimbAndAngle(segment.getClimbRate(), segment.getClimbAngle(), this.isClimbRateInFpm());
                g.setFont(this.climbDescentLabelFont);
                GraphicsUtil.drawOutlinedString(g, cx - (int)Math.round(g.getFontMetrics().getStringBounds(text, g).getWidth() / 2.0), cy + 15, text, this.climbDescentLabelFont, SettingsBean.getInstance().getColorTheme().getTrueHeadingColor(), SettingsBean.getInstance().getColorTheme().getTrueHeadingStrokeColor(), 3.0f);
            }
            g.translate(cx, cy);
            g.rotate(rotation2);
            g.translate(-cx, -cy);
        }
    }

    private void calculateClimbAndAngle(RouteSegment segment) {
        if ((this.climbingSpeedKt != null || this.descendingSpeedKt != null) && segment.getFrom().getAlt() != null && segment.getTo().getAlt() != null) {
            double to;
            Double speed = null;
            double from = NumberUtil.roundDouble(segment.getFrom().getAlt(), 3);
            if (from < (to = NumberUtil.roundDouble(segment.getTo().getAlt(), 3))) {
                speed = this.climbingSpeedKt;
            } else if (from > to) {
                speed = this.descendingSpeedKt;
            }
            if (speed != null) {
                if (this.windSpeedKt != null && this.windDirection != null) {
                    speed = VfrUtil.calculateGSForWind(speed, segment.getCourse(), this.windSpeedKt, this.windDirection);
                }
                segment.setClimbRate(GpsUtil.calculateClimbRate(segment.getFrom(), segment.getTo(), speed, this.isClimbRateInFpm()));
                segment.setClimbAngle(GpsUtil.calculateClimbAngle(segment.getFrom(), segment.getTo(), true));
            }
        }
    }

    private boolean isClimbRateInFpm() {
        return "ft".equals(SettingsBean.getInstance().getParamUnitsAltitude());
    }

    public List<RouteSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<RouteSegment> segments) {
        this.segments = segments;
    }

    public boolean isOnCalculatedFrame() {
        return this.onCalculatedFrame;
    }

    public void setOnCalculatedFrame(boolean onCalculatedFrame) {
        this.onCalculatedFrame = onCalculatedFrame;
    }

    public boolean isShowCrsAndDist() {
        return this.showCrsAndDist;
    }

    public void setShowCrsAndDist(boolean showCrsAndDist) {
        this.showCrsAndDist = showCrsAndDist;
    }

    public List<SegmentLandmark> getLandmarks() {
        if (this.landmarks == null) {
            this.landmarks = new ArrayList<SegmentLandmark>();
        }
        return this.landmarks;
    }

    public void setLandmarks(List<SegmentLandmark> landmarks) {
        this.landmarks = landmarks;
    }

    public List<GpsPlace> getSelectedVors() {
        return this.selectedVors;
    }

    public void setSelectedVors(List<GpsPlace> selectedVors) {
        this.selectedVors = selectedVors;
    }

    public boolean isPaintVorDistances() {
        return this.paintVorDistances;
    }

    public void setPaintVorDistances(boolean paintVorDistances) {
        this.paintVorDistances = paintVorDistances;
    }

    public GpsArea getVisibleArea() {
        return this.visibleArea;
    }

    public void setVisibleArea(GpsArea visibleArea) {
        this.visibleArea = visibleArea;
    }

    public boolean isPaintVorNames() {
        return this.paintVorNames;
    }

    public void setPaintVorNames(boolean paintVorNames) {
        this.paintVorNames = paintVorNames;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isPaintDistanceAndTime() {
        return this.paintDistanceAndTime;
    }

    public void setPaintDistanceAndTime(boolean paintDistanceAndTime) {
        this.paintDistanceAndTime = paintDistanceAndTime;
    }

    public boolean isDrawLandmarkLabels() {
        return this.drawLandmarkLabels;
    }

    public void setDrawLandmarkLabels(boolean drawLandmarkLabels) {
        this.drawLandmarkLabels = drawLandmarkLabels;
    }

    public boolean isDrawDirectionArrow() {
        return this.drawDirectionArrow;
    }

    public void setDrawDirectionArrow(boolean drawDirectionArrow) {
        this.drawDirectionArrow = drawDirectionArrow;
    }
}

