/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.WaypointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class PointsPainter
extends VfrPainter {
    private boolean paintVorRadials;
    private boolean paintVorDistances;
    private boolean paintVorNames;
    private boolean showCrsAndDist;
    private GpsPlace[] vors;
    private WaypointDTO[] waypointsList;
    private static final float[] dash = new float[]{5.0f};
    private static final BasicStroke PHANTOM_STROKE_3 = new BasicStroke(3.0f, 0, 0, 3.0f, dash, 0.0f);
    private static final BasicStroke BASIC_STROKE_3 = new BasicStroke(3.0f);
    private static final BasicStroke PHANTOM_STROKE_5 = new BasicStroke(5.0f, 0, 0, 3.0f, dash, 0.0f);
    private static final BasicStroke BASIC_STROKE_5 = new BasicStroke(5.0f);
    private final Font waypointLabelFont;
    private final Font altLabelFont;
    private final int fontSizeModificator;

    public PointsPainter(GpsArea visibleArea, List<WaypointDTO> waypointsList, boolean paintVorRadials, boolean paintVorDistances, boolean paintVorNames, boolean showCrsAndDist, List<GpsPlace> vors, int fontSizeModificator) {
        this.visibleArea = visibleArea;
        this.waypointsList = waypointsList.toArray(new WaypointDTO[waypointsList.size()]);
        if (vors != null) {
            this.vors = vors.toArray(new GpsPlace[vors.size()]);
        }
        this.paintVorRadials = paintVorRadials;
        this.paintVorDistances = paintVorDistances;
        this.paintVorNames = paintVorNames;
        this.showCrsAndDist = showCrsAndDist;
        this.fontSizeModificator = fontSizeModificator;
        this.waypointLabelFont = new Font("SansSerif", 1, 14 + fontSizeModificator);
        this.altLabelFont = new Font("SansSerif", 0, 10 + fontSizeModificator);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (WaypointDTO wp : this.waypointsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            g.setColor(SettingsBean.getInstance().getColorTheme().getWpStrokeColor(wp.isSelected()));
            if (wp.isPhantom()) {
                g.setStroke(PHANTOM_STROKE_5);
            } else {
                g.setStroke(BASIC_STROKE_5);
            }
            g.drawOval(x - 12, y - 12, 23, 23);
            g.setColor(SettingsBean.getInstance().getColorTheme().getWpColor(wp.isSelected()));
            if (wp.isPhantom()) {
                g.setStroke(PHANTOM_STROKE_3);
            } else {
                g.setStroke(BASIC_STROKE_3);
            }
            g.drawOval(x - 12, y - 12, 23, 23);
            if (this.showCrsAndDist) {
                this.applyTextLabelsRotation(g, x, y);
                if (wp.getAlt() != null && (map.getZoom() <= 7 || wp.isSelected())) {
                    String txt = String.valueOf(NumberUtil.roundDouble(wp.getAlt())) + SettingsBean.getInstance().getParamUnitsAltitude();
                    g.setFont(this.altLabelFont);
                    Rectangle2D rect = g.getFontMetrics().getStringBounds(txt, g);
                    GraphicsUtil.drawBoxedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y + (int)Math.round((double)this.fontSizeModificator * 1.5) + 37, txt, this.altLabelFont, Color.RED, Color.WHITE, 1);
                }
                g.setFont(this.waypointLabelFont);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(wp.getName(), g);
                GraphicsUtil.drawOutlinedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y + this.fontSizeModificator + 25, wp.getName(), this.waypointLabelFont, SettingsBean.getInstance().getColorTheme().getWpColor(wp.isSelected()), SettingsBean.getInstance().getColorTheme().getWpStrokeColor(wp.isSelected()), 3.0f);
                this.removeTextLabelsRotation(g, x, y);
            }
            if (!this.isPaintVorRadials()) continue;
            for (GpsPlace vor : this.vors) {
                LineSegment segment = GpsUtil.getLineSegment(vor, new GpsPlace(new GpsCoord(wp.getPosition().getLatitude()), new GpsCoord(wp.getPosition().getLongitude()), wp.getName(), wp.getAlt()), true);
                if (this.isPaintVorNames()) {
                    GraphicsUtil.drawVorRadial(g, x, y, segment, 12, this.isPaintVorDistances(), vor.getName(), false, false, false, vor.getMagvar());
                    continue;
                }
                GraphicsUtil.drawVorRadial(g, x, y, segment, 12, this.isPaintVorDistances(), false, false, vor.getMagvar());
            }
        }
    }

    public boolean isPaintVorRadials() {
        return this.paintVorRadials;
    }

    public void setPaintVorRadials(boolean paintVorRadials) {
        this.paintVorRadials = paintVorRadials;
    }

    public boolean isPaintVorDistances() {
        return this.paintVorDistances;
    }

    public void setPaintVorDistances(boolean paintVorDistances) {
        this.paintVorDistances = paintVorDistances;
    }

    public boolean isPaintVorNames() {
        return this.paintVorNames;
    }

    public void setPaintVorNames(boolean paintVorNames) {
        this.paintVorNames = paintVorNames;
    }

    public boolean isShowCrsAndDist() {
        return this.showCrsAndDist;
    }

    public void setShowCrsAndDist(boolean showCrsAndDist) {
        this.showCrsAndDist = showCrsAndDist;
    }
}

