/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.ObstacleFilter;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class ObstaclesPainter
extends VfrPainter {
    private Set<ObstacleDTO> obstaclesList;
    private static final Font AMSL_LABEL_FONT = new Font("SansSerif", 1, 14);
    private static final Font AGL_LABEL_FONT = new Font("SansSerif", 1, 12);

    public ObstaclesPainter(GpsArea visibleArea, Set<ObstacleDTO> obstaclesList) {
        this.visibleArea = visibleArea;
        this.obstaclesList = obstaclesList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        Color stroke = SettingsBean.getInstance().getColorTheme().getObstacleStrokeColor();
        Color color = SettingsBean.getInstance().getColorTheme().getObstacleColor();
        ObstacleFilter filter = MapObjectsBean.getInstance().getObstacleFilter();
        for (ObstacleDTO o : this.obstaclesList) {
            if (!o.isInside(visibleArea) || !filter.checkDisplayObstacle(o)) continue;
            Point2D center = map.getTileFactory().geoToPixel(o.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            this.applyTextLabelsRotation(g, x, y);
            g.setColor(stroke);
            g.setStroke(new BasicStroke(5.0f));
            if (o.isHigh()) {
                GraphicsUtil.drawHighObstacle(g, x, y, 7, o.isLgt());
            } else {
                GraphicsUtil.drawObstacle(g, x, y, 7, o.isGrp(), o.isLgt());
            }
            g.setColor(color);
            g.setStroke(new BasicStroke(3.0f));
            if (o.isHigh()) {
                GraphicsUtil.drawHighObstacle(g, x, y, 7, o.isLgt());
            } else {
                GraphicsUtil.drawObstacle(g, x, y, 7, o.isGrp(), o.isLgt());
            }
            if (SettingsBean.getInstance().isDrawTextLabels()) {
                Rectangle2D rect;
                String txt;
                FontMetrics fm;
                if (o.getAmsl() != null) {
                    g.setFont(AMSL_LABEL_FONT);
                    fm = g.getFontMetrics();
                    txt = o.getAmsl().toString();
                    rect = fm.getStringBounds(txt, g);
                    int px = (int)Math.round((double)x - rect.getWidth() / 2.0);
                    int py = y + 15;
                    GraphicsUtil.drawOutlinedString(g, px, py, txt, AMSL_LABEL_FONT, color, stroke, 3.0f);
                }
                if (o.getAgl() != null) {
                    g.setFont(AGL_LABEL_FONT);
                    fm = g.getFontMetrics();
                    txt = "(" + o.getAgl().toString() + ")";
                    rect = fm.getStringBounds(txt, g);
                    GraphicsUtil.drawOutlinedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25, txt, AGL_LABEL_FONT, color, stroke, 3.0f);
                }
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

