/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class NewWaypointPainter
extends VfrPainter {
    private NamedWaypoint place;
    private static final int OFFSET = 12;
    private static final int SIZE = 3;

    public NewWaypointPainter(GpsArea visibleArea, GpsPlace place) {
        this.visibleArea = visibleArea;
        this.place = new NamedWaypoint(place.getLat().getValue(), place.getLon().getValue(), null);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (this.place.isInside(visibleArea)) {
            Point2D center = map.getTileFactory().geoToPixel(this.place.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX()) + 12;
            int y = (int)Math.round(center.getY()) - 12;
            g.setStroke(new BasicStroke(5.0f));
            g.setColor(Color.WHITE);
            g.drawLine(x - 3, y, x + 3, y);
            g.drawLine(x, y - 3, x, y + 3);
            g.setStroke(new BasicStroke(3.0f));
            g.setColor(Color.BLACK);
            g.drawLine(x - 3, y, x + 3, y);
            g.drawLine(x, y - 3, x, y + 3);
        }
    }
}

