/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.WaypointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class MarkerPainter
extends VfrPainter {
    private WaypointDTO markerPoint;

    public MarkerPainter(GpsArea visibleArea, GpsPlace markerPlace) {
        this.visibleArea = visibleArea;
        GeoPosition gp = new GeoPosition(markerPlace.getLat().getValue(), markerPlace.getLon().getValue());
        this.markerPoint = new WaypointDTO();
        this.markerPoint.setPosition(gp);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (this.markerPoint.isInside(visibleArea)) {
            Point2D center = map.getTileFactory().geoToPixel(this.markerPoint.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            GraphicsUtil.drawMarker(g, x, y, 7, 35, SettingsBean.getInstance().getColorTheme().getMeteoMarkerColor(), SettingsBean.getInstance().getColorTheme().getMeteoMarkerBorderColor());
        }
    }
}

