/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapVorPainter
extends VfrPainter {
    private Set<NavaidDTO> vorsList;
    private static final Font VOR_LABEL_FONT = new Font("SansSerif", 1, 12);

    public MapVorPainter(GpsArea visibleArea, Set<NavaidDTO> vorsList) {
        this.visibleArea = visibleArea;
        this.vorsList = vorsList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (NavaidDTO wp : this.vorsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color vorColor = SettingsBean.getInstance().getColorTheme().getVorColorOnMap();
            Color vorStrokeColor = SettingsBean.getInstance().getColorTheme().getVorStrokeColorOnMap();
            boolean nav = "VOR".equals(wp.getType()) || "VOR-DME".equals(wp.getType());
            boolean dme = "DME".equals(wp.getType()) || "VOR-DME".equals(wp.getType());
            this.applyTextLabelsRotation(g, x, y);
            GraphicsUtil.drawVorDme(g, x, y, 6, nav, dme, vorColor, vorStrokeColor);
            if (SettingsBean.getInstance().isDrawTextLabels()) {
                if (vorStrokeColor == null) {
                    g.setFont(VOR_LABEL_FONT);
                    g.drawString(wp.getInfoName(), x + 20, y - 2);
                    g.drawString(wp.getInfoFrequency(), x + 20, y + 12);
                } else {
                    GraphicsUtil.drawOutlinedString(g, x + 20, y - 2, wp.getInfoName(), VOR_LABEL_FONT, vorColor, vorStrokeColor, 3.0f);
                    GraphicsUtil.drawOutlinedString(g, x + 20, y + 12, wp.getInfoFrequency(), VOR_LABEL_FONT, vorColor, vorStrokeColor, 3.0f);
                }
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

