/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapShapesPainter
extends VfrPainter {
    private MapShape[] shapes;
    private static final Color SHAPE_COLOR = Color.MAGENTA;
    private static final Color SHAPE_BACKGROUND_COLOR = new Color(1.0f, 0.0f, 1.0f, 0.3f);
    private static final BasicStroke SHAPE_STROKE = new BasicStroke(1.0f);

    public MapShapesPainter(GpsArea visibleArea, MapShape[] shapes) {
        this.visibleArea = visibleArea;
        this.shapes = shapes;
    }

    public MapShapesPainter(GpsArea visibleArea, MapShape shape) {
        this.visibleArea = visibleArea;
        this.shapes = new MapShape[1];
        this.shapes[0] = shape;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (MapShape shape : this.shapes) {
            if (!shape.isInside(visibleArea)) continue;
            GraphicsUtil.drawMapShape(g, map, shape, false, SHAPE_COLOR, SHAPE_BACKGROUND_COLOR, SHAPE_STROKE, visibleArea);
        }
    }
}

