/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.dto.RadialDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapRadialsPainter
extends VfrPainter {
    private RadialDTO[] mapRadialsList;
    private final Double sizeModificator;

    public MapRadialsPainter(GpsArea visibleArea, Route route, Double sizeModificator) {
        this.visibleArea = visibleArea;
        LinkedList<RadialDTO> list = new LinkedList<RadialDTO>();
        for (MapRadials mapRadials : route.getMapRadials()) {
            for (Integer vorIdx : mapRadials.getVorIdxs()) {
                GpsPlace vor = route.getVors().get(vorIdx);
                LineSegment vorRadial = GpsUtil.getVorRadial(vor, mapRadials.getPos());
                RadialDTO mapRadial = new RadialDTO(vorRadial, vor.getName(), mapRadials.isIncludeDistance(), vor.getMagvar());
                mapRadial.setPosition(mapRadials.getPos().geoPosition());
                mapRadial.setSelected(mapRadials.isSelected());
                mapRadial.setDrawRadial(mapRadials.isDrawRadial());
                list.add(mapRadial);
            }
        }
        this.mapRadialsList = list.toArray(new RadialDTO[list.size()]);
        this.sizeModificator = sizeModificator;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (RadialDTO wp : this.mapRadialsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Point2D vor = null;
            if (wp.isDrawRadial()) {
                vor = map.getTileFactory().geoToPixel(wp.getRadial().getFrom().geoPosition(), map.getZoom());
            }
            GraphicsUtil.drawVorRadial(g, x, y, wp.getRadial(), 0, wp.isIncludeDistance(), wp.getName(), true, false, wp.isSelected(), vor, this.sizeModificator, wp.getMagvar());
        }
    }
}

