/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.dto.RadialFromVorDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapRadialsFromVorsPainter
extends VfrPainter {
    private RadialFromVorDTO[] radials;

    public MapRadialsFromVorsPainter(GpsArea visibleArea, RadialFromVorDTO[] radials) {
        this.visibleArea = visibleArea;
        this.radials = radials;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setStroke(new BasicStroke(1.0f));
        this.doDraw(g, map, visibleArea, false, false, null);
        g.setStroke(new BasicStroke(5.0f));
        this.doDraw(g, map, visibleArea, true, false, new Color(0.0f, 0.0f, 0.0f, 0.2f));
        g.setStroke(new BasicStroke(3.0f));
        this.doDraw(g, map, visibleArea, true, false, null);
        g.setStroke(new BasicStroke(7.0f));
        this.doDraw(g, map, visibleArea, true, true, Color.BLACK);
        g.setStroke(new BasicStroke(5.0f));
        this.doDraw(g, map, visibleArea, true, true, null);
    }

    public void doDraw(Graphics2D g, JXMapViewer map, GpsArea visibleArea, boolean major, boolean selected, Color color) {
        for (RadialFromVorDTO wp : this.radials) {
            if ((!selected || !wp.isSelected()) && (wp.isMajor() != major || wp.isSelected() != selected || !wp.isInside(visibleArea))) continue;
            Point2D from = map.getTileFactory().geoToPixel(wp.getFrom(), map.getZoom());
            Point2D to = map.getTileFactory().geoToPixel(wp.getTo(), map.getZoom());
            int fx = (int)Math.round(from.getX());
            int fy = (int)Math.round(from.getY());
            int tx = (int)Math.round(to.getX());
            int ty = (int)Math.round(to.getY());
            g.setColor(color != null ? color : wp.getColor());
            g.drawLine(fx, fy, tx, ty);
        }
    }
}

