/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapNdbPainter
extends VfrPainter {
    private Set<NavaidDTO> ndbsList;
    private static final Font NDB_LABEL_FONT = new Font("SansSerif", 1, 12);

    public MapNdbPainter(GpsArea visibleArea, Set<NavaidDTO> ndbsList) {
        this.visibleArea = visibleArea;
        this.ndbsList = ndbsList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (NavaidDTO wp : this.ndbsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color ndbColor = SettingsBean.getInstance().getColorTheme().getNdbColorOnMap();
            Color ndbStrokeColor = SettingsBean.getInstance().getColorTheme().getNdbStrokeColorOnMap();
            this.applyTextLabelsRotation(g, x, y);
            GraphicsUtil.drawNdb(g, x, y, ndbColor, ndbStrokeColor);
            if (SettingsBean.getInstance().isDrawTextLabels()) {
                if (ndbStrokeColor == null) {
                    g.setFont(NDB_LABEL_FONT);
                    g.drawString(wp.getInfoName(), x + 20, y - 2);
                    g.drawString(wp.getInfoFrequency(), x + 20, y + 12);
                } else {
                    GraphicsUtil.drawOutlinedString(g, x + 20, y - 2, wp.getInfoName(), NDB_LABEL_FONT, ndbColor, ndbStrokeColor, 3.0f);
                    GraphicsUtil.drawOutlinedString(g, x + 20, y + 12, wp.getInfoFrequency(), NDB_LABEL_FONT, ndbColor, ndbStrokeColor, 3.0f);
                }
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

