/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapIlsPainter
extends VfrPainter {
    private IlsDTO[] vorsList;
    private final String pointsNames;
    private static final String SEPARATOR = "|";

    private boolean pointsCointainsName(String name) {
        if (name != null) {
            return this.pointsNames.indexOf(name) >= 0;
        }
        return false;
    }

    public MapIlsPainter(GpsArea visibleArea, IlsDTO[] vorsList, List<RoutePlace> points) {
        this.visibleArea = visibleArea;
        this.vorsList = vorsList;
        if (SettingsBean.getInstance().isShowOnlyEnrouteIls()) {
            StringBuilder sb = new StringBuilder();
            for (GpsPlace gpsPlace : points) {
                if (gpsPlace.getName() == null) continue;
                sb.append(gpsPlace.getName().toUpperCase());
                sb.append(SEPARATOR);
            }
            this.pointsNames = sb.toString();
        } else {
            this.pointsNames = null;
        }
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (IlsDTO wp : this.vorsList) {
            if (!wp.isInside(visibleArea) || wp.getAirport() != null && !MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(wp.getAirport()) || SettingsBean.getInstance().isShowOnlyEnrouteIls() && !this.pointsCointainsName(wp.getAirportCode())) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color ilsColor = SettingsBean.getInstance().getColorTheme().getIlsColorOnMap();
            double heading = wp.getHeading();
            double width = wp.getWidth();
            int length = (int)Math.round(MapUtil.calculateRadiusToPixels(map, wp.getPosition().gpsPlace(), 15.0));
            if (SettingsBean.getInstance().isDrawTextLabels()) {
                GraphicsUtil.drawIls(g, x, y, 2.0f, heading, width, length, ilsColor, SettingsBean.getInstance().getColorTheme().getIlsBackgroundColorOnMap(), wp.getShortInfo(), SettingsBean.getInstance().getColorTheme().getIlsStrokeColorOnMap());
                continue;
            }
            GraphicsUtil.drawIls(g, x, y, 2.0f, heading, width, length, ilsColor, SettingsBean.getInstance().getColorTheme().getIlsBackgroundColorOnMap());
        }
    }
}

