/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.IfrRouteDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapIfrRoutesPainter
extends VfrPainter {
    private IfrRouteDTO[] routes;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);

    public MapIfrRoutesPainter(GpsArea visibleArea, IfrRouteDTO[] routes) {
        this.visibleArea = visibleArea;
        this.routes = routes;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        Color color = SettingsBean.getInstance().getColorTheme().getIfrRouteColor();
        Color strokeColor = SettingsBean.getInstance().getColorTheme().getIfrRouteStrokeColor();
        g.setFont(LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        for (IfrRouteDTO wp : this.routes) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D prev = map.getTileFactory().geoToPixel(wp.getPrevious(), map.getZoom());
            Point2D next = map.getTileFactory().geoToPixel(wp.getNext(), map.getZoom());
            int x = (int)Math.round(prev.getX());
            int y = (int)Math.round(prev.getY());
            int tx = (int)Math.round(next.getX());
            int ty = (int)Math.round(next.getY());
            if (strokeColor != null) {
                g.setColor(strokeColor);
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(x, y, tx, ty);
            }
            g.setColor(color);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(x, y, tx, ty);
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            double heading = GpsUtil.normalizeCourse(wp.getHeading() + 90.0);
            if (heading > 90.0 && heading <= 270.0) {
                heading += 180.0;
            }
            double rotation = Math.toRadians(heading);
            double rotation2 = Math.toRadians(-heading);
            if (Double.isNaN(rotation) || Double.isNaN(rotation2)) continue;
            int cx = (int)Math.round((double)(x + tx) / 2.0);
            int cy = (int)Math.round((double)(y + ty) / 2.0);
            g.translate(cx, cy);
            g.rotate(rotation);
            g.translate(-cx, -cy);
            String txt = wp.getName();
            Rectangle2D rect = fm.getStringBounds(txt, g);
            GraphicsUtil.drawBoxedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy + 5, txt, LABEL_FONT, Color.WHITE, color, 2);
            g.translate(cx, cy);
            g.rotate(rotation2);
            g.translate(-cx, -cy);
        }
    }
}

