/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.IfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapIfrPointsPainter
extends VfrPainter {
    private Set<IfrPointDTO> pointsList;
    private static final Font IFR_POINT_LABEL_FONT = new Font("SansSerif", 1, 12);

    public MapIfrPointsPainter(GpsArea visibleArea, Set<IfrPointDTO> pointsList) {
        this.visibleArea = visibleArea;
        this.pointsList = pointsList;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (IfrPointDTO wp : this.pointsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color color = SettingsBean.getInstance().getColorTheme().getIfrPointColor();
            Color strokeColor = SettingsBean.getInstance().getColorTheme().getIfrPointStrokeColor();
            if (strokeColor != null) {
                g.setColor(strokeColor);
                if (wp.isRouteType()) {
                    GraphicsUtil.drawIfrRoutePoint(g, x, y, 5);
                } else {
                    GraphicsUtil.fillTriangle(g, x, y, 7);
                }
            }
            g.setColor(color);
            g.setStroke(new BasicStroke(2.0f));
            if (wp.isRouteType()) {
                GraphicsUtil.drawIfrRoutePoint(g, x, y, 5);
            } else {
                GraphicsUtil.drawTriangle(g, x, y, 5);
            }
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setFont(IFR_POINT_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            String txt = wp.getName();
            Rectangle2D rect = fm.getStringBounds(txt, g);
            int px = (int)Math.round((double)x - rect.getWidth() / 2.0);
            int py = y + 25;
            this.applyTextLabelsRotation(g, x, y);
            if (strokeColor == null) {
                g.drawString(txt, px, py);
            } else {
                GraphicsUtil.drawOutlinedString(g, px, py, txt, IFR_POINT_LABEL_FONT, color, strokeColor, 3.0f);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

