/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.util.ArrayList;
import java.util.Collections;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.comparator.PainterPriorityComparator;
import main.java.guru.vfrflight.core.dto.WaypointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.painter.AirspacePainter;
import main.java.guru.vfrflight.gui.map.painter.PointsPainter;
import main.java.guru.vfrflight.gui.map.painter.RoutePainter;
import main.java.guru.vfrflight.gui.map.painter.TrackGeoPosition;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.painter.CompoundPainter;

public class MapFrameRoutePainter
extends CompoundPainter<JXMapViewer> {
    public MapFrameRoutePainter(VfrMapViewer mapViewer, GpsArea visibleArea, boolean adjustFontSizeToResolution) {
        Double sizeModificator = null;
        if (adjustFontSizeToResolution) {
            sizeModificator = MapUtil.calculateZoomRatio(visibleArea.getSize(mapViewer, mapViewer.getZoom()));
        }
        ArrayList<TrackGeoPosition> track = new ArrayList<TrackGeoPosition>();
        ArrayList<WaypointDTO> waypointsList = new ArrayList<WaypointDTO>();
        for (RoutePlace wp : FlightPlanBean.getInstance().getRoute().getPoints()) {
            TrackGeoPosition gp = new TrackGeoPosition(wp.getLat().getValue(), wp.getLon().getValue());
            gp.setPhantom(wp.isPhantom());
            track.add(gp);
            WaypointDTO vmwp = new WaypointDTO();
            vmwp.setPosition(gp);
            vmwp.setSelected(wp.isSelected());
            vmwp.setName(wp.getName());
            vmwp.setPhantom(wp.isPhantom());
            vmwp.setAlt(wp.getAlt());
            waypointsList.add(vmwp);
        }
        ArrayList<PriorityPainter<JXMapViewer>> painters = new ArrayList<PriorityPainter<JXMapViewer>>();
        if (waypointsList.size() > 0) {
            int size = 0;
            size = sizeModificator != null ? MapUtil.calculateFontSize(sizeModificator) : SettingsBean.getInstance().getRouteFontSizeModificator();
            RoutePainter routePainter = new RoutePainter(visibleArea, track, size);
            routePainter.setOnCalculatedFrame(false);
            routePainter.setShowCrsAndDist(false);
            routePainter.setLandmarks(FlightPlanBean.getInstance().getRoute().getLandmarks());
            if (SettingsBean.getInstance().calculateRouteInRealTime() || mapViewer.isOnCalculatedFrame()) {
                routePainter.setSegments(FlightPlanBean.getInstance().getRoute().getSegments());
            }
            routePainter.setPaintDistanceAndTime(false);
            routePainter.setDrawLandmarkLabels(false);
            routePainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(1));
            painters.add(routePainter);
            PointsPainter pointsPainter = new PointsPainter(visibleArea, waypointsList, false, false, false, false, null, size);
            pointsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(0));
            painters.add(pointsPainter);
        }
        if (MapObjectsBean.getInstance().getAirspaces() != null) {
            AirspacePainter airspacePainter = new AirspacePainter(visibleArea, MapObjectsBean.getInstance().getAirspaces(), false);
            airspacePainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(20));
            painters.add(airspacePainter);
        }
        Collections.sort(painters, new PainterPriorityComparator());
        this.setPainters(painters);
    }
}

