/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.util.ArrayList;
import java.util.Collections;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.MeteoReport;
import main.java.guru.vfrflight.core.comparator.PainterPriorityComparator;
import main.java.guru.vfrflight.core.dto.WaypointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.painter.AirspacePainter;
import main.java.guru.vfrflight.gui.map.painter.AirspaceReservationsPainter;
import main.java.guru.vfrflight.gui.map.painter.AlternateAirportsPainter;
import main.java.guru.vfrflight.gui.map.painter.CitiesPainter;
import main.java.guru.vfrflight.gui.map.painter.ElevationsPainter;
import main.java.guru.vfrflight.gui.map.painter.EngineLossPainter;
import main.java.guru.vfrflight.gui.map.painter.GridPainter;
import main.java.guru.vfrflight.gui.map.painter.MagneticDeclinationsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapAirportTaxiwaysPainter;
import main.java.guru.vfrflight.gui.map.painter.MapAirportsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapIfrPointsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapIfrRoutesPainter;
import main.java.guru.vfrflight.gui.map.painter.MapIlsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapNdbPainter;
import main.java.guru.vfrflight.gui.map.painter.MapRadialsFromVorsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapRadialsPainter;
import main.java.guru.vfrflight.gui.map.painter.MapShapesPainter;
import main.java.guru.vfrflight.gui.map.painter.MapVorPainter;
import main.java.guru.vfrflight.gui.map.painter.MarkerPainter;
import main.java.guru.vfrflight.gui.map.painter.MeteoImagePainter;
import main.java.guru.vfrflight.gui.map.painter.NewWaypointPainter;
import main.java.guru.vfrflight.gui.map.painter.ObstaclesPainter;
import main.java.guru.vfrflight.gui.map.painter.PointsPainter;
import main.java.guru.vfrflight.gui.map.painter.RoutePainter;
import main.java.guru.vfrflight.gui.map.painter.RunwaysExtensionsPainter;
import main.java.guru.vfrflight.gui.map.painter.SimConnectTrafficPainter;
import main.java.guru.vfrflight.gui.map.painter.TerrainElevationsPainter;
import main.java.guru.vfrflight.gui.map.painter.TerrainPainter;
import main.java.guru.vfrflight.gui.map.painter.TextUnderCursorPainter;
import main.java.guru.vfrflight.gui.map.painter.TouchScreenModeCursorPainter;
import main.java.guru.vfrflight.gui.map.painter.TrackGeoPosition;
import main.java.guru.vfrflight.gui.map.painter.UserPointsPainter;
import main.java.guru.vfrflight.gui.map.painter.UserTrackPainter;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.gui.map.painter.VfrPointsPainter;
import main.java.guru.vfrflight.gui.map.painter.VorNdbPainter;
import main.java.guru.vfrflight.gui.map.painter.WeatherPainter;
import main.java.guru.vfrflight.gui.map.painter.WindSockPainter;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.painter.CompoundPainter;

public class MapFramePainter
extends CompoundPainter<JXMapViewer> {
    public MapFramePainter(VfrMapViewer mapViewer, GpsArea visibleArea, boolean adjustFontSizeToResolution) {
        MapShapesPainter mapShapePainter;
        VfrPainter markerPainter;
        PriorityPainter<JXMapViewer> terrainPainter;
        VfrPointsPainter vfrPointsPainter;
        Double sizeModificator = null;
        if (adjustFontSizeToResolution) {
            sizeModificator = MapUtil.calculateZoomRatio(visibleArea.getSize(mapViewer, mapViewer.getZoom()));
        }
        ArrayList<TrackGeoPosition> track = new ArrayList<TrackGeoPosition>();
        ArrayList<WaypointDTO> waypointsList = new ArrayList<WaypointDTO>();
        double windSockLat = 0.0;
        double windSockLon = 0.0;
        boolean drawWindSock = SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim() && SettingsBean.getInstance().isConnectedToSimAndHasData() || SettingsBean.getInstance().isShowWindSock() && FlightPlanBean.getInstance().getRoute().getPoints().size() > 0 && FlightPlanBean.getInstance().getRoute().getWindSpeed() != null && Math.round(FlightPlanBean.getInstance().getRoute().getWindSpeed()) > 0L;
        for (RoutePlace wp : FlightPlanBean.getInstance().getRoute().getPoints()) {
            TrackGeoPosition gp = new TrackGeoPosition(wp.getLat().getValue(), wp.getLon().getValue());
            gp.setPhantom(wp.isPhantom());
            track.add(gp);
            WaypointDTO vmwp = new WaypointDTO();
            vmwp.setPosition(gp);
            vmwp.setSelected(wp.isSelected());
            vmwp.setName(wp.getName());
            vmwp.setPhantom(wp.isPhantom());
            vmwp.setAlt(wp.getAlt());
            waypointsList.add(vmwp);
            windSockLat += wp.getLat().getValue();
            windSockLon += wp.getLon().getValue();
        }
        if (drawWindSock) {
            if (waypointsList.size() == 0 && SettingsBean.getInstance().isConnectedToSimAndHasData() && SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim()) {
                windSockLat = (double)SimConnectUtil.getInstance().getExtConnectBean().getUserLat().floatValue() + 0.03;
                windSockLon = (double)SimConnectUtil.getInstance().getExtConnectBean().getUserLon().floatValue() + 0.05;
            } else {
                windSockLat /= (double)waypointsList.size();
                windSockLon /= (double)waypointsList.size();
            }
            double windSockRad = 1.0 / (double)mapViewer.getZoom() * 500.0;
            FlightPlanBean.getInstance().getRoute().getWindSock().setCalcRadius(windSockRad);
            FlightPlanBean.getInstance().getRoute().getWindSock().setCalcLat(windSockLat);
            FlightPlanBean.getInstance().getRoute().getWindSock().setCalcLon(windSockLon);
        }
        ArrayList<Object> painters = new ArrayList<Object>();
        int fontSizeModificator = 0;
        fontSizeModificator = sizeModificator != null ? MapUtil.calculateFontSize(sizeModificator) : SettingsBean.getInstance().getRouteFontSizeModificator();
        if (SettingsBean.getInstance().isShowMapRadials() && FlightPlanBean.getInstance().getRoute().getVors().size() > 0 && FlightPlanBean.getInstance().getRoute().getMapRadials().size() > 0) {
            MapRadialsPainter mapRadialsPainter = new MapRadialsPainter(visibleArea, FlightPlanBean.getInstance().getRoute(), (20.0 + (double)fontSizeModificator) / 20.0);
            mapRadialsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(16));
            painters.add(mapRadialsPainter);
        }
        if (SettingsBean.getInstance().isShowVor() && FlightPlanBean.getInstance().getRoute().getVors().size() > 0) {
            VorNdbPainter vorPainter = new VorNdbPainter(visibleArea, FlightPlanBean.getInstance().getRoute().getVors(), mapViewer.isOnCalculatedFrame(), mapViewer.isPaintVorRadials(), fontSizeModificator);
            vorPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(2));
            painters.add(vorPainter);
        }
        if (drawWindSock && FlightPlanBean.getInstance().getRoute().getWindDirection() != null && FlightPlanBean.getInstance().getRoute().getWindSpeed() != null) {
            WindSockPainter windSockPainter = new WindSockPainter(visibleArea, FlightPlanBean.getInstance().getRoute().getWindSock(), FlightPlanBean.getInstance().getRoute().getWindDirection(), FlightPlanBean.getInstance().getRoute().getWindSpeed(), sizeModificator);
            windSockPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(5));
            painters.add(windSockPainter);
        }
        if (waypointsList.size() > 0) {
            RoutePainter routePainter = new RoutePainter(visibleArea, track, fontSizeModificator);
            routePainter.setOnCalculatedFrame(mapViewer.isOnCalculatedFrame());
            routePainter.setShowCrsAndDist(SettingsBean.getInstance().isShowCrsAndDist());
            routePainter.setLandmarks(FlightPlanBean.getInstance().getRoute().getLandmarks());
            if (SettingsBean.getInstance().calculateRouteInRealTime() || mapViewer.isOnCalculatedFrame()) {
                routePainter.setSegments(FlightPlanBean.getInstance().getRoute().getSegments());
            }
            if (mapViewer.isOnCalculatedFrame()) {
                routePainter.setPaintDistanceAndTime(mapViewer.isCalculationResultPaintDistanceAndTime());
            }
            if (mapViewer.isPaintVorRadials() && FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors().size() > 0) {
                routePainter.setSelectedVors(FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors());
                routePainter.setPaintVorDistances(mapViewer.isPaintVorDistances());
                routePainter.setPaintVorNames(mapViewer.isPaintVorNames());
            }
            routePainter.setDrawLandmarkLabels(SettingsBean.getInstance().isDrawLandmarkLabels());
            routePainter.setDrawDirectionArrow(SettingsBean.getInstance().isDrawDirectionArrows());
            routePainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(1));
            painters.add(routePainter);
            PointsPainter pointsPainter = new PointsPainter(visibleArea, waypointsList, mapViewer.isPaintVorRadials(), mapViewer.isPaintVorDistances(), mapViewer.isPaintVorNames(), SettingsBean.getInstance().isShowCrsAndDist(), FlightPlanBean.getInstance().getCalculationDialogDrawRadialsVors(), fontSizeModificator);
            pointsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(0));
            painters.add(pointsPainter);
            if (MapObjectsBean.getInstance().getNewWaypoint() != null) {
                NewWaypointPainter painter = new NewWaypointPainter(visibleArea, MapObjectsBean.getInstance().getNewWaypoint());
                painter.setPriority(1001);
                painters.add(painter);
            }
        }
        if (SettingsBean.getInstance().isDrawAllAirports()) {
            MapAirportsPainter mapAirportsPainter = new MapAirportsPainter(visibleArea, MapObjectsBean.getInstance().getAirports(visibleArea));
            mapAirportsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(8));
            painters.add(mapAirportsPainter);
            if (FlightPlanBean.getInstance().getRoute().getAlternateAirports().size() > 0) {
                AlternateAirportsPainter alternateAirportsPainter = new AlternateAirportsPainter(visibleArea, FlightPlanBean.getInstance().getRoute().getAlternateAirports());
                alternateAirportsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(8) - 1);
                painters.add(alternateAirportsPainter);
            }
        }
        if (SettingsBean.getInstance().isDrawRunwayExtensions() && MapObjectsBean.getInstance().getRunwayExtensions() != null) {
            RunwaysExtensionsPainter extensionsPainter = new RunwaysExtensionsPainter(visibleArea, MapObjectsBean.getInstance().getRunwayExtensions());
            extensionsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(9));
            painters.add(extensionsPainter);
        }
        if (MapObjectsBean.getInstance().getAirspaces() != null) {
            AirspacePainter airspacePainter = new AirspacePainter(visibleArea, MapObjectsBean.getInstance().getAirspaces(), SettingsBean.getInstance().isDrawTextLabels());
            airspacePainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(20));
            painters.add(airspacePainter);
        }
        if (SettingsBean.getInstance().isDrawVfrPoints() && mapViewer.getZoom() <= 10 && (vfrPointsPainter = new VfrPointsPainter(visibleArea, MapObjectsBean.getInstance().getVfrPoints(visibleArea))).hasPoints()) {
            vfrPointsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(17));
            painters.add(vfrPointsPainter);
        }
        if (SettingsBean.getInstance().isDrawTerrainElevations() && MapObjectsBean.getInstance().getTerrainElevations() != null) {
            terrainPainter = new TerrainElevationsPainter(visibleArea, MapObjectsBean.getInstance().getTerrainElevations());
            ((TerrainElevationsPainter)terrainPainter).setPriority(SettingsBean.getInstance().getMapPriorities().get(22));
            painters.add(terrainPainter);
        }
        if (MapFramePainter.isInsideDrawnRegion(visibleArea == null ? MapFrame.getInstance().getVisibleArea() : visibleArea, mapViewer.getZoom())) {
            if (SettingsBean.getInstance().isDrawElevations() && mapViewer.getZoom() <= 11) {
                ElevationsPainter elevationsPainter = new ElevationsPainter(visibleArea, MapObjectsBean.getInstance().getElevations(visibleArea), mapViewer.getZoom() == 11);
                elevationsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(14));
                painters.add(elevationsPainter);
            }
            if (SettingsBean.getInstance().isDrawAllIls() && mapViewer.getZoom() <= 11 && MapObjectsBean.getInstance().getIls() != null) {
                MapIlsPainter mapIlsPainter = new MapIlsPainter(visibleArea, MapObjectsBean.getInstance().getIls(), FlightPlanBean.getInstance().getRoute().getPoints());
                mapIlsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(10));
                painters.add(mapIlsPainter);
            }
            if (SettingsBean.getInstance().isDrawAllVors() && mapViewer.getZoom() <= 11) {
                MapVorPainter mapVorPainter = new MapVorPainter(visibleArea, MapObjectsBean.getInstance().getVors(visibleArea));
                mapVorPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(11));
                painters.add(mapVorPainter);
            }
            if (SettingsBean.getInstance().isDrawRadialsFromVors() && mapViewer.getZoom() <= 11 && MapObjectsBean.getInstance().getRadialsFromVors() != null) {
                MapRadialsFromVorsPainter radialsPainter = new MapRadialsFromVorsPainter(visibleArea, MapObjectsBean.getInstance().getRadialsFromVors());
                radialsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(2));
                painters.add(radialsPainter);
            }
            if (SettingsBean.getInstance().isDrawAllNdbs() && mapViewer.getZoom() <= 11) {
                MapNdbPainter mapNdbPainter = new MapNdbPainter(visibleArea, MapObjectsBean.getInstance().getNdbs(visibleArea));
                mapNdbPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(12));
                painters.add(mapNdbPainter);
            }
            if (SettingsBean.getInstance().isDrawAllUserPoints() && mapViewer.getZoom() <= 11) {
                UserPointsPainter userPointsPainter = new UserPointsPainter(visibleArea, MapObjectsBean.getInstance().getUserPoints(visibleArea));
                userPointsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(7));
                painters.add(userPointsPainter);
            }
            if (SettingsBean.getInstance().isDrawAllIfrPoints() && mapViewer.getZoom() <= 11) {
                MapIfrPointsPainter mapIfrPointsPainter = new MapIfrPointsPainter(visibleArea, MapObjectsBean.getInstance().getIfrPoints(visibleArea));
                mapIfrPointsPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(18));
                painters.add(mapIfrPointsPainter);
            }
            if (SettingsBean.getInstance().isDrawAllIfrRoutes() && mapViewer.getZoom() <= 11 && MapObjectsBean.getInstance().getIfrRoutes() != null) {
                MapIfrRoutesPainter mapIfrRoutesPainter = new MapIfrRoutesPainter(visibleArea, MapObjectsBean.getInstance().getIfrRoutes());
                mapIfrRoutesPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(19));
                painters.add(mapIfrRoutesPainter);
            }
            if (SettingsBean.getInstance().isDrawCities() && mapViewer.getZoom() <= 10) {
                CitiesPainter citiesPainter = new CitiesPainter(visibleArea, MapObjectsBean.getInstance().getCities(visibleArea));
                citiesPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(24));
                painters.add(citiesPainter);
            }
            if (SettingsBean.getInstance().isDrawObstacles() && mapViewer.getZoom() <= 8) {
                ObstaclesPainter obstaclesPainter = new ObstaclesPainter(visibleArea, MapObjectsBean.getInstance().getObstacles(visibleArea));
                obstaclesPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(21));
                painters.add(obstaclesPainter);
            }
            if (SettingsBean.getInstance().isDrawMapObjectsListUnderCursor() && MapObjectsBean.getInstance().getTextUnderCursor().size() > 0) {
                TextUnderCursorPainter textUnderCursorPainter = new TextUnderCursorPainter(visibleArea, MapObjectsBean.getInstance().getTextUnderCursor());
                textUnderCursorPainter.setPriority(100);
                painters.add(textUnderCursorPainter);
            }
            if (SettingsBean.getInstance().isDrawAirportTaxiways() && mapViewer.getZoom() <= 6 && MapObjectsBean.getInstance().getAirportTaxis() != null) {
                MapAirportTaxiwaysPainter taxiwaysPainter = new MapAirportTaxiwaysPainter(visibleArea, MapObjectsBean.getInstance().getAirportTaxis(), 5);
                taxiwaysPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(13));
                painters.add(taxiwaysPainter);
            }
            if (SettingsBean.getInstance().isDrawWeather() && MapObjectsBean.getInstance().getStations().size() > 0) {
                WeatherPainter weatherPainter = new WeatherPainter(visibleArea, MapObjectsBean.getInstance().getStations());
                weatherPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(4));
                painters.add(weatherPainter);
            }
            if (SettingsBean.getInstance().isDrawAirspaceReservations() && MapObjectsBean.getInstance().getAirspaceReservations() != null && MapObjectsBean.getInstance().getAirspaceReservations().length > 0) {
                AirspaceReservationsPainter reservationsPainter = new AirspaceReservationsPainter(visibleArea, MapObjectsBean.getInstance().getAirspaceReservations());
                reservationsPainter.setPriority(1000);
                painters.add(reservationsPainter);
            }
        }
        if (SettingsBean.getInstance().isDrawMagneticDeclinations() && mapViewer.getZoom() <= 13) {
            MagneticDeclinationsPainter declinationsPainter = new MagneticDeclinationsPainter(visibleArea, MapObjectsBean.getInstance().getMagneticDeclinations(visibleArea), mapViewer.getZoom() == 13);
            declinationsPainter.setPriority(15);
            painters.add(declinationsPainter);
        }
        if (mapViewer.isPaintMeteoPoints()) {
            for (MeteoReport wp : FlightPlanBean.getInstance().getRoute().getMeteoReports()) {
                if (!wp.isSelected()) continue;
                MarkerPainter meteoPainter = new MarkerPainter(visibleArea, wp.getPlace());
                meteoPainter.setPriority(100);
                painters.add(meteoPainter);
            }
        }
        if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            markerPainter = new TouchScreenModeCursorPainter(visibleArea, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
            markerPainter.setPriority(100);
            painters.add(markerPainter);
        }
        if (mapViewer.getMarkerPlace() != null) {
            markerPainter = new MarkerPainter(visibleArea, mapViewer.getMarkerPlace());
            markerPainter.setPriority(100);
            painters.add(markerPainter);
        }
        if (MapObjectsBean.getInstance().getHighlightedMapShapes() != null) {
            mapShapePainter = new MapShapesPainter(visibleArea, MapObjectsBean.getInstance().getHighlightedMapShapes());
            mapShapePainter.setPriority(99);
            painters.add(mapShapePainter);
        }
        if (MapObjectsBean.getInstance().getHighlightedMapShape() != null) {
            mapShapePainter = new MapShapesPainter(visibleArea, MapObjectsBean.getInstance().getHighlightedMapShape());
            mapShapePainter.setPriority(99);
            painters.add(mapShapePainter);
        }
        if (SettingsBean.getInstance().isDrawUserTrack() && SimConnectUtil.getInstance().getUserTrack().size() > 0) {
            UserTrackPainter userTrackPainter = new UserTrackPainter(visibleArea, SimConnectUtil.getInstance().getUserTrack());
            userTrackPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(3));
            painters.add(userTrackPainter);
        }
        if (SettingsBean.getInstance().getSimConnectConfigBean().isTraceTraffic() && SimConnectUtil.getInstance().getTraffic().size() > 0) {
            SimConnectTrafficPainter trafficPainter = new SimConnectTrafficPainter(visibleArea, SimConnectUtil.getInstance().getTraffic());
            trafficPainter.setPriority(1000);
            painters.add(trafficPainter);
        }
        if (MapObjectsBean.getInstance().getTerrainMesh() != null) {
            terrainPainter = new TerrainPainter(visibleArea, MapObjectsBean.getInstance().getTerrainMesh());
            ((TerrainPainter)terrainPainter).setPriority(SettingsBean.getInstance().getMapPriorities().get(22));
            painters.add(terrainPainter);
        }
        if (MapObjectsBean.getInstance().getMeteoImageMesh() != null) {
            MeteoImagePainter meteoImagePainter = new MeteoImagePainter(visibleArea, MapObjectsBean.getInstance().getMeteoImageMesh());
            meteoImagePainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(22));
            painters.add(meteoImagePainter);
        }
        if (SettingsBean.getInstance().isDrawMapGrid() && mapViewer.getZoom() <= 15) {
            GridPainter gridPainter = new GridPainter(visibleArea, mapViewer.getZoom(), SettingsBean.getInstance().isParamUseMapDecimalCoords());
            gridPainter.setPriority(SettingsBean.getInstance().getMapPriorities().get(23));
            painters.add(gridPainter);
        }
        if (MapObjectsBean.getInstance().getEngineLossSegments() != null && MapObjectsBean.getInstance().getEngineLossSegments().length > 0) {
            EngineLossPainter linePainter = new EngineLossPainter(visibleArea, MapObjectsBean.getInstance().getEngineLossSegments());
            linePainter.setPriority(-1);
            painters.add(linePainter);
        }
        Collections.sort(painters, new PainterPriorityComparator());
        this.setPainters(painters);
    }

    private static boolean isInsideDrawnRegion(GpsArea visibleArea, int zoom) {
        if (zoom >= 13) {
            return false;
        }
        if (SettingsBean.getInstance().getParamMapRegionSelected() == 0) {
            return true;
        }
        if (SettingsBean.getInstance().getParamMapRegionSelected() == 1 && (SettingsBean.getInstance().getMapObjectsUserRegion().isInside(visibleArea) || visibleArea.isInside(SettingsBean.getInstance().getMapObjectsUserRegion()))) {
            return true;
        }
        return Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()] != null && (Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()].isInside(visibleArea) || visibleArea.isInside(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]));
    }
}

