/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapAirportsPainter
extends VfrPainter {
    private Set<AirportDTO> airports;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Font LABEL_INFO_FONT = new Font("SansSerif", 1, 10);

    public MapAirportsPainter(GpsArea visibleArea, Set<AirportDTO> airports) {
        this.visibleArea = visibleArea;
        this.airports = airports;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        Color hardenedColor = SettingsBean.getInstance().getColorTheme().getAirportColorOnMap(true);
        Color softColor = SettingsBean.getInstance().getColorTheme().getAirportColorOnMap(false);
        Color strokeColor = SettingsBean.getInstance().getColorTheme().getAirportStrokeColorOnMap();
        for (AirportDTO wp : this.airports) {
            if (!wp.isInside(visibleArea) || !MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(wp)) continue;
            Color color = wp.isHardened() ? hardenedColor : softColor;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            if (wp.isHeli()) {
                GraphicsUtil.drawHelipad(g, x, y, 9, color, strokeColor);
            } else {
                GraphicsUtil.drawAirport(g, x, y, 9, wp.getMainRunwayDirection(), color, strokeColor);
            }
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setFont(LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(wp.getIdentOrName(), g);
            int px = (int)Math.round((double)x - rect.getWidth() / 2.0);
            int py = y + 25;
            this.applyTextLabelsRotation(g, x, y);
            if (strokeColor == null) {
                g.drawString(wp.getIdentOrName(), px, py);
            } else {
                GraphicsUtil.drawOutlinedString(g, px, py, wp.getIdentOrName(), LABEL_FONT, color, strokeColor, 3.0f);
            }
            StringBuilder sb = new StringBuilder();
            if (wp.getElevation() != null) {
                int elev = wp.getElevation();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    elev = (int)Math.round(UnitUtil.recalculateAltitude(elev, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
                }
                sb.append(elev);
                sb.append(SettingsBean.getInstance().getParamUnitsAltitude());
            }
            if (wp.getMainLength() != null) {
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                sb.append(wp.getMainLength() + "m");
            }
            String txt = sb.toString().trim();
            g.setFont(LABEL_INFO_FONT);
            rect = g.getFontMetrics().getStringBounds(txt, g);
            px = (int)Math.round((double)x - rect.getWidth() / 2.0);
            if (strokeColor == null) {
                g.drawString(txt, px, py + 10);
            } else {
                GraphicsUtil.drawOutlinedString(g, px, py + 10, txt, LABEL_INFO_FONT, color, strokeColor, 3.0f);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

