/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.dto.AirportTaxiDTO;
import main.java.guru.vfrflight.core.dto.ApronDTO;
import main.java.guru.vfrflight.core.dto.MapRunwayDTO;
import main.java.guru.vfrflight.core.dto.TaxiwayPathDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapAirportTaxiwaysPainter
extends VfrPainter {
    private AirportTaxiDTO[] airportTaxisList;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Color APRON_START = new Color(75, 75, 75);
    private static final Color APRON_COLOR = Color.WHITE;
    private static final Color TAXIWAY_PATH_COLOR = new Color(100, 100, 100);
    private final int minZoomForTaxiNames;

    public MapAirportTaxiwaysPainter(GpsArea visibleArea, AirportTaxiDTO[] airportTaxisList, int minZoomForTaxiNames) {
        this.visibleArea = visibleArea;
        this.airportTaxisList = airportTaxisList;
        this.minZoomForTaxiNames = minZoomForTaxiNames;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        for (AirportTaxiDTO a : this.airportTaxisList) {
            int y;
            int x;
            Point2D center;
            if (a.isInside(visibleArea)) {
                if (a.hasAprons()) {
                    for (ApronDTO apronDTO : a.getAprons()) {
                        if (!apronDTO.isInside(visibleArea)) continue;
                        GraphicsUtil.drawPolygon(g, map, apronDTO.getBoundary(), APRON_COLOR);
                    }
                }
                if (a.hasTaxiwayPaths()) {
                    for (TaxiwayPathDTO taxiwayPathDTO : a.getTaxiwayPaths()) {
                        if (!taxiwayPathDTO.isInside(visibleArea)) continue;
                        GraphicsUtil.drawPolygon(g, map, taxiwayPathDTO.getBoundary(), TAXIWAY_PATH_COLOR);
                    }
                }
                if (a.hasStarts()) {
                    g.setColor(APRON_START);
                    for (NamedWaypoint namedWaypoint : a.getStarts()) {
                        if (!namedWaypoint.isInside(visibleArea)) continue;
                        center = map.getTileFactory().geoToPixel(namedWaypoint.getPosition(), map.getZoom());
                        x = (int)Math.round(center.getX());
                        y = (int)Math.round(center.getY());
                        g.fillOval(x - 1, y - 1, 3, 3);
                    }
                }
            }
            if (a.hasRunways()) {
                this.drawRunways(a.getRunways(), g, map, visibleArea);
            }
            if (!a.isInside(visibleArea) || map.getZoom() > this.minZoomForTaxiNames || !a.hasTaxiNames()) continue;
            for (NamedWaypoint namedWaypoint : a.getTaxiNames()) {
                if (!namedWaypoint.isInside(visibleArea)) continue;
                center = map.getTileFactory().geoToPixel(namedWaypoint.getPosition(), map.getZoom());
                x = (int)Math.round(center.getX());
                y = (int)Math.round(center.getY());
                GraphicsUtil.drawBoxedCenteredString(g, namedWaypoint.getName(), x, y + 6, LABEL_FONT, Color.YELLOW, Color.GRAY, 2);
            }
        }
    }

    private void drawRunways(MapRunwayDTO[] runwaysList, Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        for (MapRunwayDTO rwy : runwaysList) {
            if (!rwy.isInside(visibleArea)) continue;
            int[] bx = new int[4];
            int[] by = new int[4];
            for (int i = 0; i < 4; ++i) {
                Point2D v = map.getTileFactory().geoToPixel(((GpsPlace)rwy.getBoundary()[i]).geoPosition(), map.getZoom());
                bx[i] = (int)Math.round(v.getX());
                by[i] = (int)Math.round(v.getY());
            }
            int idxTo = 0;
            for (int i = 0; i < 4; ++i) {
                idxTo = (idxTo + 1) % 4;
                g.drawLine(bx[i], by[i], bx[idxTo], by[idxTo]);
            }
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.LIGHT_GRAY);
        for (MapRunwayDTO rwy : runwaysList) {
            int y;
            if (!rwy.isInside(visibleArea)) continue;
            int[] px = new int[4];
            int[] py = new int[4];
            for (int i = 0; i < 4; ++i) {
                Point2D v = map.getTileFactory().geoToPixel(((GpsPlace)rwy.getBoundary()[i]).geoPosition(), map.getZoom());
                px[i] = (int)Math.round(v.getX());
                py[i] = (int)Math.round(v.getY());
            }
            g.fillPolygon(new Polygon(px, py, 4));
            if (rwy.getPrimaryThresholdPos() != null) {
                Point2D primaryThresholdPos = map.getTileFactory().geoToPixel(rwy.getPrimaryThresholdPos(), map.getZoom());
                int x = (int)Math.round(primaryThresholdPos.getX());
                y = (int)Math.round(primaryThresholdPos.getY());
                GraphicsUtil.drawBoxedCenteredString(g, StringUtil.nullToEmpty(rwy.getPrimaryRunwayName()), x, y + 6, LABEL_FONT, Color.RED, Color.WHITE, 2);
            }
            if (rwy.getSecondaryThresholdPos() == null) continue;
            Point2D primaryThresholdPos = map.getTileFactory().geoToPixel(rwy.getSecondaryThresholdPos(), map.getZoom());
            int x = (int)Math.round(primaryThresholdPos.getX());
            y = (int)Math.round(primaryThresholdPos.getY());
            GraphicsUtil.drawBoxedCenteredString(g, StringUtil.nullToEmpty(rwy.getSecondaryRunwayName()), x, y + 6, LABEL_FONT, Color.RED, Color.WHITE, 2);
        }
    }
}

