/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MagneticDeclinationsPainter
extends VfrPainter {
    private Set<NamedWaypoint> declinations;
    private boolean smallFont;
    private static final Font LABEL_FONT = new Font("Monospaced", 1, 15);
    private static final Font LABEL_SMALL_FONT = new Font("Monospaced", 1, 11);

    public MagneticDeclinationsPainter(GpsArea visibleArea, Set<NamedWaypoint> declinations, boolean smallFont) {
        this.visibleArea = visibleArea;
        this.declinations = declinations;
        this.smallFont = smallFont;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setFont(this.smallFont ? LABEL_SMALL_FONT : LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        for (NamedWaypoint wp : this.declinations) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            this.applyTextLabelsRotation(g, x, y);
            Rectangle2D rect = fm.getStringBounds(wp.getName(), g);
            GraphicsUtil.drawBoxedString(g, (int)((double)x - rect.getWidth() / 2.0), y + (int)Math.round(rect.getHeight() / 2.0), wp.getName(), this.smallFont ? LABEL_SMALL_FONT : LABEL_FONT, Color.BLUE, Color.WHITE, 2);
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

