/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.ImageMesh;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class ImagePainter
implements PriorityPainter<JXMapViewer> {
    private ImageMesh[] imageMesh;
    private int priority = 0;

    public ImagePainter(ImageMesh[] imageMesh) {
        this.imageMesh = imageMesh;
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        this.draw(g, map);
    }

    private void draw(Graphics2D g, JXMapViewer map) {
        GpsArea visibleArea = MapFrame.getInstance().getVisibleArea();
        for (int i = 0; i < this.imageMesh.length; ++i) {
            if (!this.imageMesh[i].isInside(visibleArea)) continue;
            Point2D ptTopLeft = map.getTileFactory().geoToPixel(this.imageMesh[i].getTopLeftCorner(), map.getZoom());
            Point2D ptBottomRight = map.getTileFactory().geoToPixel(this.imageMesh[i].getBottomRightCorner(), map.getZoom());
            float a = this.imageMesh[i].getA() * 0.175f;
            g.setColor(new Color(this.imageMesh[i].getR(), this.imageMesh[i].getG(), this.imageMesh[i].getB(), a));
            g.fillRect((int)ptTopLeft.getX(), (int)ptTopLeft.getY(), Math.abs((int)ptTopLeft.getX() - (int)ptBottomRight.getX()), Math.abs((int)ptTopLeft.getY() - (int)ptBottomRight.getY()));
        }
    }

    public ImageMesh[] getImageMesh() {
        return this.imageMesh;
    }

    public void setImageMesh(ImageMesh[] imageMesh) {
        this.imageMesh = imageMesh;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }
}

