/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.painter.priority.PriorityPainter;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class GridPainter
implements PriorityPainter<JXMapViewer> {
    private int priority = 0;
    private int zoomLevel;
    private final GpsArea visibleArea;
    private final double gridStepLat;
    private final double gridStepLon;
    private final double decimalDelta;
    private final boolean decimalValue;
    private static final float[] dash = new float[]{2.0f};
    private static final BasicStroke DEGREES_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke MINUTES_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
    private static final Font LABEL_FONT = new Font("Monospaced", 1, 12);

    public GridPainter(GpsArea visibleArea, int zoomLevel, boolean decimalValue) {
        this.visibleArea = visibleArea;
        this.zoomLevel = zoomLevel;
        this.decimalValue = decimalValue;
        if (decimalValue) {
            if (zoomLevel <= 3) {
                this.gridStepLon = this.gridStepLat = 0.005;
            } else if (zoomLevel <= 5) {
                this.gridStepLon = this.gridStepLat = 0.02;
            } else if (zoomLevel <= 6) {
                this.gridStepLon = this.gridStepLat = 0.05;
            } else if (zoomLevel <= 8) {
                this.gridStepLon = this.gridStepLat = 0.1;
            } else if (zoomLevel <= 11) {
                this.gridStepLat = 0.25;
                this.gridStepLon = 0.25;
            } else if (zoomLevel <= 12) {
                this.gridStepLat = 1.0;
                this.gridStepLon = 1.0;
            } else if (zoomLevel <= 13) {
                this.gridStepLat = 2.0;
                this.gridStepLon = 2.0;
            } else if (zoomLevel <= 14) {
                this.gridStepLat = 5.0;
                this.gridStepLon = 5.0;
            } else {
                this.gridStepLat = 10.0;
                this.gridStepLon = 10.0;
            }
        } else if (zoomLevel <= 3) {
            this.gridStepLon = this.gridStepLat = 0.004166666666666667;
        } else if (zoomLevel <= 5) {
            this.gridStepLon = this.gridStepLat = 0.016666666666666666;
        } else if (zoomLevel <= 6) {
            this.gridStepLon = this.gridStepLat = 0.03333333333333333;
        } else if (zoomLevel <= 8) {
            this.gridStepLon = this.gridStepLat = 0.08333333333333333;
        } else if (zoomLevel <= 11) {
            this.gridStepLat = 0.25;
            this.gridStepLon = 0.25;
        } else if (zoomLevel <= 12) {
            this.gridStepLat = 1.0;
            this.gridStepLon = 1.0;
        } else if (zoomLevel <= 13) {
            this.gridStepLat = 2.0;
            this.gridStepLon = 2.0;
        } else if (zoomLevel <= 14) {
            this.gridStepLat = 5.0;
            this.gridStepLon = 5.0;
        } else {
            this.gridStepLat = 10.0;
            this.gridStepLon = 10.0;
        }
        this.decimalDelta = Math.min(this.gridStepLat, this.gridStepLon) / 2.5;
    }

    @Override
    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        GpsArea region;
        GpsArea gpsArea = region = this.visibleArea == null ? MapFrame.getInstance().getVisibleArea() : this.visibleArea;
        if (region != null) {
            g = (Graphics2D)g.create();
            Rectangle rect = map.getViewportBounds();
            g.translate(-rect.x, -rect.y);
            GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
            double minLat = Math.floor(region.getMinLat() / this.gridStepLat) * this.gridStepLat;
            double maxLat = Math.ceil(region.getMaxLat() / this.gridStepLat) * this.gridStepLat;
            double minLon = Math.floor(region.getMinLon() / this.gridStepLon) * this.gridStepLon;
            double maxLon = Math.ceil(region.getMaxLon() / this.gridStepLon) * this.gridStepLon;
            Color gridColor = SettingsBean.getInstance().getColorTheme().getGridTextColor();
            Color boxedColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
            g.setFont(LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            for (double lat = minLat; lat < maxLat; lat += this.gridStepLat) {
                boolean isLatDegrees = NumberUtil.doubleEqualsZero(lat) || Math.abs(lat % (double)Math.round(lat)) <= this.decimalDelta;
                for (double lon = minLon; lon < maxLon; lon += this.gridStepLon) {
                    String txtLon;
                    String txtLat;
                    boolean isLonDegrees;
                    Point2D pos1 = map.getTileFactory().geoToPixel(new GeoPosition(lat, lon), map.getZoom());
                    Point2D pos2 = map.getTileFactory().geoToPixel(new GeoPosition(lat + this.gridStepLat, lon), map.getZoom());
                    Point2D pos3 = map.getTileFactory().geoToPixel(new GeoPosition(lat, lon + this.gridStepLon), map.getZoom());
                    int x = (int)pos1.getX();
                    int y = (int)pos1.getY();
                    boolean bl = isLonDegrees = NumberUtil.doubleEqualsZero(lon) || Math.abs(lon % (double)Math.round(lon)) <= this.decimalDelta;
                    if (isLonDegrees) {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getGridDegreesColor());
                        g.setStroke(DEGREES_STROKE);
                    } else {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getGridMinutesColor());
                        g.setStroke(MINUTES_STROKE);
                    }
                    g.drawLine(x, y, (int)pos2.getX(), (int)pos2.getY());
                    if (isLatDegrees) {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getGridDegreesColor());
                        g.setStroke(DEGREES_STROKE);
                    } else {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getGridMinutesColor());
                        g.setStroke(MINUTES_STROKE);
                    }
                    g.drawLine(x, y, (int)pos3.getX(), (int)pos3.getY());
                    GpsPlace pos = new GpsPlace(lat, lon);
                    if (this.zoomLevel > 9 && (!pos.getLat().hasOnlyDegComponent() || !pos.getLon().hasOnlyDegComponent())) continue;
                    boolean isInteger = false;
                    if (this.decimalValue) {
                        txtLat = NumberUtil.doubleToString(NumberUtil.roundDouble(pos.getLat().getValue(), 3)) + "\u00b0";
                        txtLon = NumberUtil.doubleToString(NumberUtil.roundDouble(pos.getLon().getValue(), 3)) + "\u00b0";
                        isInteger = txtLat.indexOf(46) < 0 && txtLon.indexOf(46) < 0;
                    } else {
                        txtLat = pos.getLatHemisphere() + FormatUtil.formatGpsCoord(pos.getLat(), false, true);
                        txtLon = pos.getLonHemisphere() + FormatUtil.formatGpsCoord(pos.getLon(), false, true);
                        isInteger = txtLat.indexOf("'") < 0 && txtLon.indexOf("'") < 0;
                    }
                    Rectangle2D fontRectLat = fm.getStringBounds(txtLat, g);
                    Rectangle2D fontRectLon = fm.getStringBounds(txtLon, g);
                    this.applyTextLabelsRotation(g, x, y);
                    if (isInteger) {
                        GraphicsUtil.drawBoxedString(g, (int)Math.round((double)x - fontRectLat.getWidth() / 2.0), y - 5, txtLat, LABEL_FONT, Color.WHITE, boxedColor, 1);
                        GraphicsUtil.drawBoxedString(g, (int)Math.round((double)x - fontRectLon.getWidth() / 2.0), y + (int)Math.round(fontRectLon.getHeight() / 2.0) + 5, txtLon, LABEL_FONT, Color.WHITE, boxedColor, 1);
                    } else {
                        g.setColor(gridColor);
                        g.drawString(txtLat, (int)Math.round((double)x - fontRectLat.getWidth() / 2.0), y - 5);
                        g.drawString(txtLon, (int)Math.round((double)x - fontRectLon.getWidth() / 2.0), y + (int)Math.round(fontRectLon.getHeight() / 2.0) + 5);
                    }
                    this.removeTextLabelsRotation(g, x, y);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void removeTextLabelsRotation(Graphics2D g, int x, int y) {
        double rotation;
        if (SettingsBean.getInstance().getTextLabelsRotationAngle() != null && !Double.isNaN(rotation = Math.toRadians(-SettingsBean.getInstance().getTextLabelsRotationAngle().doubleValue()))) {
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
        }
    }

    protected void applyTextLabelsRotation(Graphics2D g, int x, int y) {
        double rotation;
        if (SettingsBean.getInstance().getTextLabelsRotationAngle() != null && !Double.isNaN(rotation = Math.toRadians(SettingsBean.getInstance().getTextLabelsRotationAngle()))) {
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
        }
    }
}

