/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class EngineLossPainter
extends VfrPainter {
    private static final boolean WITH_INDICES = false;
    private static final Font INDEX_FONT = new Font("SansSerif", 1, 12);
    private LineSegment[] segments;

    public EngineLossPainter(GpsArea visibleArea, LineSegment[] segments) {
        this.visibleArea = visibleArea;
        this.segments = segments;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.25f));
        g.setStroke(new BasicStroke(3.0f));
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null || !this.segments[i].isInside(visibleArea)) continue;
            Point2D from = map.getTileFactory().geoToPixel(this.segments[i].getFrom().geoPosition(), map.getZoom());
            Point2D to = map.getTileFactory().geoToPixel(this.segments[i].getTo().geoPosition(), map.getZoom());
            int sx = (int)Math.round(from.getX());
            int sy = (int)Math.round(from.getY());
            int ex = (int)Math.round(to.getX());
            int ey = (int)Math.round(to.getY());
            g.drawLine(sx, sy, ex, ey);
        }
    }
}

