/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.ElevationDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class ElevationsPainter
extends VfrPainter {
    private Set<ElevationDTO> elevations;
    private final boolean smallFont;

    public ElevationsPainter(GpsArea visibleArea, Set<ElevationDTO> elevations, boolean smallFont) {
        this.visibleArea = visibleArea;
        this.elevations = elevations;
        this.smallFont = smallFont;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (ElevationDTO wp : this.elevations) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color elevColor = SettingsBean.getInstance().getColorTheme().getElevColorOnMap(this.smallFont);
            Color elevStrokeColor = SettingsBean.getInstance().getColorTheme().getElevStrokeColorOnMap(this.smallFont);
            String txt = wp.getName();
            this.applyTextLabelsRotation(g, x, y);
            GraphicsUtil.drawMSA(g, x, y, txt, elevColor, elevStrokeColor, this.smallFont);
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

