/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class CitiesPainter
extends VfrPainter {
    private Set<CityDTO> cities;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final short[] CITY_SIZES_MAPPINGS = new short[]{100, 75, 50, 40, 30, 20, 15, 10, 5, 2, 0};

    public CitiesPainter(GpsArea visibleArea, Set<CityDTO> cities) {
        this.visibleArea = visibleArea;
        this.cities = cities;
    }

    private int getPixelsSize(Short size) {
        if (size != null) {
            for (int i = 0; i < CITY_SIZES_MAPPINGS.length; ++i) {
                if (size < CITY_SIZES_MAPPINGS[i]) continue;
                return 3 + (CITY_SIZES_MAPPINGS.length - i);
            }
        }
        return 4;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (CityDTO wp : this.cities) {
            if (wp.isVillage() && map.getZoom() >= 8 || !wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            Color color = SettingsBean.getInstance().getColorTheme().getCityColor();
            Color strokeColor = SettingsBean.getInstance().getColorTheme().getAirportStrokeColorOnMap();
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(color);
            int size = this.getPixelsSize(wp.getSize());
            g.fillOval(x - size, y - size, size * 2 + 1, size * 2 + 1);
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setFont(LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(wp.getName(), g);
            int px = (int)Math.round((double)x - rect.getWidth() / 2.0);
            int py = y + 25;
            this.applyTextLabelsRotation(g, x, y);
            if (strokeColor == null) {
                g.drawString(wp.getName(), px, py);
            } else {
                GraphicsUtil.drawOutlinedString(g, px, py, wp.getName(), LABEL_FONT, color, strokeColor, 3.0f);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }
}

