/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class AlternateAirportsPainter
extends VfrPainter {
    private NamedWaypoint[] airportsList;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 15);

    public AlternateAirportsPainter(GpsArea visibleArea, List<AlternateAirport> airportsList) {
        this.visibleArea = visibleArea;
        this.airportsList = new NamedWaypoint[airportsList.size()];
        for (int i = 0; i < airportsList.size(); ++i) {
            this.airportsList[i] = new NamedWaypoint(airportsList.get(i));
        }
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        Color color = SettingsBean.getInstance().getColorTheme().getAlternateAirportColor();
        Color strokeColor = SettingsBean.getInstance().getColorTheme().getAlternateAirportStrokeColor();
        String txt = Messages.getInstance().get("alternate_airports_map_symbol");
        for (NamedWaypoint wp : this.airportsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            GraphicsUtil.drawOutlinedString(g, x + 8, y - 12, txt, LABEL_FONT, color, strokeColor, 2.0f);
        }
    }
}

