/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AirspaceReservation;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class AirspaceReservationsPainter
extends VfrPainter {
    private AirspaceReservation[] reservations;
    private static final Font AIRSPACE_LABEL_FONT = new Font("SansSerif", 1, 11);
    private static final Color BACKGROUND_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.2f);

    public AirspaceReservationsPainter(GpsArea visibleArea, AirspaceReservation[] reservations) {
        this.visibleArea = visibleArea;
        this.reservations = reservations;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (AirspaceReservation res : this.reservations) {
            if (res.getShape() == null || !res.getShape().isInside(visibleArea)) continue;
            GraphicsUtil.drawMapShape(g, map, res.getShape(), false, Color.BLACK, BACKGROUND_COLOR, res.getShape().getStroke(), visibleArea);
        }
        g.setFont(AIRSPACE_LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        for (AirspaceReservation res : this.reservations) {
            if (res.getShape() == null || !res.getShape().isInside(visibleArea)) continue;
            Point2D textPos = map.getTileFactory().geoToPixel(res.getShape().getCenter(), map.getZoom());
            int cx = (int)textPos.getX();
            int cy = (int)textPos.getY();
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            String str = res.getInfo();
            Rectangle2D rect = fm.getStringBounds(str, g);
            int x = cx - (int)Math.round(rect.getWidth() / 2.0);
            this.applyTextLabelsRotation(g, cx, cy);
            GraphicsUtil.drawBoxedString(g, x, cy, str, AIRSPACE_LABEL_FONT, Color.BLACK, Color.WHITE, 2);
            this.removeTextLabelsRotation(g, cx, cy);
        }
    }
}

