/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.AirspaceFilter;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class AirspacePainter
extends VfrPainter {
    private AirspaceAreaDTO[] airspaces;
    private static final boolean WITH_INDICES = false;
    private final boolean drawLabels;
    private static final Font AIRSPACE_LABEL_FONT = new Font("SansSerif", 1, 11);

    public AirspacePainter(GpsArea visibleArea, AirspaceAreaDTO[] airspaces, boolean drawLabels) {
        this.visibleArea = visibleArea;
        this.airspaces = airspaces;
        this.drawLabels = drawLabels;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (!MapObjectsBean.getInstance().isAirspacesRefreshRunning()) {
            AirspaceFilter filter = MapObjectsBean.getInstance().getAirspaceFilter();
            for (AirspaceAreaDTO area : this.airspaces) {
                Rectangle2D rect;
                FontMetrics fm;
                String str;
                int cy;
                int cx;
                Point2D textPos;
                if (!area.isInside(visibleArea) || !filter.checkDisplayAirspaceArea(area)) continue;
                if (filter.isDrawAtAltitude()) {
                    GraphicsUtil.drawMapShape(g, map, area, false, Color.BLACK, area.getColor(), new BasicStroke(1.0f), visibleArea);
                    if (area.getType() == null) continue;
                    textPos = map.getTileFactory().geoToPixel(area.getCenter(), map.getZoom());
                    cx = (int)textPos.getX();
                    cy = (int)textPos.getY();
                    g.setFont(AIRSPACE_LABEL_FONT);
                    str = area.getType().toString();
                    fm = g.getFontMetrics();
                    rect = fm.getStringBounds(str, g);
                    GraphicsUtil.drawBoxedString(g, cx - (int)Math.round(rect.getWidth() / 2.0), cy, str, AIRSPACE_LABEL_FONT, Color.BLACK, Color.WHITE, 2);
                    continue;
                }
                if (area.getSecondaryStrokeColor() != null) {
                    GraphicsUtil.drawMapShape(g, map, area, false, area.getSecondaryStrokeColor(), null, area.getSecondaryStroke(), visibleArea);
                }
                GraphicsUtil.drawMapShape(g, map, area, false, area.getColor(), area.getBackgroundColor(), area.getStroke(), visibleArea);
                if (!this.drawLabels || map.getZoom() > 9 || area.getCenter() == null) continue;
                textPos = map.getTileFactory().geoToPixel(area.getCenter(), map.getZoom());
                cx = (int)textPos.getX();
                cy = (int)textPos.getY();
                g.setFont(AIRSPACE_LABEL_FONT);
                str = AirspacesUtil.formatAirspaceAreaName(area, SettingsBean.getInstance().isDrawAirspacesIds());
                fm = g.getFontMetrics();
                rect = fm.getStringBounds(str, g);
                int x = cx - (int)Math.round(rect.getWidth() / 2.0);
                this.applyTextLabelsRotation(g, cx, cy);
                GraphicsUtil.drawOutlinedString(g, x, cy, str, AIRSPACE_LABEL_FONT, SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceColor(area.getType()), null, 2.0f);
                this.removeTextLabelsRotation(g, cx, cy);
            }
        }
    }
}

