/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.map.MapObject;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.task.RefreshAirportsTask;
import main.java.guru.vfrflight.gui.task.RefreshAirspacesTask;
import main.java.guru.vfrflight.gui.task.RefreshCitiesTask;
import main.java.guru.vfrflight.gui.task.RefreshIfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshIlsTask;
import main.java.guru.vfrflight.gui.task.RefreshNdbsTask;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVorsTask;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class RemoveMapObjectListener
implements ActionListener {
    private final MapObject mapObject;

    public RemoveMapObjectListener(MapObject mapObject) {
        this.mapObject = mapObject;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("delete"), Messages.getInstance().get("are_you_sure"))) {
            if (MapObjectType.AIRPORT.equals((Object)this.mapObject.getType())) {
                AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
                airportFacade.deleteAirportById(this.mapObject.getId());
                ArrayList tasksList = new ArrayList(2);
                tasksList.add(new RefreshIlsTask());
                tasksList.add(new RefreshAirportsTask());
                try {
                    VfrUtil.executeTaskInFixedPool(tasksList);
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.VORDME.equals((Object)this.mapObject.getType())) {
                NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
                navaidFacade.deleteNavaidById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshVorsTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.NDB.equals((Object)this.mapObject.getType())) {
                NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
                navaidFacade.deleteNavaidById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshNdbsTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.USER_POINT.equals((Object)this.mapObject.getType())) {
                UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
                userPointFacade.deleteUserPointById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshUserPointsTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.CITY.equals((Object)this.mapObject.getType())) {
                CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
                cityFacade.deleteCityById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshCitiesTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.VFR_POINT.equals((Object)this.mapObject.getType())) {
                AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
                airportFacade.deleteVfrPointById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshVfrPointsTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.IFR_POINT.equals((Object)this.mapObject.getType())) {
                IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(DBUtil.getDataSource());
                ifrRouteFacade.deleteIfrPointById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshIfrPointsTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (MapObjectType.AIRSPACE_AREA.equals((Object)this.mapObject.getType())) {
                AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
                airspaceFacade.deleteAirspaceById(this.mapObject.getId());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshAirspacesTask());
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException(e1);
                }
            }
            MapFrame.getInstance().updateMap();
        }
    }
}

