/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import main.java.guru.vfrflight.gui.map.gui.MapButton;

public abstract class MapTextButton
implements MapButton {
    private int x;
    private int y;
    private int width;
    private int height;
    private int horizontalAlign = 0;
    private int verticalAlign = 2;
    private String text;
    private boolean border = true;
    private Font font = new Font("SansSerif", 1, 14);
    private Color textColor = Color.BLACK;
    private Color backgroundColor = Color.LIGHT_GRAY;
    private Color strokeColor = Color.BLACK;
    private int margin = 3;

    public MapTextButton(String text, int x, int y) {
        this.text = text;
        this.x = x;
        this.y = y;
    }

    @Override
    public void paint(Graphics2D g2d, Dimension wrapperDim) {
        if (this.width == 0 || this.height == 0) {
            g2d.setFont(this.font);
            this.width = (int)Math.round(g2d.getFontMetrics().getStringBounds(this.text, g2d).getWidth());
            this.height = Math.round(g2d.getFontMetrics().getAscent());
        }
        int x = this.horizontalAlign == 0 ? this.x : (int)wrapperDim.getWidth() - this.x - this.margin - this.width;
        int y = this.verticalAlign == 2 ? this.y : (int)wrapperDim.getHeight() - this.y - this.margin - this.height;
        g2d.setFont(this.font);
        if (this.border) {
            if (this.strokeColor != null) {
                g2d.setColor(this.strokeColor);
                g2d.drawRect(x - this.margin - 1, y - this.margin - 1, this.width + this.margin * 2 + 1, this.height + this.margin * 2 + 1);
            }
            g2d.setColor(this.backgroundColor);
            g2d.fillRect(x - this.margin, y - this.margin, this.width + this.margin * 2, this.height + this.margin * 2);
        }
        g2d.setColor(this.textColor);
        g2d.drawString(this.text, x, y + this.height - 2);
    }

    @Override
    public boolean contains(int cx, int cy, Dimension wrapperDim) {
        if (this.width == 0 || this.height == 0) {
            return false;
        }
        int x = this.horizontalAlign == 0 ? this.x - this.margin : (int)wrapperDim.getWidth() - this.x - this.width - this.margin;
        int y = this.verticalAlign == 2 ? this.y - this.margin : (int)wrapperDim.getHeight() - this.y - this.height - this.margin;
        return cx >= x && cx <= x + this.width + this.margin * 2 && cy >= y && cy <= y + this.height + this.margin * 2;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(int horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(int verticalAlign) {
        this.verticalAlign = verticalAlign;
    }
}

