/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import main.java.guru.vfrflight.gui.map.gui.MapButton;

public abstract class MapImageButton
implements MapButton {
    private int x;
    private int y;
    private int horizontalAlign = 0;
    private int verticalAlign = 2;
    private BufferedImage icon;
    private boolean border = true;
    private Color backgroundColor = Color.LIGHT_GRAY;
    private Color strokeColor = Color.BLACK;
    private int margin = 3;

    public MapImageButton(BufferedImage icon, int x, int y) {
        this.icon = icon;
        this.x = x;
        this.y = y;
    }

    @Override
    public void paint(Graphics2D g2d, Dimension wrapperDim) {
        int y;
        int x = this.horizontalAlign == 0 ? this.x : (int)wrapperDim.getWidth() - this.x - this.icon.getWidth();
        int n = y = this.verticalAlign == 2 ? this.y : (int)wrapperDim.getHeight() - this.y - this.icon.getHeight();
        if (this.border) {
            if (this.strokeColor != null) {
                g2d.setColor(this.strokeColor);
                g2d.drawRect(x - this.margin - 1, y - this.margin - 1, this.icon.getWidth() + this.margin * 2 + 1, this.icon.getHeight() + this.margin * 2 + 1);
            }
            g2d.setColor(this.backgroundColor);
            g2d.fillRect(x - this.margin, y - this.margin, this.icon.getWidth() + this.margin * 2, this.icon.getHeight() + this.margin * 2);
        }
        g2d.drawImage((Image)this.icon, x, y, null);
    }

    @Override
    public boolean contains(int cx, int cy, Dimension wrapperDim) {
        int x = this.horizontalAlign == 0 ? this.x - this.margin : (int)wrapperDim.getWidth() - this.x - this.icon.getWidth() - this.margin;
        int y = this.verticalAlign == 2 ? this.y - this.margin : (int)wrapperDim.getHeight() - this.y - this.icon.getHeight() - this.margin;
        return cx >= x && cx <= x + this.icon.getWidth() + this.margin * 2 && cy >= y && cy <= y + this.icon.getHeight() + this.margin * 2;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public boolean isImage() {
        return this.icon != null;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public void setIcon(BufferedImage icon) {
        this.icon = icon;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(int horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(int verticalAlign) {
        this.verticalAlign = verticalAlign;
    }
}

