/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.ResourcesBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.bean.filter.UserPointsFilter;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBean;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.WindSock;
import main.java.guru.vfrflight.core.comparator.DistanceComparator;
import main.java.guru.vfrflight.core.comparator.LatLonDistanceComparator;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.dto.IfrPointDTO;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.dto.UserPointDTO;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.core.map.MapMode;
import main.java.guru.vfrflight.core.map.MapObject;
import main.java.guru.vfrflight.core.map.MapSelection;
import main.java.guru.vfrflight.core.map.MapSelectionType;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.AddMapRadialsDialog;
import main.java.guru.vfrflight.gui.flightplan.AirportInfoDialog;
import main.java.guru.vfrflight.gui.flightplan.LandmarkInfoDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionModeDialog;
import main.java.guru.vfrflight.gui.flightplan.WaypointInfoDialog;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.gui.CalculateRouteButton;
import main.java.guru.vfrflight.gui.map.gui.MapButton;
import main.java.guru.vfrflight.gui.map.popup.VfrMapPopupMenu;
import main.java.guru.vfrflight.gui.map.tilefactory.util.TileFactoryInfoUtil;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.apache.log4j.Logger;

public class VfrMapViewer
extends JXMapViewer
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = -2304831838496604048L;
    private static final Logger log = Logger.getLogger(VfrMapViewer.class);
    private final Cache<String, BufferedImage> tilesCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private boolean stopDrawing = false;
    private boolean pointsLocked = false;
    private boolean vorsMouseDrag = false;
    private boolean onCalculatedFrame = false;
    private boolean paintVorRadials = false;
    private boolean paintVorDistances = false;
    private boolean paintVorNames = false;
    private boolean calculationResultPaintDistanceAndTime = true;
    private GpsPlace markerPlace;
    private boolean fullScreenMode = false;
    private boolean paintZoomBar = true;
    private boolean drawClosestVorRadials = false;
    private boolean paintMeteoPoints = false;
    private GpsPoint logoSPoint = null;
    private GpsPoint logoEPoint = null;
    private boolean drawMeasurmentLine = false;
    private GpsPlace measurmentLineStart = null;
    private GpsPlace measurmentLineEnd = null;
    private boolean multipleRulersMode = false;
    private List<LineSegment> measurementLines;
    private MapMode mapMode = MapMode.DEFAULT;
    private boolean drawSelection = false;
    private GpsPlace selectionStart = null;
    private GpsPlace selectionEnd = null;
    private RotatedGpsArea rotatedSelectionArea = null;
    private static final int ZOOM_BAR_HEIGHT = 200;
    private static final Rectangle ZOOM_BAR_PLUS = new Rectangle(30, 55, 40, 40);
    private static final Rectangle ZOOM_BAR_MINUS = new Rectangle(30, 308, 40, 40);
    private static final Rectangle ZOOM_BAR_SLIDER = new Rectangle(30, 90, 40, 220);
    private boolean drawElevationScale = false;
    private Short elevationScaleMin = null;
    private Short elevationScaleMax = null;
    private static final int VK_NONE = -1;
    private int keyPressed = -1;
    private static final double STICKY_POINT_THRESHOLD = 20.0;
    private static final Font WARNINGS_FONT = new Font("SansSerif", 1, 9);
    private static final Font MAGVAR_MODE_FONT = new Font("SansSerif", 2, 12);
    private static final Font NOT_FOR_OPERATIONAL_USE_FONT = new Font("SansSerif", 1, 10);
    private static final Font OPENSTREET_LOGO_FONT = new Font("SansSerif", 1, 12);
    private static final Font DISTANCE_TIME_FONT = new Font("SansSerif", 2, 20);
    private static final Font ZOOM_BAR_FONT = new Font("SansSerif", 1, 20);
    private static final Font USER_POS_LABEL_FONT = new Font("Monospaced", 1, 12);
    private static final Font TEXT_UNDER_CURSOR_LABEL_FONT = new Font("Monospaced", 1, 14);
    private static final Font SMALL_TEXT_UNDER_CURSOR_LABEL_FONT = new Font("Monospaced", 1, 11);
    private final int ELEVATION_SCALE_POS_Y = 10;
    private final int ELEVATION_SCALE_HEIGHT = 15;
    private static final Font ELEVATION_SCALE_LABEL_FONT = new Font("SansSerif", 1, 11);
    private static final Color ELEVATION_SCALE_LABEL_FONT_STROKE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
    private static final Color TEXT_UNDER_CURSOR_BORDER_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final Color TEXT_UNDER_CURSOR_BACKGROUND_COLOR = Color.YELLOW;
    private int mouseX = 0;
    private int mouseY = 0;
    private Rectangle overlayViewerBounds;
    private SelectionModeDialog selectionModeDialog;
    private boolean allowRotationInRectangleDrawMode = false;
    private String infoDistanceTimeValueLabel = null;
    private MapButton fullScreenButton = null;
    private MapButton calculateRouteMapButton;
    private boolean drawCompass = false;
    private boolean drawDistanceCircles = false;
    private Boolean dataFromAip = null;
    private boolean magnifyingGlass = false;
    private boolean coordsCursor = false;
    private BufferedImage magnifyingGlassImage = null;
    private int currentMouseX = 0;
    private int currentMouseY = 0;
    private String nameOfPrevStickyObject = null;
    private final MapFrame mapFrame;
    private static final Font DISTANCE_CIRCLES_LABEL_FONT = new Font("SansSerif", 1, 10);
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private boolean mousePressed = false;
    private MapSelection selectedObject = MapSelection.NONE;

    public VfrMapViewer(MapFrame mapFrame) {
        this.mapFrame = mapFrame;
        this.createCustomGui();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    private void createCustomGui() {
        try {
            this.setLoadingImage(ImageIO.read(new File("img/loading.png")));
        }
        catch (IOException e) {
            log.error("Couldn't open image file to set for loading image", e);
        }
        Color background = this.getBackground();
        this.calculateRouteMapButton = new CalculateRouteButton(15, 25, new Color((float)background.getRed() / 255.0f, (float)background.getGreen() / 255.0f, (float)background.getBlue() / 255.0f, 0.75f));
    }

    @Override
    public Rectangle getViewportBounds() {
        if (this.overlayViewerBounds == null) {
            return super.getViewportBounds();
        }
        return this.overlayViewerBounds;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.stopDrawing) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        this.paintLogo(g2d);
        this.paintNotForOperationalUse(g2d);
        this.paintMapButtons(g2d);
        if (!this.isFullScreenMode()) {
            this.paintDistanceTime(g2d);
            if (SettingsBean.getInstance().isParamShowScaleOnMap()) {
                GraphicsUtil.paintScale(g2d, this);
            }
            if (this.paintZoomBar) {
                this.paintZoomBar(g2d);
            }
            if (this.drawElevationScale) {
                this.paintElevationScale(g2d);
            }
            this.paintMagvarMode(g2d);
            if (SettingsBean.getInstance().isParamShowWarnings()) {
                this.paintWarnings(g2d);
            }
        }
        if (this.multipleRulersMode) {
            this.paintMeasurmentLines(g2d);
        }
        if (this.isPaintMeasurementLine()) {
            this.paintMeasurmentLine(g2d);
        } else if (this.isPaintRectangleSelection()) {
            this.paintSelection(g2d);
        }
        if (MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && !this.mousePressed) {
            this.paintCrossCursor(g2d);
        }
        if (this.isMouseCursorInfoVisible()) {
            this.paintTextUnderCursor(g2d);
        }
        if (SettingsBean.getInstance().isConnectedToSimAndHasData() && SettingsBean.getInstance().getSimConnectConfigBean().isTraceUserPosition()) {
            if (SettingsBean.getInstance().getSimConnectConfigBean().isDrawVector()) {
                this.paintSimConnectVector(g2d);
            }
            this.paintUserPlane(g2d);
        }
        if (this.mapFrame.isMeteoMap()) {
            this.paintMeteoLegend(g2d);
        }
        if (this.drawCompass && !this.mousePressed) {
            this.paintCompass(g2d);
        }
        if (this.drawDistanceCircles && !this.mousePressed) {
            this.paintDistanceCircles(g2d);
        }
        if (this.magnifyingGlass && this.magnifyingGlassImage != null) {
            this.paintMagnifyingGlass(g2d);
        }
        if (this.coordsCursor && !this.mousePressed) {
            this.paintCoordsCursor(g2d);
        }
        if (this.drawClosestVorRadials) {
            this.paintClosestVorRadials(g2d);
        }
    }

    private void paintDistanceCircles(Graphics2D g) {
        if (!SettingsBean.getInstance().isTouchScreenMode() || MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            int x = this.currentMouseX;
            int y = this.currentMouseY;
            if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                x = (int)point.getX();
                y = (int)point.getY();
            }
            if (x >= 0 && y >= 0 && x <= this.getWidth() && y <= this.getHeight()) {
                int radius = (int)Math.round((double)Math.min(this.getWidth(), this.getHeight()) * 0.5);
                int radiusThreshold = (int)Math.round((double)radius * 1.1);
                if (x - radiusThreshold < 0 || y - radiusThreshold < 0 || x + radiusThreshold > this.getWidth() || y + radiusThreshold > this.getHeight()) {
                    radius = Math.min(x, y);
                    radius = Math.min(radius, this.getWidth() - x);
                    radius = Math.min(radius, this.getHeight() - y);
                    radius = (int)Math.round((double)radius / 1.2);
                }
                if (radius >= 50) {
                    GpsPlace centerPlace = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, x, y), this.getZoom()).gpsPlace();
                    GpsPlace scEndPlace = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, x + radius, y), this.getZoom()).gpsPlace();
                    GpsPlace scEndPlace2 = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, x, y + radius), this.getZoom()).gpsPlace();
                    String measurementUnit = SettingsBean.getInstance().getMeasurementLineDistanceUnit();
                    double radiusInNm = (GpsUtil.getDistance(centerPlace, scEndPlace) + GpsUtil.getDistance(centerPlace, scEndPlace2)) / 2.0;
                    double radiusInUnit = UnitUtil.recalculateDistance(radiusInNm, "nm", measurementUnit, false);
                    if (radiusInUnit < 1000.0) {
                        double circleStepNm = 0.25;
                        if (radiusInUnit > 200.0) {
                            circleStepNm = 50.0;
                        } else if (radiusInUnit > 100.0) {
                            circleStepNm = 20.0;
                        } else if (radiusInUnit > 50.0) {
                            circleStepNm = 10.0;
                        } else if (radiusInUnit > 20.0) {
                            circleStepNm = 5.0;
                        } else if (radiusInUnit > 10.0) {
                            circleStepNm = 2.0;
                        } else if (radiusInUnit > 1.0) {
                            circleStepNm = 1.0;
                        }
                        g.setStroke(new BasicStroke(3.0f));
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
                        g.drawLine(x - 5, y, x + 5, y);
                        g.drawLine(x, y - 5, x, y + 5);
                        g.setStroke(new BasicStroke(1.0f));
                        g.setColor(Color.RED);
                        g.drawLine(x - 5, y, x + 5, y);
                        g.drawLine(x, y - 5, x, y + 5);
                        int circlesNum = (int)Math.floor(radiusInUnit / circleStepNm);
                        double circleStepInPx = (double)radius / radiusInUnit * circleStepNm;
                        for (int i = 1; i <= circlesNum; ++i) {
                            int r = (int)Math.round((double)i * circleStepInPx);
                            g.setStroke(new BasicStroke(4.0f));
                            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
                            g.drawOval(x - r, y - r, r * 2, r * 2);
                            g.setStroke(new BasicStroke(2.0f));
                            g.setColor(Color.RED);
                            g.drawOval(x - r, y - r, r * 2, r * 2);
                            String txt = circleStepNm < 1.0 ? String.valueOf((double)i * NumberUtil.roundDouble(circleStepNm, 2)) : String.valueOf(i * (int)circleStepNm);
                            GraphicsUtil.drawBoxedCenteredString(g, txt + measurementUnit, x + r, y + 5, DISTANCE_CIRCLES_LABEL_FONT, Color.RED, Color.YELLOW, 2);
                            GraphicsUtil.drawBoxedCenteredString(g, txt + measurementUnit, x - r, y + 5, DISTANCE_CIRCLES_LABEL_FONT, Color.RED, Color.YELLOW, 2);
                        }
                    }
                }
            }
        }
    }

    private void paintCompass(Graphics2D g) {
        if (!SettingsBean.getInstance().isTouchScreenMode() || MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            int x = this.currentMouseX;
            int y = this.currentMouseY;
            if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                x = (int)point.getX();
                y = (int)point.getY();
            }
            if (x >= 0 && y >= 0 && x <= this.getWidth() && y <= this.getHeight()) {
                int radius = (int)Math.round((double)Math.min(this.getWidth(), this.getHeight()) * 0.45);
                int radiusThreshold = (int)Math.round((double)radius * 1.2);
                if (x - radiusThreshold < 0 || y - radiusThreshold < 0 || x + radiusThreshold > this.getWidth() || y + radiusThreshold > this.getHeight()) {
                    radius = Math.min(x, y);
                    radius = Math.min(radius, this.getWidth() - x);
                    radius = Math.min(radius, this.getHeight() - y);
                    radius = (int)Math.round((double)radius / 1.2);
                }
                if (radius >= 50) {
                    double magvar = SettingsBean.getInstance().getDeclinationCalculator().getMagneticDeclination(this.getGeoPositionAtPos(x, y).gpsPlace());
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
                    g.setStroke(new BasicStroke(5.0f));
                    GraphicsUtil.drawVorCircle(g, x, y, radius, magvar, false, false);
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
                    g.setStroke(new BasicStroke(1.0f));
                    GraphicsUtil.drawVorCircle(g, x, y, radius, magvar, true, false);
                    g.setColor(Color.RED);
                    g.setStroke(new BasicStroke(3.0f));
                    GraphicsUtil.drawVorCircle(g, x, y, radius, magvar, false, true);
                }
            }
        }
    }

    private boolean isMouseCursorInfoVisible() {
        return (SettingsBean.getInstance().isDrawAirspacesListUnderCursor() || SettingsBean.getInstance().isDrawMapObjectsListUnderCursor()) && MapObjectsBean.getInstance().getTextUnderCursor().size() > 0;
    }

    private boolean isPaintMeasurementLine() {
        return !MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && this.drawMeasurmentLine && this.measurmentLineStart != null && this.measurmentLineEnd != null;
    }

    private boolean isPaintRectangleSelection() {
        return MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && this.drawSelection && this.selectionStart != null && this.selectionEnd != null;
    }

    private void paintElevationScale(Graphics2D g) {
        int i;
        int x = (int)(g.getClipBounds().getWidth() - 512.0 - 25.0);
        g.setStroke(new BasicStroke(1.0f));
        for (int i2 = 0; i2 < 512; ++i2) {
            g.setColor(SettingsBean.getInstance().getColorsPalette()[i2]);
            g.drawLine(x + i2, 10, x + i2, 25);
        }
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(Color.BLACK);
        g.drawRect(x - 1, 9, 512, 17);
        int dx = 0;
        for (i = 0; i <= 10; ++i) {
            dx = (int)Math.round((double)(i * 512) / 10.0) - 1;
            g.drawLine(x + dx, 26, x + dx, 36);
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.WHITE);
        g.drawRect(x - 1, 9, 512, 17);
        for (i = 0; i <= 10; ++i) {
            dx = (int)Math.round((double)(i * 512) / 10.0) - 1;
            g.drawLine(x + dx, 26, x + dx, 36);
        }
        String txt = null;
        double step = (double)(this.elevationScaleMax - this.elevationScaleMin) / 10.0;
        g.setFont(ELEVATION_SCALE_LABEL_FONT);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = null;
        for (int i3 = 0; i3 <= 10; ++i3) {
            txt = this.elevationScaleMin + (int)Math.round((double)i3 * step) + SettingsBean.getInstance().getParamUnitsAltitude();
            if (i3 == 0) {
                txt = "<" + txt;
            } else if (i3 == 10) {
                txt = ">" + txt;
            }
            rect = fm.getStringBounds(txt, g);
            dx = (int)Math.round((double)(i3 * 512) / 10.0) - 1;
            GraphicsUtil.drawBoxedString(g, x + dx - (int)Math.round(rect.getWidth() / 2.0), 50, txt, ELEVATION_SCALE_LABEL_FONT, Color.WHITE, ELEVATION_SCALE_LABEL_FONT_STROKE_COLOR, 1);
        }
    }

    private void paintSimConnectVector(Graphics2D g) {
        GpsPlace vectorTo = SettingsBean.getInstance().getSimConnectConfigBean().getVectorTo();
        if (vectorTo != null) {
            GpsPlace vectorInfoPos;
            GpsPlace vectorFrom = SimConnectUtil.getInstance().getExtConnectBean().getGpsPlace();
            LineSegment segment = GpsUtil.getLineSegment(vectorFrom, vectorTo);
            if (segment.isInside(this.mapFrame.getVisibleArea())) {
                GraphicsUtil.drawVector(g, this, segment);
            }
            if ((vectorInfoPos = SettingsBean.getInstance().getSimConnectConfigBean().getVectorInfoPos()) == null) {
                vectorInfoPos = segment.getCenter();
                SettingsBean.getInstance().getSimConnectConfigBean().setVectorInfoPos(vectorInfoPos);
            }
            if (vectorInfoPos.isInside(this.mapFrame.getVisibleArea())) {
                GraphicsUtil.drawVectorInfo(g, this, vectorInfoPos, new RouteSegment(segment));
            }
        }
    }

    private void paintUserPlane(Graphics2D g) {
        ExtConnectBean bean = SimConnectUtil.getInstance().getExtConnectBean();
        GpsPoint center = MapUtil.getMapPosition((JXMapViewer)this, this.getTileFactory().geoToPixel(new GeoPosition(bean.getUserLat().floatValue(), bean.getUserLon().floatValue()), this.getZoom()));
        int x = (int)((Point2D)center).getX();
        int y = (int)((Point2D)center).getY();
        GraphicsUtil.drawUserPlaneTop(g, x, y, bean.getUserTrueHeading(), 4, false);
        if (bean.getUserGs() != null) {
            double gs = bean.getUserGs().floatValue();
            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
            }
            GraphicsUtil.drawBoxedString(g, x + 30, y - 23, Math.round(gs) + SettingsBean.getInstance().getParamUnitsSpeed(), USER_POS_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getUserPosLabelColor(), SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 1);
        }
        if (bean.getUserAlt() != null) {
            double alt = bean.getUserAlt().floatValue();
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                alt = UnitUtil.recalculateAltitude(alt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            }
            GraphicsUtil.drawBoxedString(g, x + 30, y - 8, Math.round(alt) + SettingsBean.getInstance().getParamUnitsAltitude(), USER_POS_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getUserPosLabelColor(), SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 1);
        }
        if (bean.getUserMagHeading() != null) {
            GraphicsUtil.drawBoxedString(g, x + 30, y + 7, FormatUtil.formattedCourse(GpsUtil.normalizeCourse(bean.getUserMagHeading().floatValue()), true), USER_POS_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getUserPosLabelColor(), SettingsBean.getInstance().getColorTheme().getUserPosTextStrokeColor(), 1);
        }
    }

    private void paintSelection(Graphics2D g) {
        if (this.isAllowRotationInRectangleDrawMode()) {
            if (this.rotatedSelectionArea != null) {
                GraphicsUtil.paintRotatedSelectionRectangle(g, this, this.rotatedSelectionArea);
            }
        } else {
            GraphicsUtil.paintSelectionRectangle(g, this, this.getSelectionArea(), this.mousePressed);
        }
    }

    private void paintCrossCursor(Graphics2D g) {
        if (this.mouseX >= 0 && this.mouseY >= 0 && this.mouseX <= this.getWidth() && this.mouseY <= this.getHeight()) {
            g.setColor(GraphicsUtil.SELECTION_STROKE_COLOR);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(this.mouseX, 0, this.mouseX, this.getHeight());
            g.drawLine(0, this.mouseY, this.getWidth(), this.mouseY);
        }
    }

    private void paintMeteoLegend(Graphics2D g) {
        MeteoMapBean bean = MapObjectsBean.getInstance().getMeteoMapBean();
        BufferedImage img = bean.getMapLegends().get((Object)bean.getType());
        if (img != null) {
            g.drawImage((Image)img, 10, this.isCalculateRouteMapButtonVisible() ? 55 : 20, null);
        }
    }

    private void paintTextUnderCursor(Graphics2D g) {
        int x = this.mouseX;
        int y = this.mouseY;
        if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
            x = (int)point.getX();
            y = (int)point.getY();
        }
        if (x >= 0 && y >= 0 && x <= this.getWidth() && y <= this.getHeight()) {
            g.setFont(TEXT_UNDER_CURSOR_LABEL_FONT);
            GraphicsUtil.drawHintPopupWithPosCorrection(g, x, y, MapObjectsBean.getInstance().getTextUnderCursor(), TEXT_UNDER_CURSOR_BACKGROUND_COLOR, TEXT_UNDER_CURSOR_BORDER_COLOR, this.getBounds().getWidth(), this.getBounds().getHeight());
        }
    }

    private void paintCoordsCursor(Graphics2D g) {
        int x = this.currentMouseX;
        int y = this.currentMouseY;
        if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
            x = (int)point.getX();
            y = (int)point.getY();
        }
        g.setColor(GraphicsUtil.SELECTION_STROKE_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x, 0, x, this.getHeight());
        g.drawLine(0, y, this.getWidth(), y);
        GpsPlace pos = this.getGeoPositionAtPos(this.currentMouseX, this.currentMouseY).gpsPlace();
        String txt1 = FormatUtil.formatGpsPos(pos, false);
        String txt2 = FormatUtil.formatGpsPos(pos, true);
        int dy = 0;
        if (y + 150 >= this.getHeight()) {
            dy = -170;
        }
        GraphicsUtil.drawBoxedCenteredString(g, txt2, x, y + 70 + dy, TEXT_UNDER_CURSOR_LABEL_FONT, Color.WHITE, Color.RED, 2);
        GraphicsUtil.drawBoxedCenteredString(g, txt1, x, y + 90 + dy, TEXT_UNDER_CURSOR_LABEL_FONT, Color.WHITE, Color.RED, 2);
        double magvar = VfrUtil.getMagneticDeclination(pos);
        GraphicsUtil.drawBoxedCenteredString(g, String.valueOf(NumberUtil.roundDouble(magvar, 1)), x, y + 110 + dy, SMALL_TEXT_UNDER_CURSOR_LABEL_FONT, Color.BLUE, Color.WHITE, 2);
    }

    private void paintMagnifyingGlass(Graphics2D g) {
        int x = this.currentMouseX;
        int y = this.currentMouseY;
        if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
            x = (int)point.getX();
            y = (int)point.getY();
        }
        if (x >= 0 && y >= 0 && x <= this.getWidth() && y <= this.getHeight()) {
            g.setFont(TEXT_UNDER_CURSOR_LABEL_FONT);
            GraphicsUtil.drawMagnifyingGlass(g, x, y, this.magnifyingGlassImage, this.getBounds().getWidth(), this.getBounds().getHeight());
        }
    }

    private void paintClosestVorRadials(Graphics2D g) {
        if (SettingsBean.getInstance().isShowVor() && FlightPlanBean.getInstance().getRoute().getOnlyVors().size() > 0) {
            int x = this.currentMouseX;
            int y = this.currentMouseY;
            if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                x = (int)point.getX();
                y = (int)point.getY();
            }
            GpsPlace pos = this.getGeoPositionAtPos(x, y).gpsPlace();
            GraphicsUtil.setRenderingHintsHighQuality(g);
            List<LineSegment> radials = FlightPlanBean.getInstance().getRoute().getTwoRadialsFromClosestVors(pos, 200.0);
            for (LineSegment r : radials) {
                GraphicsUtil.drawVorLineRadial(g, this, r, true);
            }
        }
    }

    private void paintMeasurmentLine(Graphics2D g) {
        GraphicsUtil.drawRuler(g, this, GpsUtil.getLineSegment(this.measurmentLineStart, this.measurmentLineEnd));
    }

    private void paintMeasurmentLines(Graphics2D g) {
        if (this.getMeasurementLines().size() > 0) {
            GpsArea visibleArea = this.mapFrame.getVisibleArea();
            for (LineSegment segment : this.getMeasurementLines()) {
                if (!segment.isInside(visibleArea)) continue;
                GraphicsUtil.drawRuler(g, this, segment);
            }
        }
    }

    private void paintMagvarMode(Graphics2D g) {
        g.setFont(MAGVAR_MODE_FONT);
        FontMetrics fm = g.getFontMetrics();
        String mode = SettingsBean.getInstance().isParamFsxP3dMode() ? Messages.getInstance().get("map_magvar_mode_fsx_p3d") : Messages.getInstance().get("map_magvar_mode_real");
        g.setColor(Color.BLUE);
        g.drawString(mode, (int)((double)this.getWidth() - fm.getStringBounds(mode, g).getWidth() - 30.0), (int)fm.getStringBounds(mode, g).getHeight() - 1);
    }

    private void paintWarnings(Graphics2D g) {
        g.setFont(WARNINGS_FONT);
        FontMetrics fm = g.getFontMetrics();
        ArrayList<String> warnings = new ArrayList<String>();
        if (SettingsBean.getInstance().isTouchScreenMode()) {
            warnings.add(Messages.getInstance().get("map_warning_touch_screen_mode").toUpperCase());
        }
        if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() == null) {
            warnings.add(Messages.getInstance().get("map_warning_no_cruise_speed").toUpperCase());
        }
        if (SettingsBean.getInstance().isDrawAirspaces() && MapObjectsBean.getInstance().getAirspaceFilter().anySelected()) {
            warnings.add(Messages.getInstance().get("map_warning_airspace_filter").toUpperCase());
        }
        if (SettingsBean.getInstance().isDrawAllAirports() && MapObjectsBean.getInstance().getAirportFilter().anySelected()) {
            warnings.add(Messages.getInstance().get("map_warning_airport_filter").toUpperCase());
        }
        if (SettingsBean.getInstance().isDrawObstacles() && MapObjectsBean.getInstance().getObstacleFilter().anySelected()) {
            warnings.add(Messages.getInstance().get("map_warning_obstacle_filter").toUpperCase());
        }
        if (MapObjectsBean.getInstance().getTerrainMesh() != null && MapObjectsBean.getInstance().getTerrainMesh().length > 0 && MapObjectsBean.getInstance().getTerrainLayerFilter().anySelected()) {
            warnings.add(Messages.getInstance().get("map_warning_terrain_layer_filter").toUpperCase());
        }
        g.setColor(Color.RED);
        for (int i = 0; i < warnings.size(); ++i) {
            g.drawString((String)warnings.get(i), (int)((double)this.getWidth() - fm.getStringBounds((String)warnings.get(i), g).getWidth() - 30.0), (int)fm.getStringBounds((String)warnings.get(i), g).getHeight() * (i + 2) + 1);
        }
    }

    private void paintMapButtons(Graphics2D g) {
        if (this.isFullScreenButtonVisible()) {
            this.fullScreenButton.paint(g, this.getSize());
        }
        if (this.isCalculateRouteMapButtonVisible()) {
            this.calculateRouteMapButton.paint(g, this.getSize());
        }
    }

    private void paintNotForOperationalUse(Graphics2D g) {
        String txt = Messages.getInstance().get("not_for_operational_use");
        g.setColor(SettingsBean.getInstance().getColorTheme().getNotForOperationalUseColor());
        g.setFont(NOT_FOR_OPERATIONAL_USE_FONT);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(txt, g);
        g.drawString(txt, 2, (int)rect.getHeight() - 1);
    }

    private void paintLogo(Graphics2D g) {
        Rectangle2D rect;
        Rectangle bounds = g.getClipBounds();
        g.setColor(SettingsBean.getInstance().getColorTheme().getOpenStreetMapColor());
        g.setFont(OPENSTREET_LOGO_FONT);
        FontMetrics fm = g.getFontMetrics();
        String txt = TileFactoryInfoUtil.getCopyrightNotice(this.getTileFactory().getInfo());
        if (txt != null) {
            rect = fm.getStringBounds(txt, g);
            this.logoSPoint = new GpsPoint(bounds.getWidth() - rect.getWidth(), bounds.getHeight() - rect.getHeight() - 20.0);
            this.logoEPoint = new GpsPoint(bounds.getWidth(), bounds.getHeight() - 20.0);
            g.drawString(txt, (int)(bounds.getWidth() - rect.getWidth()), (int)(bounds.getHeight() - 20.0));
        }
        if (this.isDataFromAip()) {
            txt = Messages.getInstance().get("open_aip_information");
            rect = fm.getStringBounds(txt, g);
            g.drawString(txt, (int)(bounds.getWidth() - rect.getWidth()), (int)(bounds.getHeight() - 3.0));
        }
    }

    private boolean isDataFromAip() {
        if (this.dataFromAip == null) {
            this.dataFromAip = SettingsBean.getInstance().isImportFromOpenAip();
        }
        return this.dataFromAip;
    }

    private void paintDistanceTime(Graphics2D g) {
        if (this.infoDistanceTimeValueLabel != null) {
            Rectangle bounds = g.getClipBounds();
            g.setColor(Color.BLUE);
            g.setFont(DISTANCE_TIME_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.infoDistanceTimeValueLabel, g);
            g.drawString(this.infoDistanceTimeValueLabel, (int)(bounds.getWidth() - rect.getWidth() - 10.0), (int)(bounds.getHeight() - 23.0 - 15.0));
        }
    }

    private void paintZoomBar(Graphics2D g) {
        g.setColor(SettingsBean.getInstance().getColorTheme().getZoombarBorderColor());
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(50, 97, 50, 303);
        g.setColor(SettingsBean.getInstance().getColorTheme().getZoombarColor());
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(50, 97, 50, 303);
        double zoomStepHeight = this.getZoomStepHeight();
        int zoom = this.getZoom() - this.getTileFactory().getInfo().getMinimumZoomLevel();
        g.setStroke(new BasicStroke(9.0f));
        g.setColor(SettingsBean.getInstance().getColorTheme().getZoombarColor());
        g.drawLine(45, 100 + (int)Math.round(zoomStepHeight * (double)zoom), 55, 100 + (int)Math.round(zoomStepHeight * (double)zoom));
        g.setStroke(new BasicStroke(7.0f));
        g.setColor(SettingsBean.getInstance().getColorTheme().getZoombarSliderColor());
        g.drawLine(45, 100 + (int)Math.round(zoomStepHeight * (double)zoom), 55, 100 + (int)Math.round(zoomStepHeight * (double)zoom));
        g.setColor(SettingsBean.getInstance().getColorTheme().getZoombarColor());
        g.setFont(ZOOM_BAR_FONT);
        g.drawString("+", 44, 80);
        g.drawString("-", 47, 332);
    }

    public boolean savePng(String fileName) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return false;
        }
        BufferedImage bImg = new BufferedImage(width, height, 2);
        Graphics2D cg = bImg.createGraphics();
        this.paintAll(cg);
        cg.dispose();
        return UrlUtil.saveImage(bImg, fileName);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!SettingsBean.getInstance().isTouchScreenMode()) {
            MapUtil.updateTextUnderCursor(this, e.getX(), e.getY());
        }
        if (MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && !this.mousePressed || this.isMouseCursorInfoVisible()) {
            this.mouseX = -1;
            this.mouseY = -1;
            this.mapFrame.updateMap();
        }
    }

    private boolean isLogoClicked(MouseEvent e) {
        return this.logoSPoint != null && this.logoEPoint != null && (double)e.getX() >= this.logoSPoint.getX() && (double)e.getY() >= this.logoSPoint.getY() && (double)e.getX() <= this.logoEPoint.getX() && (double)e.getY() <= this.logoEPoint.getY();
    }

    private boolean isRectangleClicked(MouseEvent e, Rectangle bounds) {
        return bounds.contains(new GpsPoint(e.getX(), e.getY()));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 1 || SettingsBean.getInstance().isTouchScreenMode()) {
            this.requestFocus();
            if (this.isFullScreenButtonVisible() && this.fullScreenButton.contains(e.getX(), e.getY(), this.getSize())) {
                this.fullScreenButton.actionPerformed();
            } else if (this.isCalculateRouteMapButtonVisible() && this.calculateRouteMapButton.contains(e.getX(), e.getY(), this.getSize())) {
                this.calculateRouteMapButton.actionPerformed();
            } else if (e.getModifiers() == 16 && this.mapFrame.isPopupEnabled() && this.isTouchScreenModeCursorClicked(e)) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                int x = (int)point.getX();
                int y = (int)point.getY();
                VfrMapPopupMenu popupMenu = new VfrMapPopupMenu(this.mapFrame, x, y);
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (e.getModifiers() == 16 && this.isLogoClicked(e)) {
                UrlUtil.openUrlInBrowser(TileFactoryInfoUtil.getCopyrightLink(this.getTileFactory().getInfo()));
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (e.getModifiers() == 16 && (this.isRectangleClicked(e, ZOOM_BAR_PLUS) || this.isRectangleClicked(e, ZOOM_BAR_MINUS) || this.isRectangleClicked(e, ZOOM_BAR_SLIDER))) {
                int x = e.getX();
                int y = e.getY();
                if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                    Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                    x = (int)point.getX();
                    y = (int)point.getY();
                }
                if (this.isRectangleClicked(e, ZOOM_BAR_SLIDER)) {
                    int dz = (int)Math.round((double)(e.getY() - VfrMapViewer.ZOOM_BAR_SLIDER.y) / this.getZoomStepHeight()) + 1 - this.getZoom();
                    this.changeZoom(dz, x, y);
                } else {
                    int dz = this.isRectangleClicked(e, ZOOM_BAR_MINUS) ? 1 : -1;
                    this.changeZoom(dz, x, y);
                }
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (!SettingsBean.getInstance().isTouchScreenMode() && e.getModifiers() == 16 && !this.isOnCalculatedFrame() && MapObjectsBean.getInstance().getNewWaypoint() != null) {
                Integer index = this.addNewPointAtPosition(e.getX(), e.getY());
                if (index != null) {
                    this.openWaypointInfoDialog(index);
                }
            } else if ((!this.pointsLocked || MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && this.isPaintRectangleSelectionWithRotation()) && (e.getModifiers() == 16 || e.getModifiers() == 4)) {
                if (e.getModifiers() == 16 && SettingsBean.getInstance().isTouchScreenMode()) {
                    MapObjectsBean.getInstance().setTouchScreenModeCursorPosition(this.getGeoPositionAtMousePos(e).gpsPlace());
                    MapUtil.updateTextUnderCursor(this, e.getX(), e.getY());
                }
                this.selectedObject = this.getObjectAtPixelPos(e.getX(), e.getY());
                if (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType())) {
                    if (this.selectedObject.getIndex().intValue() != FlightPlanBean.getInstance().getSelectedPoint()) {
                        FlightPlanBean.getInstance().selectPoint(this.selectedObject.getIndex());
                        this.mapFrame.updateMap();
                        this.mapFrame.getUIPanel().selectPointsTableRow(this.selectedObject.getIndex());
                    }
                } else if (MapSelectionType.VORDME.equals((Object)this.selectedObject.getType())) {
                    if (this.selectedObject.getIndex().intValue() != FlightPlanBean.getInstance().getSelectedVor()) {
                        FlightPlanBean.getInstance().selectVor(this.selectedObject.getIndex());
                        this.mapFrame.updateMap();
                        this.mapFrame.getUIPanel().selectVorTableRow(this.selectedObject.getIndex());
                    }
                } else if (MapSelectionType.MAP_RADIAL.equals((Object)this.selectedObject.getType())) {
                    if (this.selectedObject.getIndex().intValue() != FlightPlanBean.getInstance().getSelectedMapRadial()) {
                        FlightPlanBean.getInstance().selectMapRadial(this.selectedObject.getIndex());
                        this.mapFrame.updateMap();
                    }
                } else if (MapSelectionType.LANDMARK.equals((Object)this.selectedObject.getType())) {
                    if (this.selectedObject.getIndex().intValue() != FlightPlanBean.getInstance().getSelectedLandmark()) {
                        FlightPlanBean.getInstance().selectLandmark(this.selectedObject.getIndex());
                        this.mapFrame.updateMap();
                    }
                } else if (!MapSelectionType.SIMCONNECT_VECTOR.equals((Object)this.selectedObject.getType()) && !MapSelectionType.SIMCONNECT_VECTOR_INFO.equals((Object)this.selectedObject.getType())) {
                    FlightPlanBean.getInstance().selectLandmark(-1);
                    FlightPlanBean.getInstance().selectVor(-1);
                    FlightPlanBean.getInstance().selectPoint(-1);
                    FlightPlanBean.getInstance().selectMapRadial(-1);
                    this.mapFrame.updateMap();
                    if (!(MapSelectionType.WINDSOCK.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)this.selectedObject.getType()))) {
                        if (SettingsBean.getInstance().getMapMouseMeasurementLine() == 16) {
                            this.setCursor(Cursor.getPredefinedCursor(1));
                        } else if (e.getModifiers() == SettingsBean.getInstance().getMapMouseMove()) {
                            this.setCursor(Cursor.getPredefinedCursor(13));
                        }
                    }
                }
            } else if (e.getModifiers() == SettingsBean.getInstance().getMapMouseMove()) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (e.getClickCount() == 2) {
            int i = this.getWpIndexAtPixelPos(e.getX(), e.getY());
            if (i >= 0) {
                this.openWaypointInfoDialog(i);
            } else {
                i = this.getLandmarkIndexAtPixelPos(e.getX(), e.getY());
                if (i >= 0) {
                    this.openLandmarkInfoDialog(i);
                } else {
                    i = this.getMapRadialIndexAtPixelPos(e.getX(), e.getY());
                    if (i >= 0) {
                        this.openEditMapRadialsDialog(i);
                    } else {
                        AirportFacade airportFacade;
                        Airport a;
                        AirportDTO airport = this.mapFrame.getAirportAtPosition(e.getX(), e.getY());
                        if (airport != null && airport.getId() != null && (a = (airportFacade = new AirportFacade(DBUtil.getDataSource())).findAirportById(airport.getId())) != null) {
                            AirportInfoDialog dialog = new AirportInfoDialog(this.mapFrame, a);
                            dialog.setVisible(true);
                        }
                    }
                }
            }
        }
    }

    private boolean isTouchScreenModeCursorClicked(MouseEvent e) {
        if (!SettingsBean.getInstance().isTouchScreenMode() || MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() == null) {
            return false;
        }
        Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
        int sx = (int)point.getX() + 19;
        int sy = (int)point.getY() + -55;
        int ex = (int)point.getX() + 51;
        int ey = (int)point.getY() + -23;
        return e.getX() >= sx && e.getY() >= sy && e.getX() <= ex && e.getY() <= ey;
    }

    public void openLandmarkInfoDialog(int i) {
        LandmarkInfoDialog dialog = new LandmarkInfoDialog(this.mapFrame, FlightPlanBean.getInstance().getRoute().getLandmarks().get(i));
        dialog.setVisible(true);
        this.mapFrame.updateMap();
    }

    public void openWaypointInfoDialog(int i) {
        WaypointInfoDialog dialog = new WaypointInfoDialog(this.mapFrame, FlightPlanBean.getInstance().getRoute().getPoints().get(i));
        dialog.setVisible(true);
        FlightPlanBean.getInstance().getRoute().getPoints().get(i).setAlt(dialog.getPoint().getAlt());
        FlightPlanBean.getInstance().getRoute().getPoints().get(i).setName(dialog.getPoint().getName());
        this.mapFrame.getUIPanel().updateRoutePoints();
        this.mapFrame.updateMap();
    }

    public void openEditMapRadialsDialog(int i) {
        AddMapRadialsDialog mapRadialsDialog = new AddMapRadialsDialog(this.mapFrame, FlightPlanBean.getInstance().getRoute().getMapRadials().get(i), i);
        mapRadialsDialog.setVisible(true);
    }

    public List<MapObject> getMapObjectsListAtPixelPos(int x, int y) {
        ArrayList<MapObject> resultList = new ArrayList<MapObject>();
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        GpsArea clickedSearchArea = this.getClickedSearchArea(clickedPos);
        if (SettingsBean.getInstance().isDrawAllAirports()) {
            IlsDTO[] filter = MapObjectsBean.getInstance().getAirportFilter();
            ArrayList<AirportDTO> arrayList = new ArrayList<AirportDTO>();
            for (AirportDTO a : MapObjectsBean.getInstance().getAirports(clickedSearchArea)) {
                if (!filter.checkDisplayAirport(a) || !a.isInside(clickedSearchArea)) continue;
                arrayList.add(a);
            }
            if (arrayList != null && arrayList.size() > 0) {
                Collections.sort(arrayList, new LatLonDistanceComparator(this.getGpsPlaceOnMap(x, y)));
                for (AirportDTO a : arrayList) {
                    resultList.add(new MapObject(MapObjectType.AIRPORT, a.getId(), a.getIdentOrName(), a.getGpsPlace()));
                }
            }
        }
        if (this.getZoom() > 11) {
            return resultList;
        }
        if (SettingsBean.getInstance().isDrawAllIls() && MapObjectsBean.getInstance().getIls() != null) {
            for (IlsDTO i : MapObjectsBean.getInstance().getIls()) {
                if (!i.isGs() || !clickedSearchArea.isInside(i.getBoundary()) && !i.getBoundary().isInside(clickedSearchArea) || i.getAirport() != null && !MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(i.getAirport())) continue;
                resultList.add(new MapObject(MapObjectType.ILS, null, i.getName(), i.getGpsPlace()));
            }
        }
        if (SettingsBean.getInstance().isDrawVfrPoints()) {
            for (VfrPointDTO vfrPointDTO : MapObjectsBean.getInstance().getVfrPoints(clickedSearchArea)) {
                if (!vfrPointDTO.isInside(clickedSearchArea)) continue;
                resultList.add(new MapObject(MapObjectType.VFR_POINT, vfrPointDTO.getId(), vfrPointDTO.getName(), vfrPointDTO.getGpsPlace()));
            }
        }
        if (SettingsBean.getInstance().isDrawRunwayExtensions() && MapObjectsBean.getInstance().getRunwayExtensions() != null) {
            for (int i = 0; i < MapObjectsBean.getInstance().getRunwayExtensions().length; ++i) {
                RunwayExtensionDTO runwayExtensionDTO = MapObjectsBean.getInstance().getRunwayExtensions()[i];
                Integer index = MapUtil.getSegmentIndexWithPoint(this, clickedPos, runwayExtensionDTO.getSegments());
                if (index == null) continue;
                resultList.add(new MapObject(MapObjectType.RUNWAY_EXTENSION, i, runwayExtensionDTO.getName(), runwayExtensionDTO.getVertices()[0].gpsPlace()));
            }
        }
        if (SettingsBean.getInstance().isDrawAllVors() || SettingsBean.getInstance().isDrawAllNdbs()) {
            ArrayList<NavaidDTO> navaids = new ArrayList<NavaidDTO>();
            for (NavaidDTO n : MapObjectsBean.getInstance().getNdbs(clickedSearchArea)) {
                if (!n.isInside(clickedSearchArea)) continue;
                navaids.add(n);
            }
            for (NavaidDTO n : MapObjectsBean.getInstance().getVors(clickedSearchArea)) {
                if (!n.isInside(clickedSearchArea)) continue;
                navaids.add(n);
            }
            if (navaids != null && navaids.size() > 0) {
                Collections.sort(navaids, new LatLonDistanceComparator(this.getGpsPlaceOnMap(x, y)));
                for (NavaidDTO n : navaids) {
                    resultList.add(new MapObject(n.isNdb() ? MapObjectType.NDB : MapObjectType.VORDME, n.getId(), n.getName(), n.getGpsPlace()));
                }
            }
        }
        if (SettingsBean.getInstance().isDrawAllIfrPoints()) {
            for (IfrPointDTO ifrPointDTO : MapObjectsBean.getInstance().getIfrPoints(clickedSearchArea)) {
                if (!ifrPointDTO.isInside(clickedSearchArea)) continue;
                resultList.add(new MapObject(MapObjectType.IFR_POINT, ifrPointDTO.getId(), ifrPointDTO.getName(), ifrPointDTO.getGpsPlace()));
            }
        }
        if (SettingsBean.getInstance().isDrawAllUserPoints()) {
            UserPointsFilter filter = MapObjectsBean.getInstance().getUserPointsFilter();
            ArrayList<UserPointDTO> arrayList = new ArrayList<UserPointDTO>();
            for (UserPointDTO p : MapObjectsBean.getInstance().getUserPoints(clickedSearchArea)) {
                if (!filter.checkDisplayUserPoint(p) || !p.isInside(clickedSearchArea)) continue;
                arrayList.add(p);
            }
            if (arrayList != null && arrayList.size() > 0) {
                Collections.sort(arrayList, new LatLonDistanceComparator(this.getGpsPlaceOnMap(x, y)));
                for (UserPointDTO p : arrayList) {
                    resultList.add(new MapObject(MapObjectType.USER_POINT, p.getId(), p.getName(), p.getGpsPlace()));
                }
            }
        }
        if (this.getZoom() <= 16 && SettingsBean.getInstance().isDrawCities()) {
            for (CityDTO cityDTO : MapObjectsBean.getInstance().getCities(clickedSearchArea)) {
                if (!cityDTO.isInside(clickedSearchArea)) continue;
                resultList.add(new MapObject(MapObjectType.CITY, cityDTO.getId(), cityDTO.getName(), cityDTO.getGpsPlace()));
            }
        }
        if (SettingsBean.getInstance().isDrawAirspaces() && MapObjectsBean.getInstance().getAirspaces() != null) {
            List<AirspaceAreaDTO> areas = AirspacesUtil.findAirspacesUnderPosition(this, clickedSearchArea.getCenter());
            for (AirspaceAreaDTO area : areas) {
                resultList.add(new MapObject(MapObjectType.AIRSPACE_AREA, area.getId(), area.getName(), area.getCenter().gpsPlace()));
            }
        }
        return resultList;
    }

    public MapSelection getObjectAtPixelPos(int x, int y) {
        if (MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && this.isPaintRectangleSelectionWithRotation() && this.rotatedSelectionArea != null) {
            MapSelection res = this.getAreaVertexAtPixelPos(x, y);
            if (res == null) {
                res = this.getAreaSegmentAtPixelPos(x, y);
            }
            if (res == null && this.isRotatedSelectionAreaAtPixelPos(x, y)) {
                return new MapSelection(MapSelectionType.SELECTION_AREA_INSIDE);
            }
            if (res != null) {
                return res;
            }
        } else {
            int i;
            if (SettingsBean.getInstance().getSimConnectConfigBean().isTraceUserPosition() && SettingsBean.getInstance().getSimConnectConfigBean().isDrawVector()) {
                if (this.isSimConnectVectorInfoAtPosition(x, y)) {
                    return new MapSelection(MapSelectionType.SIMCONNECT_VECTOR_INFO);
                }
                if (this.isSimConnectVectorAtPosition(x, y)) {
                    return new MapSelection(MapSelectionType.SIMCONNECT_VECTOR);
                }
            }
            if ((i = this.getWpIndexAtPixelPos(x, y)) >= 0) {
                return new MapSelection(MapSelectionType.WAYPOINT, i);
            }
            if (SettingsBean.getInstance().isShowVor() && this.mapFrame.isVorsMouseDrag() && (i = this.getVorIndexAtPixelPos(x, y)) >= 0) {
                return new MapSelection(MapSelectionType.VORDME, i);
            }
            i = this.getMapRadialIndexAtPixelPos(x, y);
            if (i >= 0) {
                return new MapSelection(MapSelectionType.MAP_RADIAL, i);
            }
            i = this.getLandmarkIndexAtPixelPos(x, y);
            if (i >= 0) {
                return new MapSelection(MapSelectionType.LANDMARK, i);
            }
            if (SettingsBean.getInstance().isShowWindSock() && this.isWindSockAtPosition(x, y)) {
                return new MapSelection(MapSelectionType.WINDSOCK);
            }
        }
        return new MapSelection(MapSelectionType.NONE);
    }

    public int getLandmarkIndexAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        if (SettingsBean.getInstance().calculateRouteInRealTime()) {
            FlightPlanBean.getInstance().getRoute().calculate();
        } else {
            FlightPlanBean.getInstance().getRoute().calculateSegments();
        }
        for (int idx = 0; idx < FlightPlanBean.getInstance().getRoute().getLandmarks().size(); ++idx) {
            GpsPoint landmarkMapPos;
            double cy;
            SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(idx);
            LineSegment segment = FlightPlanBean.getInstance().getRoute().getSegments().get(landmark.getSegmentIndex());
            Point2D from = this.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), this.getZoom());
            Point2D to = this.getTileFactory().geoToPixel(segment.getTo().geoPosition(), this.getZoom());
            double r = from.distance(to) * landmark.getPosition();
            GpsPoint diff = GpsUtil.getVectorCoords(r, segment.getCourse());
            double cx = from.getX() + diff.getX();
            GpsPoint closestPoint = GpsUtil.getPointOnSegment(from, to, new GpsPoint(cx, cy = from.getY() + diff.getY()), false);
            if (closestPoint != null) {
                cx = closestPoint.getX();
                cy = closestPoint.getY();
            }
            if (!(clickedPos.distance(landmarkMapPos = new GpsPoint(cx, cy)) < 5.0)) continue;
            return idx;
        }
        return -1;
    }

    public boolean isUserPointAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        for (ExtConnectBean bean : SimConnectUtil.getInstance().getUserTrack()) {
            if (!this.clickedAtPlace(new GpsPlace(bean.getUserLat().floatValue(), bean.getUserLon().floatValue()), clickedPos)) continue;
            return true;
        }
        return false;
    }

    public MapSelection getAreaVertexAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        if (this.clickedAtPlace(this.rotatedSelectionArea.getTopLeft(), clickedPos)) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_VERTEX, GpsArea.VERTEX_TOP_LEFT);
        }
        if (this.clickedAtPlace(this.rotatedSelectionArea.getTopRight(), clickedPos)) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_VERTEX, GpsArea.VERTEX_TOP_RIGHT);
        }
        if (this.clickedAtPlace(this.rotatedSelectionArea.getBottomLeft(), clickedPos)) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_VERTEX, GpsArea.VERTEX_BOTTOM_LEFT);
        }
        if (this.clickedAtPlace(this.rotatedSelectionArea.getBottomRight(), clickedPos)) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_VERTEX, GpsArea.VERTEX_BOTTOM_RIGHT);
        }
        return null;
    }

    public MapSelection getAreaSegmentAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        Integer selSegment = MapUtil.getSegmentIndexWithPoint(this, clickedPos, this.rotatedSelectionArea.getSegments());
        if (selSegment == null) {
            return null;
        }
        if (RotatedGpsArea.SEGMENT_TOP == selSegment) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_SEGMENT, RotatedGpsArea.SEGMENT_TOP);
        }
        if (RotatedGpsArea.SEGMENT_LEFT == selSegment) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_SEGMENT, RotatedGpsArea.SEGMENT_LEFT);
        }
        if (RotatedGpsArea.SEGMENT_RIGHT == selSegment) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_SEGMENT, RotatedGpsArea.SEGMENT_RIGHT);
        }
        if (RotatedGpsArea.SEGMENT_BOTTOM == selSegment) {
            return new MapSelection(MapSelectionType.SELECTION_AREA_SEGMENT, RotatedGpsArea.SEGMENT_BOTTOM);
        }
        return null;
    }

    public boolean isRotatedSelectionAreaAtPixelPos(int x, int y) {
        return this.getGpsPlaceOnMap(x, y).isInside(this.rotatedSelectionArea.getRectangleOver());
    }

    public int getWpIndexAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getPoints().size(); ++i) {
            if (!this.clickedAtPlace(FlightPlanBean.getInstance().getRoute().getPoints().get(i), clickedPos)) continue;
            return i;
        }
        return -1;
    }

    public GpsPlace getGpsPlaceAtMapPosition(double x, double y) {
        return this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, x, y), this.getZoom()).gpsPlace();
    }

    public int getVorIndexAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getVors().size(); ++i) {
            if (!this.clickedAtPlace(FlightPlanBean.getInstance().getRoute().getVors().get(i), clickedPos)) continue;
            return i;
        }
        return -1;
    }

    public int getMapRadialIndexAtPixelPos(int x, int y) {
        GpsPoint clickedPos = MapUtil.getPixelPositionOnMap(this, x, y);
        for (int i = 0; i < FlightPlanBean.getInstance().getRoute().getMapRadials().size(); ++i) {
            if (!this.clickedAtPlace(FlightPlanBean.getInstance().getRoute().getMapRadials().get(i).getPos(), clickedPos)) continue;
            return i;
        }
        return -1;
    }

    private boolean clickedAtPlace(GpsPlace wp, GpsPoint clickedPos) {
        Point2D point = this.getTileFactory().geoToPixel(wp.geoPosition(), this.getZoom());
        return point.distance(clickedPos) <= 12.0;
    }

    private GpsArea getClickedSearchArea(GpsPoint clickedPos) {
        GpsPoint topLeftPoint = new GpsPoint(clickedPos.getX() - 12.0, clickedPos.getY() - 12.0);
        GpsPoint bottomRightPoint = new GpsPoint(clickedPos.getX() + 12.0, clickedPos.getY() + 12.0);
        return new GpsArea(this.getTileFactory().pixelToGeo(topLeftPoint, this.getZoom()).gpsPlace(), this.getTileFactory().pixelToGeo(bottomRightPoint, this.getZoom()).gpsPlace());
    }

    public GpsPlace getGpsPlace(Point2D point) {
        return this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
    }

    public GpsPlace getGpsPlaceOnMap(double x, double y) {
        return this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, x, y), this.getZoom()).gpsPlace();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
        if (!(e.getModifiers() != SettingsBean.getInstance().getMapMouseMove() && e.getModifiers() != 16 || this.pointsLocked || e.getModifiers() != 16)) {
            if (this.selectedObject != null && this.selectedObject.getIndex() != null && !StringUtil.isEmpty(this.nameOfPrevStickyObject)) {
                FlightPlanBean.getInstance().getRoute().getPoints().get(this.selectedObject.getIndex()).setName(this.nameOfPrevStickyObject);
                this.mapFrame.getUIPanel().updateRoutePoints();
                this.nameOfPrevStickyObject = null;
            }
            this.selectedObject = MapSelection.NONE;
        }
        if (this.drawMeasurmentLine) {
            if (this.multipleRulersMode) {
                this.getMeasurementLines().add(GpsUtil.getLineSegment(this.measurmentLineStart, this.measurmentLineEnd));
            } else {
                this.getMeasurementLines().clear();
            }
            this.drawMeasurmentLine = false;
            this.measurmentLineEnd = null;
            this.measurmentLineStart = null;
        }
        if (this.drawSelection || SettingsBean.getInstance().isDrawMapGrid()) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
        }
        this.mapFrame.updateMap();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SettingsBean.getInstance().isTouchScreenMode()) {
            MapObjectsBean.getInstance().getTextUnderCursor().clear();
            this.magnifyingGlassImage = null;
        }
        this.requestFocus();
        if (MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && e.getModifiers() == 16) {
            if (this.isPaintRectangleSelectionWithRotation() && this.selectedObject != null && MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)this.selectedObject.getType())) {
                this.mapMouseDragAction(e);
            } else {
                GpsPoint point = MapUtil.getPixelPositionOnMap(this, e.getX(), e.getY());
                if (this.mousePressed) {
                    if (this.selectionEnd != null) {
                        int dx = e.getX() - this.prevMouseX;
                        int dy = e.getY() - this.prevMouseY;
                        Point2D endPos = this.getTileFactory().geoToPixel(this.selectionEnd.geoPosition(), this.getZoom());
                        this.selectionEnd = this.getTileFactory().pixelToGeo(new GpsPoint(endPos.getX() + (double)dx, endPos.getY() + (double)dy), this.getZoom()).gpsPlace();
                        GpsArea area = new GpsArea(this.selectionStart, this.selectionEnd);
                        this.setSelectionArea(area);
                        this.mapFrame.getMapViewer().repaint();
                        if (this.selectionModeDialog != null) {
                            this.selectionModeDialog.selectionChanged(area);
                        }
                    }
                } else {
                    this.selectionEnd = this.selectionStart = this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
                    this.drawSelection = true;
                }
                if (!this.getCursor().equals(1)) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                }
                this.mousePressed = true;
                this.prevMouseX = e.getX();
                this.prevMouseY = e.getY();
            }
        } else if (!this.mousePressed && e.getModifiers() == 16 && this.isRectangleClicked(e, ZOOM_BAR_SLIDER)) {
            int x = e.getX();
            int y = e.getY();
            if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                x = (int)point.getX();
                y = (int)point.getY();
            }
            int dz = (int)Math.round((double)(e.getY() - VfrMapViewer.ZOOM_BAR_SLIDER.y) / this.getZoomStepHeight()) + 1 - this.getZoom();
            this.changeZoom(dz, x, y);
        } else if (!this.pointsLocked && this.selectedObject.isAnySelected() && e.getModifiers() == 4) {
            this.mousePressed = true;
            this.prevMouseX = e.getX();
            this.prevMouseY = e.getY();
        } else if (!this.pointsLocked && this.selectedObject.isAnySelected() && e.getModifiers() == 16) {
            if (MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                MapObjectsBean.getInstance().setTouchScreenModeCursorPosition(null);
                this.mapFrame.updateMap();
            }
            this.mapMouseDragAction(e);
        } else if ((e.getModifiers() == SettingsBean.getInstance().getMapMouseMeasurementLine() || SettingsBean.getInstance().getMapMouseMove() == 16 && e.getModifiers() == 16 && this.isSpacePressed()) && (SettingsBean.getInstance().getMapMouseMove() != 8 || !this.isSpacePressed())) {
            if (MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                MapObjectsBean.getInstance().setTouchScreenModeCursorPosition(null);
                this.mapFrame.updateMap();
            }
            Point2D point = MapUtil.getPixelPositionOnMap(this, e.getX(), e.getY());
            if (this.mousePressed) {
                int dx = e.getX() - this.prevMouseX;
                int dy = e.getY() - this.prevMouseY;
                if (this.measurmentLineEnd != null) {
                    Point2D newPoint;
                    Point2D endPos = this.getTileFactory().geoToPixel(this.measurmentLineEnd.geoPosition(), this.getZoom());
                    endPos = new GpsPoint(endPos.getX() + (double)dx, endPos.getY() + (double)dy);
                    if (SettingsBean.getInstance().isStickyMode() && (newPoint = this.getStickyPoint(endPos, e.getX(), e.getY(), true, true)) != null) {
                        endPos = newPoint;
                    }
                    this.measurmentLineEnd = this.getTileFactory().pixelToGeo(endPos, this.getZoom()).gpsPlace();
                    this.mapFrame.getMapViewer().repaint();
                }
            } else {
                Point2D newPoint;
                if (SettingsBean.getInstance().isStickyMode() && (newPoint = this.getStickyPoint(point, e.getX(), e.getY(), true, true)) != null) {
                    point = newPoint;
                }
                this.measurmentLineEnd = this.measurmentLineStart = this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
                this.drawMeasurmentLine = true;
            }
            if (!this.getCursor().equals(1)) {
                this.setCursor(Cursor.getPredefinedCursor(1));
            }
            this.mousePressed = true;
            this.prevMouseX = e.getX();
            this.prevMouseY = e.getY();
        } else if (e.getModifiers() == SettingsBean.getInstance().getMapMouseMove() || SettingsBean.getInstance().getMapMouseMove() == 8 && e.getModifiers() == 16 && this.isSpacePressed()) {
            if (this.mousePressed) {
                int dx = this.prevMouseX - e.getX();
                int dy = this.prevMouseY - e.getY();
                this.moveMap(dx, dy);
                if (MapMode.PLACE_TEMP_HIGHLIGHT.equals((Object)this.getMapMode())) {
                    this.mapFrame.setMarkerPlace(null);
                    this.setMapMode(MapMode.DEFAULT);
                    this.mapFrame.updateMap();
                }
            }
            this.mousePressed = true;
            this.prevMouseX = e.getX();
            this.prevMouseY = e.getY();
        }
    }

    public Point2D getStickyPoint(Point2D wp, int mouseX, int mouseY, boolean checkRoutePoints, boolean checkMapRadials) {
        GpsPlace res = this.getStickyGpsPlace(wp, mouseX, mouseY, checkRoutePoints, checkMapRadials);
        if (res == null) {
            return null;
        }
        return this.getTileFactory().geoToPixel(res.geoPosition(), this.getZoom());
    }

    public GpsPlace getStickyGpsPlace(Point2D wp, int mouseX, int mouseY, boolean checkRoutePoints, boolean checkMapRadials) {
        Point2D ptVor;
        GpsPoint newWp = null;
        GpsArea visibleArea = this.mapFrame.getVisibleArea();
        GpsPoint mousePos = MapUtil.getPixelPositionOnMap(this, mouseX, mouseY);
        if (checkRoutePoints) {
            for (GpsPlace gpsPlace : FlightPlanBean.getInstance().getRoute().getPoints()) {
                if (!gpsPlace.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, ptVor = this.getTileFactory().geoToPixel(gpsPlace.geoPosition(), this.getZoom()), mousePos)) == null) continue;
                GpsPlace res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                res.setAlt(gpsPlace.getAlt());
                return res;
            }
        }
        if (checkMapRadials) {
            for (MapRadials mapRadials : FlightPlanBean.getInstance().getRoute().getMapRadials()) {
                Point2D ptVor2;
                GpsPlace p = mapRadials.getPos();
                if (!p.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, ptVor2 = this.getTileFactory().geoToPixel(p.geoPosition(), this.getZoom()), mousePos)) == null) continue;
                GpsPlace res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                res.setAlt(p.getAlt());
                return res;
            }
        }
        for (GpsPlace gpsPlace : FlightPlanBean.getInstance().getRoute().getVors()) {
            if (!gpsPlace.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, ptVor = this.getTileFactory().geoToPixel(gpsPlace.geoPosition(), this.getZoom()), mousePos)) == null) continue;
            GpsPlace place = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
            place.setName(gpsPlace.getName());
            return place;
        }
        if (newWp == null) {
            Object res;
            Point2D pt;
            if (SettingsBean.getInstance().isDrawAllAirports()) {
                for (AirportDTO airportDTO : MapObjectsBean.getInstance().getAirports(visibleArea)) {
                    if (!MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(airportDTO) || !airportDTO.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(airportDTO.getPosition(), this.getZoom()), mousePos)) == null) continue;
                    res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                    ((GpsPlace)res).setName(airportDTO.getIdentOrName());
                    if (airportDTO.getElevation() != null) {
                        ((GpsPlace)res).setAlt((double)airportDTO.getElevation());
                    }
                    return res;
                }
            }
            if (SettingsBean.getInstance().isDrawVfrPoints()) {
                for (VfrPointDTO vfrPointDTO : MapObjectsBean.getInstance().getVfrPoints(visibleArea)) {
                    if (!vfrPointDTO.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(vfrPointDTO.getPosition(), this.getZoom()), mousePos)) == null) continue;
                    res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                    ((GpsPlace)res).setName(vfrPointDTO.getName());
                    return res;
                }
            }
            if (this.getZoom() <= 11) {
                if (SettingsBean.getInstance().isDrawAllUserPoints()) {
                    for (UserPointDTO userPointDTO : MapObjectsBean.getInstance().getUserPoints(visibleArea)) {
                        if (!userPointDTO.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(userPointDTO.getPosition(), this.getZoom()), mousePos)) == null) continue;
                        res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                        ((GpsPlace)res).setName(userPointDTO.getName());
                        return res;
                    }
                }
                if (SettingsBean.getInstance().isDrawAllVors()) {
                    for (NavaidDTO navaidDTO : MapObjectsBean.getInstance().getVors(visibleArea)) {
                        if (!navaidDTO.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(navaidDTO.getPosition(), this.getZoom()), mousePos)) == null) continue;
                        res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                        ((GpsPlace)res).setName(navaidDTO.getName());
                        return res;
                    }
                }
                if (SettingsBean.getInstance().isDrawRadialsFromVors() && MapObjectsBean.getInstance().getRadialsFromVorsIntersections() != null) {
                    Point2D pt2;
                    double shortestDistance = 1000000.0;
                    GpsPlace closestPlace = null;
                    for (GpsPlace place : MapObjectsBean.getInstance().getRadialsFromVorsIntersections()) {
                        Point2D pt3;
                        double dist;
                        if (!place.isInside(visibleArea) || !((dist = (pt3 = this.getTileFactory().geoToPixel(place.geoPosition(), this.getZoom())).distance(mousePos)) < shortestDistance)) continue;
                        closestPlace = place;
                        shortestDistance = dist;
                    }
                    if (closestPlace != null && mousePos.distance(pt2 = this.getTileFactory().geoToPixel(closestPlace.geoPosition(), this.getZoom())) <= 20.0) {
                        return closestPlace.clone();
                    }
                }
                if (SettingsBean.getInstance().isDrawAllNdbs()) {
                    for (NavaidDTO navaidDTO : MapObjectsBean.getInstance().getNdbs(visibleArea)) {
                        if (!navaidDTO.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(navaidDTO.getPosition(), this.getZoom()), mousePos)) == null) continue;
                        res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                        ((GpsPlace)res).setName(navaidDTO.getName());
                        return res;
                    }
                }
                if (SettingsBean.getInstance().isDrawCities()) {
                    for (NamedWaypoint namedWaypoint : MapObjectsBean.getInstance().getCities(visibleArea)) {
                        if (!namedWaypoint.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(namedWaypoint.getPosition(), this.getZoom()), mousePos)) == null) continue;
                        res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                        ((GpsPlace)res).setName(namedWaypoint.getName());
                        return res;
                    }
                }
                if (SettingsBean.getInstance().isDrawAllIfrPoints()) {
                    for (NamedWaypoint namedWaypoint : MapObjectsBean.getInstance().getIfrPoints(visibleArea)) {
                        if (!namedWaypoint.isInside(visibleArea) || (newWp = this.isStickyToPoint(wp, pt = this.getTileFactory().geoToPixel(namedWaypoint.getPosition(), this.getZoom()), mousePos)) == null) continue;
                        res = this.getTileFactory().pixelToGeo(newWp, this.getZoom()).gpsPlace();
                        ((GpsPlace)res).setName(namedWaypoint.getName());
                        return res;
                    }
                }
            }
        }
        return null;
    }

    private GpsPoint isStickyToPoint(Point2D wp, Point2D pt, Point2D mousePos) {
        if (wp.distance(pt) <= 20.0) {
            if (mousePos.distance(pt) <= 20.0) {
                return new GpsPoint(pt.getX(), pt.getY());
            }
            return new GpsPoint(mousePos.getX(), mousePos.getY());
        }
        return null;
    }

    public Point2D getMapPositionAtPos(int posX, int posY) {
        int dx = posX - (int)this.getBounds().getCenterX();
        int dy = posY - (int)this.getBounds().getCenterY();
        Point2D center = this.getTileFactory().geoToPixel(this.getCenterPosition(), this.getZoom());
        center.setLocation(center.getX() + (double)dx, center.getY() + (double)dy);
        return center;
    }

    public GeoPosition getGeoPositionAtMousePos(MouseEvent e) {
        return this.getGeoPositionAtPos(e.getX(), e.getY());
    }

    public GeoPosition getGeoPositionAtPos(int posX, int posY) {
        return this.getTileFactory().pixelToGeo(this.getMapPositionAtPos(posX, posY), this.getZoom());
    }

    public boolean isPaintAirspacesList() {
        return SettingsBean.getInstance().isDrawAirspaces() && SettingsBean.getInstance().isDrawAirspacesListUnderCursor();
    }

    private void updateMouseCursorRotation(MapSelection sel) {
        double angle = this.rotatedSelectionArea.getAngle() + 45.0;
        if (GpsArea.VERTEX_TOP_LEFT == sel.getIndex()) {
            angle -= 90.0;
        } else if (GpsArea.VERTEX_TOP_RIGHT != sel.getIndex()) {
            if (GpsArea.VERTEX_BOTTOM_RIGHT == sel.getIndex()) {
                angle += 90.0;
            } else if (GpsArea.VERTEX_BOTTOM_LEFT == sel.getIndex()) {
                angle += 180.0;
            }
        }
        angle = GpsUtil.normalizeCourse(angle);
        this.setCursor(ResourcesBean.getInstance().getMouseCursorRotate()[(int)Math.round(angle / 15.0) % 24]);
    }

    private void updateMouseCursorResize(MapSelection sel) {
        double angle = this.rotatedSelectionArea.getAngle();
        if (RotatedGpsArea.SEGMENT_TOP != sel.getIndex()) {
            if (RotatedGpsArea.SEGMENT_RIGHT == sel.getIndex()) {
                angle += 90.0;
            } else if (RotatedGpsArea.SEGMENT_BOTTOM == sel.getIndex()) {
                angle += 180.0;
            } else if (RotatedGpsArea.SEGMENT_LEFT == sel.getIndex()) {
                angle += 270.0;
            }
        }
        angle = GpsUtil.normalizeCourse(angle);
        this.setCursor(ResourcesBean.getInstance().getMouseCursorResize()[(int)Math.round(angle / 15.0) % 24]);
    }

    private boolean isAnyMapButtonAtPosition(int x, int y) {
        if (this.isFullScreenButtonVisible() && this.fullScreenButton.contains(x, y, this.getSize())) {
            return true;
        }
        return this.isCalculateRouteMapButtonVisible() && this.calculateRouteMapButton.contains(x, y, this.getSize());
    }

    private boolean isFullScreenButtonVisible() {
        return this.fullScreenButton != null;
    }

    private boolean isCalculateRouteMapButtonVisible() {
        return !this.isOnCalculatedFrame() && !this.isFullScreenMode() && this.calculateRouteMapButton != null && this.mapFrame.getUIPanel().doValidate(false);
    }

    private void doMagnifyingGlass(int x, int y) {
        int w = 25;
        int h = 25;
        BufferedImage img = GraphicsUtil.createImageFromPanel(this, x, y, w, h);
        if (img != null) {
            img = GraphicsUtil.enlargeImage(img, 5.0);
            this.magnifyingGlassImage = GraphicsUtil.drawCrossOnImage(img);
        } else {
            this.magnifyingGlassImage = null;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentMouseX = e.getX();
        this.currentMouseY = e.getY();
        if (!SettingsBean.getInstance().isTouchScreenMode()) {
            MapUtil.updateTextUnderCursor(this, e.getX(), e.getY());
        }
        if (this.magnifyingGlass) {
            int x = e.getX();
            int y = e.getY();
            if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                x = (int)point.getX();
                y = (int)point.getY();
            }
            this.doMagnifyingGlass(x, y);
        } else {
            if (this.coordsCursor) {
                this.repaint();
            }
            boolean isNewWp = false;
            if (this.isAnyMapButtonAtPosition(e.getX(), e.getY()) || this.isRectangleClicked(e, ZOOM_BAR_MINUS) || this.isRectangleClicked(e, ZOOM_BAR_PLUS) || this.isRectangleClicked(e, ZOOM_BAR_SLIDER)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                if (MapMode.RECTANGLE_DRAW.equals((Object)this.getMapMode()) && !this.mousePressed || this.isPaintAirspacesList() || SettingsBean.getInstance().isDrawMapObjectsListUnderCursor()) {
                    this.mouseX = e.getX();
                    this.mouseY = e.getY();
                    this.mapFrame.updateMap();
                }
                if (this.isPaintRectangleSelectionWithRotation()) {
                    MapSelection sel = this.getObjectAtPixelPos(e.getX(), e.getY());
                    if (sel != null && MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)sel.getType())) {
                        this.updateMouseCursorRotation(sel);
                    } else if (sel != null && MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)sel.getType())) {
                        this.updateMouseCursorResize(sel);
                    } else if (sel != null && MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)sel.getType())) {
                        this.setCursor(ResourcesBean.getInstance().getMouseCursorMove());
                    } else {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                } else {
                    if (!this.mapFrame.isOnCalculatedFrame() && !this.isPointsLocked()) {
                        MapSelection sel = this.getObjectAtPixelPos(e.getX(), e.getY());
                        if (sel.isAnySelected()) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        } else if (!SettingsBean.getInstance().isTouchScreenMode()) {
                            int my;
                            int mx = e.getX();
                            GpsPoint point = MapUtil.getPixelPositionOnMap(this, mx, my = e.getY());
                            Integer index = MapUtil.getSegmentIndexWithPoint(this, point, new ArrayList<LineSegment>(FlightPlanBean.getInstance().getRoute().getSegments()));
                            if (index != null) {
                                LineSegment seg = FlightPlanBean.getInstance().getRoute().getSegments().get(index);
                                GpsPoint p = this.getPointOnSegment(seg, point);
                                if (p != null) {
                                    point = p;
                                }
                                GpsPlace newWp = this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
                                MapObjectsBean.getInstance().setNewWaypoint(newWp);
                                this.mapFrame.updateMap();
                                isNewWp = true;
                                this.setCursor(Cursor.getPredefinedCursor(12));
                            } else {
                                this.setCursor(Cursor.getDefaultCursor());
                            }
                        } else {
                            this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                    if (this.drawCompass || this.drawDistanceCircles || this.coordsCursor || this.drawClosestVorRadials) {
                        this.repaint();
                    }
                }
            }
            if (!isNewWp && MapObjectsBean.getInstance().getNewWaypoint() != null) {
                MapObjectsBean.getInstance().setNewWaypoint(null);
                this.mapFrame.updateMap();
            }
        }
    }

    public boolean isPaintRectangleSelectionWithRotation() {
        return this.isAllowRotationInRectangleDrawMode() && this.isPaintRectangleSelection();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
            Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
            x = (int)point.getX();
            y = (int)point.getY();
        }
        this.changeZoom(e.getWheelRotation(), x, y);
    }

    private void changeZoom(int dz, int mx, int my) {
        int dx = mx - (int)this.getBounds().getCenterX();
        int dy = my - (int)this.getBounds().getCenterY();
        Point2D center = this.getTileFactory().geoToPixel(this.getCenterPosition(), this.getZoom());
        center.setLocation(center.getX() + (double)dx, center.getY() + (double)dy);
        this.setCenterPosition(this.getGeoPositionAtPos(mx, my));
        this.setZoom(this.getZoom() + dz);
        center = this.getTileFactory().geoToPixel(this.getCenterPosition(), this.getZoom());
        center.setLocation(center.getX() - (double)dx, center.getY() - (double)dy);
        this.setCenterPosition(this.getTileFactory().pixelToGeo(center, this.getZoom()));
        MapUtil.updateTextUnderCursor(this, mx, my);
        if (this.magnifyingGlass) {
            this.doMagnifyingGlass(mx, my);
        }
        this.mapFrame.updateMap();
    }

    public Integer addNewPointAtPosition(double mouseX, double mouseY) {
        return this.addNewPointAtPosition(mouseX, mouseY, null, null, false);
    }

    public Integer addNewPointAtPosition(double mouseX, double mouseY, Double altitude, Integer index, boolean force) {
        if (force || !this.pointsLocked) {
            if (index == null) {
                index = this.getSegmentClicked(mouseX, mouseY);
            }
            GpsPoint point = MapUtil.getPixelPositionOnMap(this, mouseX, mouseY);
            if (index != null) {
                GpsPoint p = this.getPointOnSegment(FlightPlanBean.getInstance().getRoute().getSegments().get(index), point);
                if (p != null) {
                    point = p;
                }
                index = index + 1;
            }
            GpsPlace resultPoint = this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
            if (altitude != null) {
                resultPoint.setAlt(altitude);
            }
            this.mapFrame.getUIPanel().addNewPoint(resultPoint, index);
            return index;
        }
        return null;
    }

    public void addNewVorAtPosition(double mouseX, double mouseY) {
        if (!this.pointsLocked) {
            GpsPlace resultPoint = this.getMapVorNdbAtPosition(mouseX, mouseY);
            if (resultPoint == null) {
                resultPoint = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, mouseX, mouseY), this.getZoom()).gpsPlace();
            }
            if (StringUtil.isEmpty(resultPoint.getType())) {
                resultPoint.setType("VOR");
            }
            this.mapFrame.getUIPanel().addNewVor(resultPoint);
        }
    }

    public GpsPlace getMapVorNdbAtPosition(double mouseX, double mouseY) {
        if (this.getZoom() <= 11) {
            int delta = (int)Math.round(Math.sqrt(this.getZoom()) * 5.0);
            GpsPlace topLeft = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, mouseX - (double)delta, mouseY - (double)delta), this.getZoom()).gpsPlace();
            GpsPlace bottomRight = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, mouseX + (double)delta, mouseY + (double)delta), this.getZoom()).gpsPlace();
            GpsArea area = new GpsArea(topLeft, bottomRight);
            MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
            ArrayList<GpsPlace> vorsList = new ArrayList<GpsPlace>();
            if (SettingsBean.getInstance().isDrawAllVors()) {
                vorsList.addAll(mapFacade.getMapVorsInArea(area, false));
            }
            if (SettingsBean.getInstance().isDrawAllNdbs()) {
                vorsList.addAll(mapFacade.getMapNdbsInArea(area));
            }
            if (vorsList.size() > 0) {
                GpsPlace resultPoint = this.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(this, mouseX, mouseY), this.getZoom()).gpsPlace();
                Collections.sort(vorsList, new DistanceComparator(resultPoint));
                resultPoint = (GpsPlace)vorsList.get(0);
                if (resultPoint.getAlt() != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    resultPoint.setAlt(Double.valueOf(Math.round(UnitUtil.recalculateAltitude(resultPoint.getAlt(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false))));
                }
                return resultPoint;
            }
        }
        return null;
    }

    public void getMeteoAtPosition(double mouseX, double mouseY) {
        GpsPoint point = MapUtil.getPixelPositionOnMap(this, mouseX, mouseY);
        GpsPlace place = this.getTileFactory().pixelToGeo(point, this.getZoom()).gpsPlace();
        place.setName(place.toString());
        this.mapFrame.getUIPanel().openMeteoWeatherForPlace(place);
    }

    public void addLandmarkAtPosition(double mouseX, double mouseY) {
        Integer index = this.getSegmentClicked(mouseX, mouseY);
        if (index != null) {
            GpsPoint point = MapUtil.getPixelPositionOnMap(this, mouseX, mouseY);
            RouteSegment segment = FlightPlanBean.getInstance().getRoute().getSegments().get(index);
            point = this.getPointOnSegment(segment, point);
            Point2D segmFrom = this.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), this.getZoom());
            Point2D segmTo = this.getTileFactory().geoToPixel(segment.getTo().geoPosition(), this.getZoom());
            double segmLength = Math.sqrt(Math.pow(segmFrom.getX() - segmTo.getX(), 2.0) + Math.pow(segmFrom.getY() - segmTo.getY(), 2.0));
            double dist = Math.sqrt(Math.pow(segmFrom.getX() - point.getX(), 2.0) + Math.pow(segmFrom.getY() - point.getY(), 2.0));
            FlightPlanBean.getInstance().getRoute().getLandmarks().add(new SegmentLandmark(index, dist / segmLength));
            FlightPlanBean.getInstance().getRoute().getSegments().set(index, segment);
            this.mapFrame.updateMap();
        }
    }

    public GpsPoint getPointOnSegment(LineSegment segment, GpsPoint point) {
        Point2D wp1 = this.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), this.getZoom());
        Point2D wp2 = this.getTileFactory().geoToPixel(segment.getTo().geoPosition(), this.getZoom());
        return GpsUtil.getPointOnSegment(wp1, wp2, point);
    }

    public AirportDTO getAirportClicked(double mx, double my) {
        GpsPoint point = MapUtil.getPixelPositionOnMap(this, mx, my);
        GpsArea visibleArea = this.mapFrame.getVisibleArea();
        for (AirportDTO airport : MapObjectsBean.getInstance().getAirports(visibleArea)) {
            Point2D pos;
            if (!airport.isInside(visibleArea) || !((pos = this.getTileFactory().geoToPixel(airport.getPosition(), this.getZoom())).distance(point) <= 10.0)) continue;
            return airport;
        }
        return null;
    }

    public Integer getSegmentClicked(double mx, double my) {
        FlightPlanBean.getInstance().getRoute().calculateSegments();
        GpsPoint point = MapUtil.getPixelPositionOnMap(this, mx, my);
        return MapUtil.getSegmentIndexWithPoint(this, point, new ArrayList<LineSegment>(FlightPlanBean.getInstance().getRoute().getSegments()));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.mousePressed) {
            this.keyPressed = e.getKeyCode();
            if (this.keyPressed == 27 && this.isFullScreenMode()) {
                this.fullScreenButton.actionPerformed();
            } else if (this.keyPressed == 16) {
                this.setCursor(Cursor.getPredefinedCursor(1));
            } else if (this.keyPressed == 32) {
                if (SettingsBean.getInstance().getMapMouseMove() == 8) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                }
            } else if (this.keyPressed == 521 || this.keyPressed == 61 || this.keyPressed == 45) {
                int dz = this.keyPressed == 45 ? 1 : -1;
                int x = this.currentMouseX;
                int y = this.currentMouseY;
                if (SettingsBean.getInstance().isTouchScreenMode() && MapObjectsBean.getInstance().getTouchScreenModeCursorPosition() != null) {
                    Point2D point = MapUtil.getPointPostionFromGpsPlace(this, MapObjectsBean.getInstance().getTouchScreenModeCursorPosition());
                    x = (int)point.getX();
                    y = (int)point.getY();
                }
                this.changeZoom(dz, x, y);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.mousePressed) {
            if (e.getKeyCode() == 127) {
                this.mapFrame.deleteSelected();
            } else if (e.getKeyCode() == 37) {
                this.moveMap(-100, 0);
            } else if (e.getKeyCode() == 40) {
                this.moveMap(0, 100);
            } else if (e.getKeyCode() == 39) {
                this.moveMap(100, 0);
            } else if (e.getKeyCode() == 38) {
                this.moveMap(0, -100);
            } else if (e.getKeyCode() == 16 || e.getKeyCode() == 32) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.keyPressed = -1;
    }

    public void moveMap(int dx, int dy) {
        Point2D center = this.getTileFactory().geoToPixel(this.getCenterPosition(), this.getZoom());
        center.setLocation(center.getX() + (double)dx, center.getY() + (double)dy);
        this.setCenterPosition(this.getTileFactory().pixelToGeo(center, this.getZoom()));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isPointsLocked() {
        return this.pointsLocked;
    }

    public void setPointsLocked(boolean pointsLocked) {
        this.pointsLocked = pointsLocked;
    }

    public void center(List<RoutePlace> points) {
        if (points.size() > 1) {
            double avgLat = 0.0;
            double avgLon = 0.0;
            int cnt = 0;
            for (RoutePlace point : points) {
                avgLat += point.getLat().getValue();
                avgLon += point.getLon().getValue();
                ++cnt;
            }
            GeoPosition pointsCenter = new GeoPosition(avgLat /= (double)cnt, avgLon /= (double)cnt);
            this.setCenterPosition(pointsCenter);
            for (int zoom = 1; zoom <= 17; ++zoom) {
                boolean allVisible = true;
                for (RoutePlace p : points) {
                    Point2D point = this.getTileFactory().geoToPixel(p.geoPosition(), zoom);
                    Point2D center = this.getTileFactory().geoToPixel(pointsCenter, zoom);
                    double dx = Math.abs(center.getX() - point.getX());
                    double dy = Math.abs(center.getY() - point.getY());
                    if (dx <= (double)(this.getBounds().width / 2) && dy <= (double)(this.getBounds().height / 2)) continue;
                    allVisible = false;
                    break;
                }
                if (!allVisible) continue;
                this.setZoom(zoom);
                this.setCenterPosition(pointsCenter);
                this.mapFrame.updateMap();
                break;
            }
        } else if (points.size() == 1) {
            this.setZoom(9);
            this.setCenterPosition(new GeoPosition(points.get(0).getLat().getValue(), points.get(0).getLon().getValue()));
            this.mapFrame.updateMap();
        }
    }

    public boolean isWindSockAtPosition(int x, int y) {
        WindSock windSock = FlightPlanBean.getInstance().getRoute().getWindSock();
        GpsPoint pointClicked = MapUtil.getPixelPositionOnMap(this, x, y);
        Point2D windSockPos = this.getTileFactory().geoToPixel(new GeoPosition(windSock.getLat(), windSock.getLon()), this.getZoom());
        return windSockPos.distance(pointClicked) <= windSock.getCalcRadius();
    }

    public boolean isSimConnectVectorAtPosition(int x, int y) {
        GpsPlace vectorTo = SettingsBean.getInstance().getSimConnectConfigBean().getVectorTo();
        if (vectorTo != null) {
            return this.clickedAtPlace(vectorTo, MapUtil.getPixelPositionOnMap(this, x, y));
        }
        return false;
    }

    public boolean isSimConnectVectorInfoAtPosition(int x, int y) {
        GpsPlace vectorInfoPos = SettingsBean.getInstance().getSimConnectConfigBean().getVectorInfoPos();
        if (vectorInfoPos != null) {
            return this.clickedAtPlace(vectorInfoPos, MapUtil.getPixelPositionOnMap(this, x, y));
        }
        return false;
    }

    public boolean isPaintZoomBar() {
        return this.paintZoomBar;
    }

    public void setPaintZoomBar(boolean paintZoomBar) {
        this.paintZoomBar = paintZoomBar;
    }

    public boolean isPaintMeteoPoints() {
        return this.paintMeteoPoints;
    }

    public void setPaintMeteoPoints(boolean paintMeteoPoints) {
        this.paintMeteoPoints = paintMeteoPoints;
    }

    public int getZoomBarSteps() {
        return this.getTileFactory().getInfo().getMaximumZoomLevel() - this.getTileFactory().getInfo().getMinimumZoomLevel();
    }

    public double getZoomStepHeight() {
        return 200.0 / (double)this.getZoomBarSteps();
    }

    public boolean isVorsMouseDrag() {
        return this.vorsMouseDrag;
    }

    public void setVorsMouseDrag(boolean vorsMouseDrag) {
        this.vorsMouseDrag = vorsMouseDrag;
    }

    private boolean isSpacePressed() {
        return this.keyPressed == 32;
    }

    public void setDrawSelectionMode(boolean drawSelectionMode) {
        if (!drawSelectionMode) {
            this.setMapMode(MapMode.DEFAULT);
            this.drawSelection = false;
            this.selectionEnd = null;
            this.selectionStart = null;
            this.mapFrame.updateMap();
        } else {
            this.setMapMode(MapMode.RECTANGLE_DRAW);
            this.drawSelection = true;
        }
    }

    public void setSelectionArea(GpsArea selectionArea) {
        this.selectionStart = selectionArea.getTopLeft();
        this.selectionEnd = selectionArea.getBottomRight();
        this.rotatedSelectionArea = new RotatedGpsArea(this.getSelectionArea());
    }

    public GpsArea getSelectionArea() {
        if (this.selectionEnd != null && this.selectionStart != null) {
            return new GpsArea(this.selectionStart, this.selectionEnd);
        }
        return null;
    }

    public SelectionModeDialog getSelectionModeDialog() {
        return this.selectionModeDialog;
    }

    public void setSelectionModeDialog(SelectionModeDialog selectionModeDialog) {
        this.selectionModeDialog = selectionModeDialog;
    }

    public boolean isDrawElevationScale() {
        return this.drawElevationScale;
    }

    public void setDrawElevationScale(boolean drawElevationScale) {
        this.drawElevationScale = drawElevationScale;
    }

    public Short getElevationScaleMin() {
        return this.elevationScaleMin;
    }

    public void setElevationScaleMin(Short elevationScaleMin) {
        this.elevationScaleMin = elevationScaleMin;
    }

    public Short getElevationScaleMax() {
        return this.elevationScaleMax;
    }

    public void setElevationScaleMax(Short elevationScaleMax) {
        this.elevationScaleMax = elevationScaleMax;
    }

    public MapMode getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(MapMode mapMode) {
        this.mapMode = mapMode;
    }

    public List<LineSegment> getMeasurementLines() {
        if (this.measurementLines == null) {
            this.measurementLines = new ArrayList<LineSegment>();
        }
        return this.measurementLines;
    }

    public void setMeasurementLines(List<LineSegment> measurementLines) {
        this.measurementLines = measurementLines;
    }

    public boolean isMultipleRulersMode() {
        return this.multipleRulersMode;
    }

    public void setMultipleRulersMode(boolean multipleRulersMode) {
        this.multipleRulersMode = multipleRulersMode;
    }

    public boolean isOnCalculatedFrame() {
        return this.onCalculatedFrame;
    }

    public void setOnCalculatedFrame(boolean onCalculatedFrame) {
        this.onCalculatedFrame = onCalculatedFrame;
    }

    public boolean isPaintVorRadials() {
        return this.paintVorRadials;
    }

    public void setPaintVorRadials(boolean paintVorRadials) {
        this.paintVorRadials = paintVorRadials;
    }

    public boolean isPaintVorDistances() {
        return this.paintVorDistances;
    }

    public void setPaintVorDistances(boolean paintVorDistances) {
        this.paintVorDistances = paintVorDistances;
    }

    public boolean isPaintVorNames() {
        return this.paintVorNames;
    }

    public void setPaintVorNames(boolean paintVorNames) {
        this.paintVorNames = paintVorNames;
    }

    public boolean isCalculationResultPaintDistanceAndTime() {
        return this.calculationResultPaintDistanceAndTime;
    }

    public void setCalculationResultPaintDistanceAndTime(boolean calculationResultPaintDistanceAndTime) {
        this.calculationResultPaintDistanceAndTime = calculationResultPaintDistanceAndTime;
    }

    public GpsPlace getMarkerPlace() {
        return this.markerPlace;
    }

    public void setMarkerPlace(GpsPlace markerPlace) {
        this.markerPlace = markerPlace;
    }

    public Rectangle getOverlayViewerBounds() {
        return this.overlayViewerBounds;
    }

    public void setOverlayViewerBounds(Rectangle overlayViewerBounds) {
        this.overlayViewerBounds = overlayViewerBounds;
    }

    public boolean isAllowRotationInRectangleDrawMode() {
        return this.allowRotationInRectangleDrawMode;
    }

    public void setAllowRotationInRectangleDrawMode(boolean allowRotationInRectangleDrawMode) {
        this.allowRotationInRectangleDrawMode = allowRotationInRectangleDrawMode;
    }

    private void mapMouseDragAction(MouseEvent e) {
        if (this.mousePressed) {
            int dx = e.getX() - this.prevMouseX;
            int dy = e.getY() - this.prevMouseY;
            if (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType()) || this.vorsMouseDrag && MapSelectionType.VORDME.equals((Object)this.selectedObject.getType()) || MapSelectionType.MAP_RADIAL.equals((Object)this.selectedObject.getType()) || MapSelectionType.SIMCONNECT_VECTOR.equals((Object)this.selectedObject.getType()) || MapSelectionType.SIMCONNECT_VECTOR_INFO.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)this.selectedObject.getType()) || MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)this.selectedObject.getType())) {
                GpsPlace newWpPlace;
                GpsPlace gpsWp = null;
                if (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType())) {
                    gpsWp = FlightPlanBean.getInstance().getRoute().getPoints().get(this.selectedObject.getIndex());
                } else if (MapSelectionType.VORDME.equals((Object)this.selectedObject.getType())) {
                    gpsWp = FlightPlanBean.getInstance().getRoute().getVors().get(this.selectedObject.getIndex());
                } else if (MapSelectionType.MAP_RADIAL.equals((Object)this.selectedObject.getType())) {
                    gpsWp = FlightPlanBean.getInstance().getRoute().getMapRadials().get(this.selectedObject.getIndex()).getPos();
                } else if (MapSelectionType.SIMCONNECT_VECTOR.equals((Object)this.selectedObject.getType())) {
                    gpsWp = SettingsBean.getInstance().getSimConnectConfigBean().getVectorTo();
                } else if (MapSelectionType.SIMCONNECT_VECTOR_INFO.equals((Object)this.selectedObject.getType())) {
                    gpsWp = SettingsBean.getInstance().getSimConnectConfigBean().getVectorInfoPos();
                } else if (MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)this.selectedObject.getType())) {
                    gpsWp = this.getGpsPlaceAtMapPosition(e.getX(), e.getY());
                } else if (MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)this.selectedObject.getType())) {
                    gpsWp = this.getGpsPlaceAtMapPosition(e.getX(), e.getY());
                } else if (MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)this.selectedObject.getType())) {
                    gpsWp = this.getGpsPlaceAtMapPosition(e.getX(), e.getY());
                }
                Point2D wp = this.getTileFactory().geoToPixel(gpsWp.geoPosition(), this.getZoom());
                GpsPlace newGpsWp = null;
                if (SettingsBean.getInstance().isStickyMode() && MapSelectionType.SIMCONNECT_VECTOR.equals((Object)this.selectedObject.getType())) {
                    newWpPlace = this.getStickyGpsPlace(wp, e.getX(), e.getY(), true, true);
                    if (newWpPlace == null) {
                        gpsWp.setAlt(null);
                    } else {
                        newGpsWp = newWpPlace;
                    }
                }
                if (newGpsWp == null) {
                    newWpPlace = null;
                    if (SettingsBean.getInstance().isStickyMode() && (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType()) || MapSelectionType.MAP_RADIAL.equals((Object)this.selectedObject.getType()))) {
                        newWpPlace = this.getStickyGpsPlace(wp, e.getX(), e.getY(), false, false);
                    }
                    if (newWpPlace == null) {
                        newWpPlace = this.getTileFactory().pixelToGeo(new GpsPoint(wp.getX() + (double)dx, wp.getY() + (double)dy), this.getZoom()).gpsPlace();
                        this.nameOfPrevStickyObject = null;
                    }
                    newGpsWp = newWpPlace.clone();
                }
                if (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType())) {
                    FlightPlanBean.getInstance().getRoute().getPoints().get(this.selectedObject.getIndex()).setLat(newGpsWp.getLat());
                    FlightPlanBean.getInstance().getRoute().getPoints().get(this.selectedObject.getIndex()).setLon(newGpsWp.getLon());
                    this.nameOfPrevStickyObject = newGpsWp.getName();
                } else if (MapSelectionType.VORDME.equals((Object)this.selectedObject.getType())) {
                    FlightPlanBean.getInstance().getRoute().getVors().get(this.selectedObject.getIndex()).setLat(newGpsWp.getLat());
                    FlightPlanBean.getInstance().getRoute().getVors().get(this.selectedObject.getIndex()).setLon(newGpsWp.getLon());
                } else if (MapSelectionType.MAP_RADIAL.equals((Object)this.selectedObject.getType())) {
                    FlightPlanBean.getInstance().getRoute().getMapRadials().get(this.selectedObject.getIndex()).setPos(newGpsWp);
                } else if (MapSelectionType.SIMCONNECT_VECTOR.equals((Object)this.selectedObject.getType())) {
                    SettingsBean.getInstance().getSimConnectConfigBean().setVectorTo(newGpsWp);
                } else if (MapSelectionType.SIMCONNECT_VECTOR_INFO.equals((Object)this.selectedObject.getType())) {
                    SettingsBean.getInstance().getSimConnectConfigBean().setVectorInfoPos(newGpsWp);
                } else if (MapSelectionType.SELECTION_AREA_VERTEX.equals((Object)this.selectedObject.getType())) {
                    double previousAngle = GpsUtil.getCourse(this.rotatedSelectionArea.getCenter(), gpsWp);
                    double currentAngle = GpsUtil.getCourse(this.rotatedSelectionArea.getCenter(), newGpsWp);
                    this.rotatedSelectionArea = GpsUtil.rotateGpsArea(this, this.rotatedSelectionArea, currentAngle - previousAngle);
                    if (this.selectionModeDialog != null && this.selectionModeDialog.isRotationEnabled()) {
                        this.selectionModeDialog.rotatedSelectionChanged(this.rotatedSelectionArea);
                    }
                    this.updateMouseCursorRotation(this.selectedObject);
                } else if (MapSelectionType.SELECTION_AREA_SEGMENT.equals((Object)this.selectedObject.getType())) {
                    double radius = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    double rangle = GpsUtil.getAngleBetweenCourses(GpsUtil.getCourse(gpsWp, newGpsWp), this.rotatedSelectionArea.getAngle());
                    double angle = this.rotatedSelectionArea.getAngle();
                    if (RotatedGpsArea.SEGMENT_RIGHT == this.selectedObject.getIndex()) {
                        angle += 90.0;
                        rangle -= 90.0;
                    } else if (RotatedGpsArea.SEGMENT_BOTTOM == this.selectedObject.getIndex()) {
                        angle += 180.0;
                        rangle += 180.0;
                    } else if (RotatedGpsArea.SEGMENT_LEFT == this.selectedObject.getIndex()) {
                        angle += 270.0;
                        rangle += 90.0;
                    }
                    rangle = GpsUtil.normalizeCourse(rangle);
                    if (rangle >= 90.0 && rangle <= 270.0) {
                        radius = -radius;
                    }
                    angle = GpsUtil.normalizeCourse(angle);
                    GpsPoint p = GpsUtil.getVectorCoords(radius, angle);
                    if (RotatedGpsArea.SEGMENT_TOP == this.selectedObject.getIndex()) {
                        Point2D topLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopLeft().geoPosition(), this.getZoom());
                        Point2D topRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopRight().geoPosition(), this.getZoom());
                        GpsPlace newTopLeft = this.getTileFactory().pixelToGeo(new GpsPoint(topLeftPt.getX() + p.getX(), topLeftPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        GpsPlace newTopRight = this.getTileFactory().pixelToGeo(new GpsPoint(topRightPt.getX() + p.getX(), topRightPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        this.rotatedSelectionArea.setTopLeft(newTopLeft);
                        this.rotatedSelectionArea.setTopRight(newTopRight);
                    } else if (RotatedGpsArea.SEGMENT_LEFT == this.selectedObject.getIndex()) {
                        Point2D topLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopLeft().geoPosition(), this.getZoom());
                        Point2D bottomLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomLeft().geoPosition(), this.getZoom());
                        GpsPlace newTopLeft = this.getTileFactory().pixelToGeo(new GpsPoint(topLeftPt.getX() + p.getX(), topLeftPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        GpsPlace newBottomLeft = this.getTileFactory().pixelToGeo(new GpsPoint(bottomLeftPt.getX() + p.getX(), bottomLeftPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        this.rotatedSelectionArea.setTopLeft(newTopLeft);
                        this.rotatedSelectionArea.setBottomLeft(newBottomLeft);
                    } else if (RotatedGpsArea.SEGMENT_RIGHT == this.selectedObject.getIndex()) {
                        Point2D topRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopRight().geoPosition(), this.getZoom());
                        Point2D bottomRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomRight().geoPosition(), this.getZoom());
                        GpsPlace newTopRight = this.getTileFactory().pixelToGeo(new GpsPoint(topRightPt.getX() + p.getX(), topRightPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        GpsPlace newBottomRight = this.getTileFactory().pixelToGeo(new GpsPoint(bottomRightPt.getX() + p.getX(), bottomRightPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        this.rotatedSelectionArea.setTopRight(newTopRight);
                        this.rotatedSelectionArea.setBottomRight(newBottomRight);
                    } else if (RotatedGpsArea.SEGMENT_BOTTOM == this.selectedObject.getIndex()) {
                        Point2D bottomLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomLeft().geoPosition(), this.getZoom());
                        Point2D bottomRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomRight().geoPosition(), this.getZoom());
                        GpsPlace newBottomLeft = this.getTileFactory().pixelToGeo(new GpsPoint(bottomLeftPt.getX() + p.getX(), bottomLeftPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        GpsPlace newBottomRight = this.getTileFactory().pixelToGeo(new GpsPoint(bottomRightPt.getX() + p.getX(), bottomRightPt.getY() + p.getY()), this.getZoom()).gpsPlace();
                        this.rotatedSelectionArea.setBottomLeft(newBottomLeft);
                        this.rotatedSelectionArea.setBottomRight(newBottomRight);
                    }
                    if (this.selectionModeDialog != null && this.selectionModeDialog.isRotationEnabled()) {
                        this.selectionModeDialog.rotatedSelectionChanged(this.rotatedSelectionArea);
                    }
                    this.updateMouseCursorResize(this.selectedObject);
                } else if (MapSelectionType.SELECTION_AREA_INSIDE.equals((Object)this.selectedObject.getType())) {
                    Point2D topLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopLeft().geoPosition(), this.getZoom());
                    Point2D topRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getTopRight().geoPosition(), this.getZoom());
                    Point2D bottomLeftPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomLeft().geoPosition(), this.getZoom());
                    Point2D bottomRightPt = this.getTileFactory().geoToPixel(this.rotatedSelectionArea.getBottomRight().geoPosition(), this.getZoom());
                    GpsPlace newTopLeft = this.getTileFactory().pixelToGeo(new GpsPoint(topLeftPt.getX() + (double)dx, topLeftPt.getY() + (double)dy), this.getZoom()).gpsPlace();
                    GpsPlace newTopRight = this.getTileFactory().pixelToGeo(new GpsPoint(topRightPt.getX() + (double)dx, topRightPt.getY() + (double)dy), this.getZoom()).gpsPlace();
                    GpsPlace newBottomLeft = this.getTileFactory().pixelToGeo(new GpsPoint(bottomLeftPt.getX() + (double)dx, bottomLeftPt.getY() + (double)dy), this.getZoom()).gpsPlace();
                    GpsPlace newBottomRight = this.getTileFactory().pixelToGeo(new GpsPoint(bottomRightPt.getX() + (double)dx, bottomRightPt.getY() + (double)dy), this.getZoom()).gpsPlace();
                    this.rotatedSelectionArea.setTopLeft(newTopLeft);
                    this.rotatedSelectionArea.setTopRight(newTopRight);
                    this.rotatedSelectionArea.setBottomLeft(newBottomLeft);
                    this.rotatedSelectionArea.setBottomRight(newBottomRight);
                    if (this.selectionModeDialog != null && this.selectionModeDialog.isRotationEnabled()) {
                        this.selectionModeDialog.rotatedSelectionChanged(this.rotatedSelectionArea);
                    }
                    this.setCursor(ResourcesBean.getInstance().getMouseCursorMove());
                }
                this.mapFrame.updateMap();
                if (MapSelectionType.WAYPOINT.equals((Object)this.selectedObject.getType())) {
                    this.mapFrame.getUIPanel().updateRoutePoints();
                } else if (MapSelectionType.VORDME.equals((Object)this.selectedObject.getType())) {
                    this.mapFrame.getUIPanel().updateVor();
                }
            } else if (MapSelectionType.LANDMARK.equals((Object)this.selectedObject.getType())) {
                SegmentLandmark landmark = FlightPlanBean.getInstance().getRoute().getLandmarks().get(this.selectedObject.getIndex());
                LineSegment segment = FlightPlanBean.getInstance().getRoute().getSegments().get(landmark.getSegmentIndex());
                GpsPoint newLandmarkPos = this.getPointOnSegment(segment, MapUtil.getPixelPositionOnMap(this, e.getX(), e.getY()));
                if (newLandmarkPos != null) {
                    Point2D from = this.getTileFactory().geoToPixel(segment.getFrom().geoPosition(), this.getZoom());
                    Point2D to = this.getTileFactory().geoToPixel(segment.getTo().geoPosition(), this.getZoom());
                    if (from.distance(newLandmarkPos) > 12.0 && to.distance(newLandmarkPos) > 12.0) {
                        landmark.setPosition(from.distance(newLandmarkPos) / from.distance(to));
                        FlightPlanBean.getInstance().getRoute().getLandmarks().set(this.selectedObject.getIndex(), landmark);
                        this.mapFrame.updateMap();
                    }
                }
            } else if (MapSelectionType.WINDSOCK.equals((Object)this.selectedObject.getType())) {
                WindSock windSock = FlightPlanBean.getInstance().getRoute().getWindSock();
                Point2D windSockPos = this.getTileFactory().geoToPixel(new GeoPosition(windSock.getLat(), windSock.getLon()), this.getZoom());
                GpsPoint newWindSock = new GpsPoint(windSockPos.getX() + (double)dx, windSockPos.getY() + (double)dy);
                GeoPosition newGeoWindSock = this.getTileFactory().pixelToGeo(newWindSock, this.getZoom());
                windSock.setDiffLat(newGeoWindSock.getLatitude() - windSock.getCalcLat());
                windSock.setDiffLon(newGeoWindSock.getLongitude() - windSock.getCalcLon());
                FlightPlanBean.getInstance().getRoute().setWindSock(windSock);
                this.mapFrame.updateMap();
            }
        }
        this.mousePressed = true;
        this.prevMouseX = e.getX();
        this.prevMouseY = e.getY();
    }

    public RotatedGpsArea getRotatedSelectionArea() {
        return this.rotatedSelectionArea;
    }

    public void setRotatedSelectionArea(RotatedGpsArea rotatedSelectionArea) {
        if (rotatedSelectionArea == null) {
            this.selectionStart = null;
            this.selectionEnd = null;
        } else {
            this.selectionStart = rotatedSelectionArea.getTopLeft();
            this.selectionEnd = rotatedSelectionArea.getBottomRight();
        }
        this.rotatedSelectionArea = rotatedSelectionArea;
    }

    public String getInfoDistanceTimeValueLabel() {
        return this.infoDistanceTimeValueLabel;
    }

    public void setInfoDistanceTimeValueLabel(String infoDistanceTimeValueLabel) {
        this.infoDistanceTimeValueLabel = infoDistanceTimeValueLabel;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        this.fullScreenMode = fullScreenMode;
    }

    public MapButton getFullScreenButton() {
        return this.fullScreenButton;
    }

    public void setFullScreenButton(MapButton fullScreenButton) {
        this.fullScreenButton = fullScreenButton;
    }

    public Cache<String, BufferedImage> getTilesCache() {
        return this.tilesCache;
    }

    public boolean isMagnifyingGlass() {
        return this.magnifyingGlass;
    }

    public void setMagnifyingGlass(boolean magnifyingGlass) {
        this.magnifyingGlass = magnifyingGlass;
    }

    public boolean isDrawCompass() {
        return this.drawCompass;
    }

    public void setDrawCompass(boolean drawCompass) {
        this.drawCompass = drawCompass;
    }

    public boolean isDrawDistanceCircles() {
        return this.drawDistanceCircles;
    }

    public void setDrawDistanceCircles(boolean drawDistanceCircles) {
        this.drawDistanceCircles = drawDistanceCircles;
    }

    public boolean isStopDrawing() {
        return this.stopDrawing;
    }

    public void setStopDrawing(boolean stopDrawing) {
        this.stopDrawing = stopDrawing;
    }

    public boolean isCoordsCursor() {
        return this.coordsCursor;
    }

    public void setCoordsCursor(boolean coordsCursor) {
        this.coordsCursor = coordsCursor;
    }

    public boolean isDrawClosestVorRadials() {
        return this.drawClosestVorRadials;
    }

    public void setDrawClosestVorRadials(boolean drawClosestVorRadials) {
        this.drawClosestVorRadials = drawClosestVorRadials;
    }
}

