/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map;

import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.org.jdesktop.swingx.mapviewer.DefaultWaypoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class NamedWaypoint
extends DefaultWaypoint
implements main.java.org.jdesktop.swingx.mapviewer.Waypoint {
    private String name;

    public NamedWaypoint() {
    }

    public NamedWaypoint(Waypoint w) {
        this(new GeoPosition(w.getLat(), w.getLon()), w.getIdent());
    }

    public NamedWaypoint(Double lat, Double lon, String name) {
        this.setPosition(new GeoPosition(lat, lon));
        this.name = name;
    }

    public NamedWaypoint(GeoPosition position, String name) {
        this.setPosition(position);
        this.name = name;
    }

    public NamedWaypoint(Elevation el) {
        this.setPosition(new GeoPosition(el.getLat(), el.getLon()));
        this.setName(String.valueOf(el.getElev()));
    }

    public NamedWaypoint(TaxiName t) {
        this.setPosition(new GeoPosition(t.getLat(), t.getLon()));
        this.setName(t.getName());
    }

    public NamedWaypoint(AirportStart s) {
        this.setPosition(new GeoPosition(s.getLat(), s.getLon()));
        this.setName(s.getName());
    }

    public NamedWaypoint(City city) {
        this.setPosition(new GeoPosition(city.getLat(), city.getLon()));
        this.setName(city.getName());
    }

    public NamedWaypoint(AlternateAirport a) {
        this.setPosition(new GeoPosition(a.getLat(), a.getLon()));
        this.setName(a.getIdent());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GpsPlace getGpsPlace() {
        return new GpsPlace(new GpsCoord(this.getPosition().getLatitude()), new GpsCoord(this.getPosition().getLongitude()), this.name);
    }

    public boolean isInside(GpsArea area) {
        return this.getPosition().getLatitude() <= area.getMaxLat() && this.getPosition().getLatitude() >= area.getMinLat() && this.getPosition().getLongitude() >= area.getMinLon() && this.getPosition().getLongitude() <= area.getMaxLon();
    }
}

