/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.lookandfeel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.gui.lookandfeel.Liquid;
import main.java.guru.vfrflight.gui.lookandfeel.LookAndFeel;
import main.java.guru.vfrflight.gui.lookandfeel.Metal;
import main.java.guru.vfrflight.gui.lookandfeel.Nimbus;
import main.java.guru.vfrflight.gui.lookandfeel.Squareness;
import main.java.guru.vfrflight.gui.lookandfeel.System;
import main.java.guru.vfrflight.gui.lookandfeel.Tiny;
import main.java.guru.vfrflight.util.VfrUtil;

public class LookAndFeelFactory {
    public static final String TINY_TYPE = "Tiny";
    public static final String NIMBUS_TYPE = "Nimbus";
    public static final String SYSTEM_TYPE = "System";
    public static final String METAL_TYPE = "Metal";
    public static final String LIQUID_TYPE = "Liquid";
    public static final String SQUARENESS_TYPE = "Squareness";
    private static final Map<String, LookAndFeel> TYPE_MAPPINGS;

    private LookAndFeelFactory() {
    }

    public static LookAndFeel createTheme(String type) {
        if (TYPE_MAPPINGS.get(type) != null) {
            return TYPE_MAPPINGS.get(type);
        }
        if (VfrUtil.isWindows()) {
            return new Tiny();
        }
        return new Nimbus();
    }

    public static StringComboBoxItem[] createComboBoxValues() {
        ArrayList<StringComboBoxItem> result = new ArrayList<StringComboBoxItem>();
        for (Map.Entry<String, LookAndFeel> pair : TYPE_MAPPINGS.entrySet()) {
            if (!(VfrUtil.isWindows() && pair.getValue().isForWindows() || VfrUtil.isMacOS() && pair.getValue().isForMac()) && (!VfrUtil.isUnix() || !pair.getValue().isForLinux())) continue;
            result.add(new StringComboBoxItem(pair.getKey(), pair.getKey()));
        }
        return result.toArray(new StringComboBoxItem[result.size()]);
    }

    static {
        LinkedHashMap<String, LookAndFeel> mp = new LinkedHashMap<String, LookAndFeel>();
        mp.put(TINY_TYPE, new Tiny());
        mp.put(NIMBUS_TYPE, new Nimbus());
        mp.put(SYSTEM_TYPE, new System());
        mp.put(METAL_TYPE, new Metal());
        mp.put(LIQUID_TYPE, new Liquid());
        mp.put(SQUARENESS_TYPE, new Squareness());
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

