/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.xplane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.xplane.XplaneImportDataStep3Dialog;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.XplaneImportUtil;

public class XplaneImportDataStep1Dialog
extends JDialog {
    private static final long serialVersionUID = -1423120749519357951L;
    private FileChooserPanel simMainDirPanel;

    public XplaneImportDataStep1Dialog(JFrame frame, SceneryConfigPathsBean sceneryConfigPathsBean) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                XplaneImportDataStep1Dialog.this.closeWindowAction();
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("xplane_import_data_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        this.simMainDirPanel = new FileChooserPanel(Messages.getInstance().get("xplane_import_data_simulator_main_dir"), false);
        panel_2.add(this.simMainDirPanel);
        if (new File(sceneryConfigPathsBean.getXplaneMainDir()).exists()) {
            this.simMainDirPanel.setChosenPath(sceneryConfigPathsBean.getXplaneMainDir());
        }
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("next_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XplaneImportDataStep1Dialog.this.nextButtonAction();
            }
        });
        panel_1.add(eksportujButton);
        this.setSize(462, 150);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.simMainDirPanel.getChosenPath())) {
            errors.add(Messages.getInstance().get("xplane_import_data_empty_sim_path"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void nextButtonAction() {
        if (this.doValidate()) {
            SceneryConfigPathsBean sceneryConfigPathsBean = new SceneryConfigPathsBean();
            sceneryConfigPathsBean.setXplaneMainDir(this.simMainDirPanel.getChosenPath());
            List<SceneryConfigEntry> defaultSceneryPaths = XplaneImportUtil.readSceneryConfig(sceneryConfigPathsBean.getXplaneMainDir());
            if (defaultSceneryPaths == null || defaultSceneryPaths.size() == 0) {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_import_data_no_scenery_config_paths"), Messages.getInstance().get("error"), 0);
            } else {
                this.setVisible(false);
                XplaneImportDataStep3Dialog fidDialog = new XplaneImportDataStep3Dialog(MapFrame.getInstance(), defaultSceneryPaths, sceneryConfigPathsBean);
                fidDialog.setVisible(true);
            }
        }
    }
}

