/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.wait;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.button.TextButton;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;

public class PleaseWaitDialog
extends JDialog {
    private static final long serialVersionUID = -1615965304947793123L;
    private JProgressBar progressBar;
    private JPanel progressBarPanel;
    private JLabel pleaseWaitLabel;
    private boolean shouldBeUnlocked = true;
    private StoppableTask taskExecuting;
    private TextButton stopButton;
    private static volatile PleaseWaitDialog instance = null;

    public static PleaseWaitDialog getInstance() {
        return PleaseWaitDialog.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PleaseWaitDialog getInstance(Window window) {
        if (instance != null) return instance;
        Class<PleaseWaitDialog> clazz = PleaseWaitDialog.class;
        synchronized (PleaseWaitDialog.class) {
            if (instance != null) return instance;
            instance = new PleaseWaitDialog((Window)MapFrame.getInstance());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private PleaseWaitDialog(Window window) {
        super(window);
        this.setUndecorated(true);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.progressBarPanel = new JPanel();
        this.progressBarPanel.setBackground(new Color(255, 120, 110));
        this.getContentPane().add(this.progressBarPanel);
        this.progressBarPanel.setLayout(null);
        this.pleaseWaitLabel = new JLabel(Messages.getInstance().get("please_wait"));
        this.pleaseWaitLabel.setHorizontalAlignment(0);
        this.pleaseWaitLabel.setBounds(10, 11, 355, 31);
        this.pleaseWaitLabel.setFont(new Font("Tahoma", 1, 25));
        this.progressBarPanel.add(this.pleaseWaitLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(117, 53, 150, 16);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBarPanel.add(this.progressBar);
        this.stopButton = new TextButton("x");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PleaseWaitDialog.this.taskExecuting.setInterrupted(true);
                PleaseWaitDialog.this.stopButton.setEnabled(false);
            }
        });
        this.stopButton.setBounds(270, 50, 20, 20);
        this.progressBarPanel.add(this.stopButton);
        this.setSize(375, 88);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void start(StoppableTask t) {
        this.start(true, t);
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean intermidate) {
        this.start(intermidate, null);
    }

    public void start(final boolean intermidate, final StoppableTask t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (t != null) {
                    PleaseWaitDialog.this.setTaskExecuting(t);
                }
                PleaseWaitDialog.this.stopButton.setEnabled(true);
                PleaseWaitDialog.this.stopButton.setVisible(PleaseWaitDialog.this.taskExecuting != null);
                if (MapFrame.getInstance().isPointsLocked() || !MapFrame.getInstance().isPopupEnabled()) {
                    PleaseWaitDialog.this.shouldBeUnlocked = false;
                }
                MapFrame.getInstance().lock();
                PleaseWaitDialog.this.progressBar.setIndeterminate(intermidate);
                if (!intermidate) {
                    PleaseWaitDialog.this.progressBar.setValue(0);
                }
                PleaseWaitDialog.this.setVisible(true);
                PleaseWaitDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    public void setProgress(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PleaseWaitDialog.this.progressBar.setValue(value);
            }
        });
    }

    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PleaseWaitDialog.this.progressBar.setIndeterminate(true);
                if (PleaseWaitDialog.this.shouldBeUnlocked) {
                    MapFrame.getInstance().unlock();
                }
                if (MapFrame.getInstance().isOnCalculatedFrame()) {
                    MapFrame.getInstance().setPopupEnabled(true);
                }
                PleaseWaitDialog.this.setCursor(Cursor.getDefaultCursor());
                instance = null;
                PleaseWaitDialog.this.setTaskExecuting(null);
                PleaseWaitDialog.this.setVisible(false);
                PleaseWaitDialog.this.dispose();
            }
        });
    }

    public void setProgressMaximum(int progressMaximum) {
        this.progressBar.setMaximum(progressMaximum);
    }

    public StoppableTask getTaskExecuting() {
        return this.taskExecuting;
    }

    public void setTaskExecuting(StoppableTask taskExecuting) {
        this.taskExecuting = taskExecuting;
    }
}

