/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.wait;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.DefaultCaret;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.ConsoleDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import org.apache.log4j.Logger;

public class PleaseWaitConsoleDialog
extends JDialog
implements ConsoleDialog {
    private static final long serialVersionUID = 2182030994539391374L;
    private static final Logger log = Logger.getLogger(PleaseWaitConsoleDialog.class);
    private JProgressBar progressBar;
    private JPanel progressBarPanel;
    private JLabel pleaseWaitLabel;
    private boolean shouldBeUnlocked = true;
    private StoppableTask taskExecuting;
    private JButton stopButton;
    private static volatile PleaseWaitConsoleDialog instance = null;
    private JTextArea textArea;

    public static PleaseWaitConsoleDialog getInstance() {
        return PleaseWaitConsoleDialog.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PleaseWaitConsoleDialog getInstance(Window window) {
        if (instance != null) return instance;
        Class<PleaseWaitConsoleDialog> clazz = PleaseWaitConsoleDialog.class;
        synchronized (PleaseWaitConsoleDialog.class) {
            if (instance != null) return instance;
            instance = new PleaseWaitConsoleDialog((Window)MapFrame.getInstance());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private PleaseWaitConsoleDialog(Window window) {
        super(window);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PleaseWaitConsoleDialog.this.interrupt();
            }
        });
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.progressBarPanel = new JPanel();
        this.progressBarPanel.setBackground(new Color(255, 120, 110));
        this.getContentPane().add(this.progressBarPanel);
        this.progressBarPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 0, 10), new EtchedBorder(1, null, null)));
        this.progressBarPanel.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane scroll = new JScrollPane(this.textArea);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(31);
        panel.add((Component)scroll, "Center");
        JPanel panel_1 = new JPanel();
        this.progressBarPanel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add((Component)panel_2, "North");
        this.pleaseWaitLabel = new JLabel(Messages.getInstance().get("please_wait"));
        panel_2.add(this.pleaseWaitLabel);
        this.pleaseWaitLabel.setHorizontalAlignment(0);
        this.pleaseWaitLabel.setFont(new Font("Tahoma", 1, 25));
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "South");
        this.progressBar = new JProgressBar();
        panel_3.add(this.progressBar);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        JPanel buttonPanel = new JPanel();
        this.progressBarPanel.add((Component)buttonPanel, "South");
        this.stopButton = new JButton(Messages.getInstance().get("cancel_button"));
        buttonPanel.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PleaseWaitConsoleDialog.this.interrupt();
            }
        });
        this.setSize(450, 400);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void start(StoppableTask t) {
        this.start(true, t);
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean intermidate) {
        this.start(intermidate, null);
    }

    public void start(final boolean intermidate, final StoppableTask t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (t != null) {
                    PleaseWaitConsoleDialog.this.setTaskExecuting(t);
                }
                PleaseWaitConsoleDialog.this.stopButton.setEnabled(true);
                PleaseWaitConsoleDialog.this.stopButton.setVisible(PleaseWaitConsoleDialog.this.taskExecuting != null);
                if (MapFrame.getInstance().isPointsLocked() || !MapFrame.getInstance().isPopupEnabled()) {
                    PleaseWaitConsoleDialog.this.shouldBeUnlocked = false;
                }
                MapFrame.getInstance().lock();
                PleaseWaitConsoleDialog.this.progressBar.setIndeterminate(intermidate);
                if (!intermidate) {
                    PleaseWaitConsoleDialog.this.progressBar.setValue(0);
                }
                PleaseWaitConsoleDialog.this.setVisible(true);
                PleaseWaitConsoleDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    public void setProgress(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PleaseWaitConsoleDialog.this.progressBar.setValue(value);
            }
        });
    }

    public void interrupt() {
        log.info("Sending intterrupt signal to task ...");
        this.taskExecuting.setInterrupted(true);
    }

    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PleaseWaitConsoleDialog.this.progressBar.setIndeterminate(true);
                if (PleaseWaitConsoleDialog.this.shouldBeUnlocked) {
                    MapFrame.getInstance().unlock();
                }
                if (MapFrame.getInstance().isOnCalculatedFrame()) {
                    MapFrame.getInstance().setPopupEnabled(true);
                }
                PleaseWaitConsoleDialog.this.setCursor(Cursor.getDefaultCursor());
                instance = null;
                PleaseWaitConsoleDialog.this.setTaskExecuting(null);
                PleaseWaitConsoleDialog.this.setVisible(false);
                PleaseWaitConsoleDialog.this.dispose();
            }
        });
    }

    public void setProgressMaximum(int progressMaximum) {
        this.progressBar.setMaximum(progressMaximum);
    }

    public StoppableTask getTaskExecuting() {
        return this.taskExecuting;
    }

    public void setTaskExecuting(StoppableTask taskExecuting) {
        this.taskExecuting = taskExecuting;
    }

    @Override
    public void write(String line) {
        log.info(line);
        this.textArea.setText(this.textArea.getText() + System.lineSeparator() + line);
    }
}

