/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.NumericComboBox;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.JTextFieldLimit;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.gui.task.ImportUserPointsFromCustomCsvTask;
import main.java.guru.vfrflight.gui.task.RefreshAllTask;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class UserPointsImportCustomCsvDialog
extends JDialog {
    private static final long serialVersionUID = 8627368452937712679L;
    private FileChooserPanel fileChooserPanel;
    private JTextField separatorTextField;
    private NumericComboBox latComboBox;
    private NumericComboBox lonComboBox;
    private NumericComboBox nameComboBox;
    private NumericComboBox tagsComboBox;
    private final UserPointsDialog mainDialog;

    public UserPointsImportCustomCsvDialog(UserPointsDialog mainDialog) {
        super(mainDialog);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsImportCustomCsvDialog.this.closeWindowAction();
            }
        });
        this.mainDialog = mainDialog;
        this.setTitle(Messages.getInstance().get("export"));
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsImportCustomCsvDialog.this.importAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsImportCustomCsvDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_2.add((Component)panel_1, "North");
        this.fileChooserPanel = new FileChooserPanel(Messages.getInstance().get("user_points_custom_csv_import_dialog_select_file_path"), Messages.getInstance().get("csv_files"), "CSV", true, 40);
        this.fileChooserPanel.setBorder(new EtchedBorder(1, null, null));
        panel_1.add(this.fileChooserPanel);
        JPanel panel_6 = new JPanel();
        panel_2.add((Component)panel_6, "South");
        panel_6.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_6.add((Component)panel_4, "Center");
        panel_4.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        panel_4.add((Component)panel_3, "North");
        JLabel latitudeLabel = new JLabel(Messages.getInstance().get("user_points_custom_csv_import_dialog_latitude"));
        panel_3.add(latitudeLabel);
        NumericComboBoxItem[] values = this.createColumnItems(Messages.getInstance().get("user_points_custom_csv_import_dialog_column_prefix"), 25);
        this.latComboBox = new NumericComboBox(values);
        panel_3.add(this.latComboBox);
        JLabel longitudeLabel = new JLabel(Messages.getInstance().get("user_points_custom_csv_import_dialog_longitude"));
        panel_3.add(longitudeLabel);
        this.lonComboBox = new NumericComboBox(values);
        panel_3.add(this.lonComboBox);
        JPanel panel_5 = new JPanel();
        panel_4.add((Component)panel_5, "Center");
        JLabel nameLabel = new JLabel(Messages.getInstance().get("user_points_custom_csv_import_dialog_name"));
        panel_5.add(nameLabel);
        this.nameComboBox = new NumericComboBox(values);
        panel_5.add(this.nameComboBox);
        JLabel tagsLabel = new JLabel(Messages.getInstance().get("user_points_custom_csv_import_dialog_tags"));
        panel_5.add(tagsLabel);
        this.tagsComboBox = new NumericComboBox(values);
        panel_5.add(this.tagsComboBox);
        JPanel panel_7 = new JPanel();
        panel_6.add((Component)panel_7, "North");
        JLabel separatorLabel = new JLabel(Messages.getInstance().get("user_points_custom_csv_import_dialog_separator"));
        panel_7.add(separatorLabel);
        this.separatorTextField = new JTextField();
        this.separatorTextField.setText(",");
        this.separatorTextField.setHorizontalAlignment(0);
        panel_7.add(this.separatorTextField);
        this.separatorTextField.setColumns(5);
        this.separatorTextField.setDocument(new JTextFieldLimit(1));
        this.setSize(500, 300);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setModal(true);
        this.pack();
    }

    private NumericComboBoxItem[] createColumnItems(String prefix, int numValues) {
        NumericComboBoxItem[] values = new NumericComboBoxItem[numValues + 1];
        values[0] = new NumericComboBoxItem("", null);
        for (int col = 1; col < values.length; ++col) {
            values[col] = new NumericComboBoxItem(prefix + " " + col, col);
        }
        return values;
    }

    private void importAction() {
        if (this.doValidate()) {
            SettingsBean.getInstance().setFileOpenPath(this.fileChooserPanel.getChosenPath());
            MapFrame.getInstance().hidePanel();
            PleaseWaitDialog.getInstance().start();
            new Thread(new ImportUserPointsFromCustomCsvTask(this.mainDialog, this.fileChooserPanel.getChosenPath(), Character.valueOf(this.separatorTextField.getText().charAt(0)), this.latComboBox.getSelectedValue(), this.lonComboBox.getSelectedValue(), this.nameComboBox.getSelectedValue(), this.tagsComboBox.getSelectedValue())).start();
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.fileChooserPanel.isPathSelected()) {
            errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_file_path_empty"));
        }
        if (StringUtil.isEmpty(this.separatorTextField.getText())) {
            errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_separator_empty"));
        }
        if (!this.latComboBox.isAnySelected()) {
            errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_latitude_empty"));
        }
        if (!this.lonComboBox.isAnySelected()) {
            errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_longitude_empty"));
        }
        if (!this.nameComboBox.isAnySelected()) {
            errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_name_empty"));
        }
        if (errors.size() > 0) {
            VfrUtil.showErrorsListDialog(this, errors);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    public void importFinishedAction() {
        VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("open_aip_import_dialog_import_finished"), "", 1);
    }
}

