/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.AddUserPointDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsConvertDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsImportCustomCsvDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.table.UserPointsDataTable;
import main.java.guru.vfrflight.gui.task.ImportOrbxKmzTask;
import main.java.guru.vfrflight.gui.task.ImportUserPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class UserPointsDialog
extends JDialog {
    private static final long serialVersionUID = -4455090335630982624L;
    private UserPointsDataTable userPointsDataTable;
    private JTabbedPane tabbedPane;
    private JRadioButton sortByNameRadioButton;
    private JRadioButton sortByTagsRadioButton;

    public UserPointsDialog(JFrame parent) {
        super(parent);
        this.setResizable(true);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_1.add((Component)panel_4, "North");
        JButton exportButton = new JButton(Messages.getInstance().get("export_button"));
        panel_4.add(exportButton);
        JButton importButton = new JButton(Messages.getInstance().get("import_button"));
        panel_4.add(importButton);
        JButton convertButton = new JButton(Messages.getInstance().get("user_points_frame_convert"));
        panel_4.add(convertButton);
        JPanel panel_5 = new JPanel();
        panel_1.add((Component)panel_5, "Center");
        JButton importPlanGCsvButton = new JButton(Messages.getInstance().get("plang_csv_import"));
        panel_5.add(importPlanGCsvButton);
        JButton csvImportButton = new JButton(Messages.getInstance().get("user_points_frame_import_from_custom_csv"));
        csvImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.importCustomCsvAction();
            }
        });
        panel_5.add(csvImportButton);
        JButton importOrbxKmzButton = new JButton(Messages.getInstance().get("orbx_kmz_import"));
        panel_5.add(importOrbxKmzButton);
        importOrbxKmzButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.importOrbxKmzAction();
            }
        });
        importPlanGCsvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.importPlanGCsvAction();
            }
        });
        convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.convertAction();
            }
        });
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.importAction();
            }
        });
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.exportAction();
            }
        });
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        JButton newButton = new JButton(Messages.getInstance().get("new_button"));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsDialog.this.newAction();
            }
        });
        panel_2.add(newButton);
        JButton editButton = new JButton(Messages.getInstance().get("edit_button"));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsDialog.this.editAction();
            }
        });
        panel_2.add(editButton);
        JButton deleteButton = new JButton(Messages.getInstance().get("delete_button"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.deleteSelectedAction();
            }
        });
        panel_2.add(deleteButton);
        JButton deleteAllButton = new JButton(Messages.getInstance().get("delete_all_button"));
        deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog.this.deleteAllAction();
            }
        });
        panel_2.add(deleteAllButton);
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_3, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("user_points_frame_sort_by"));
        panel_3.add(lblNewLabel);
        this.sortByNameRadioButton = new JRadioButton(Messages.getInstance().get("user_points_frame_by_name"), true);
        this.sortByNameRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsDialog.this.sortAction();
            }
        });
        panel_3.add(this.sortByNameRadioButton);
        this.sortByTagsRadioButton = new JRadioButton(Messages.getInstance().get("user_points_frame_by_tags"), false);
        this.sortByTagsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPointsDialog.this.sortAction();
            }
        });
        panel_3.add(this.sortByTagsRadioButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sortByTagsRadioButton);
        group.add(this.sortByNameRadioButton);
        this.tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.reloadTables();
        this.setSize(800, 500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("user_points_frame_title"));
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void importCustomCsvAction() {
        UserPointsImportCustomCsvDialog dialog = new UserPointsImportCustomCsvDialog(this);
        dialog.setVisible(true);
    }

    protected void newAction() {
        this.openEditDialog(null);
    }

    protected void editAction() {
        UserPoint userPoint = this.userPointsDataTable.getSelectedPoint();
        if (userPoint != null) {
            this.openEditDialog(userPoint);
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_frame_no_points_selected"), "", 0);
        }
    }

    private void openEditDialog(UserPoint point) {
        AddUserPointDialog userPointDialog = new AddUserPointDialog((Window)this, point);
        userPointDialog.setVisible(true);
        if (userPointDialog.isPointSaved()) {
            this.reloadTables();
        }
    }

    private void sortAction() {
        if (this.sortByNameRadioButton.isSelected()) {
            this.userPointsDataTable.sortByName();
        } else {
            this.userPointsDataTable.sortByTags();
        }
    }

    public void closeWindowAction() {
        ArrayList tasksList = new ArrayList(3);
        tasksList.add(new RefreshUserPointsTask());
        try {
            VfrUtil.executeTaskInFixedPool(tasksList);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        MapFrame.getInstance().setPlaceTempHighlightMode(null);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public void reloadTables() {
        int selIdx = this.tabbedPane.getSelectedIndex();
        UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
        this.setUserPointsTable(new UserPointsDataTable(userPointFacade.findUserPoints(null, true)));
        this.sortAction();
        if (selIdx >= 0) {
            this.tabbedPane.setSelectedIndex(selIdx);
        }
    }

    public int setUserPointsTable(UserPointsDataTable table) {
        int selRow = -1;
        if (this.userPointsDataTable != null) {
            selRow = this.userPointsDataTable.getTable().getSelectedRow();
            this.tabbedPane.remove(this.userPointsDataTable);
        }
        this.userPointsDataTable = table;
        this.tabbedPane.addTab(Messages.getInstance().get("main_frame_tab_route_points"), null, this.userPointsDataTable, null);
        this.tabbedPane.setEnabledAt(0, true);
        this.revalidate();
        this.repaint();
        return selRow;
    }

    private void deleteAllAction() {
        if (GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("delete"), Messages.getInstance().get("are_you_sure"))) {
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            userPointFacade.truncateUserPointsTable();
            this.reloadTables();
        }
    }

    private void deleteSelectedAction() {
        List<UserPoint> selectedPoints = this.userPointsDataTable.getSelectedPoints();
        if (selectedPoints.size() > 0) {
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            for (UserPoint p : selectedPoints) {
                userPointFacade.deleteUserPointById(p.getId());
            }
            this.reloadTables();
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_frame_no_points_selected"), "", 0);
        }
    }

    private void exportAction() {
        List<UserPoint> userPoints = this.userPointsDataTable.getPoints();
        if (userPoints.size() > 0) {
            String fileName;
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("file_export"), Messages.getInstance().get("file_export"), SettingsBean.getInstance().getFileOpenPath());
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("userpoints_xml_files"), new String[]{"UPX", "CSV"}));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0 && (!new File(fileName = IOUtil.addExtension(chooser.getSelectedFile(), "upx")).exists() || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("file_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question")))) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                if (UserPointsUtil.saveUserPoints(userPoints, fileName)) {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_export_saving_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_export_saving_error"), "", 0);
                }
            }
        }
    }

    private void importAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("file_import"), Messages.getInstance().get("file_import"), SettingsBean.getInstance().getFileOpenPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("userpoints_xml_files"), new String[]{"UPX"}));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            if (chooser.getSelectedFile().exists()) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                this.setVisible(false);
                MapFrame.getInstance().hidePanel();
                PleaseWaitDialog.getInstance().start();
                Thread t = new Thread(new ImportUserPointsTask(this, chooser.getSelectedFile().getAbsolutePath()));
                t.start();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("loading_error_nofile"), "", 0);
            }
        }
    }

    public void importPlanGCsvAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("csv_import"), Messages.getInstance().get("csv_import"), SettingsBean.getInstance().getFileOpenPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("csv_files"), new String[]{"CSV"}));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            if (chooser.getSelectedFile().exists()) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                this.setVisible(false);
                MapFrame.getInstance().hidePanel();
                PleaseWaitDialog.getInstance().start();
                Thread t = new Thread(new ImportUserPointsTask(this, chooser.getSelectedFile().getAbsolutePath()));
                t.start();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("loading_error_nofile"), "", 0);
            }
        }
    }

    private void importOrbxKmzAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("kmz_import"), Messages.getInstance().get("kmz_import"), SettingsBean.getInstance().getFileOpenPath());
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("kmz_files"), new String[]{"KMZ"}));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            if (chooser.getSelectedFile().exists()) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                this.setVisible(false);
                MapFrame.getInstance().hidePanel();
                PleaseWaitDialog.getInstance().start();
                Thread t = new Thread(new ImportOrbxKmzTask(this, chooser.getSelectedFile().getAbsolutePath()));
                t.start();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("loading_error_nofile"), "", 0);
            }
        }
    }

    private void convertAction() {
        List<UserPoint> selectedPoints = this.userPointsDataTable.getSelectedPoints();
        if (selectedPoints.size() > 0) {
            UserPointsConvertDialog dialog = new UserPointsConvertDialog(this, selectedPoints);
            dialog.showDialog();
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_frame_no_points_selected"), "", 0);
        }
    }

    public void importActionFinish(boolean success) {
        if (success) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_import_loading_success"), "", 1);
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("userpoints_import_loading_error"), "", 0);
        }
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        this.setVisible(true);
    }
}

