/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.StringComboBox;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.gui.swing.list.UserPointsListModel;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class UserPointsConvertToAirspacePolygonalDialog
extends JDialog {
    private static final long serialVersionUID = 3868888385855627169L;
    private AirspaceArea airspaceArea;
    private IntegerTextField bottomAltTextField;
    private IntegerTextField topAltTextField;
    private StringComboBox bottomAltTypeComboBox;
    private StringComboBox topAltTypeComboBox;
    private StringComboBox airspaceTypeComboBox;
    private JTextField nameTextField;
    private JList<String> verticesList;

    public UserPointsConvertToAirspacePolygonalDialog(JDialog mainDialog, List<UserPoint> userPoints) {
        super(mainDialog);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsConvertToAirspacePolygonalDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel namePanel = new JPanel();
        contentPanel.add((Component)namePanel, "North");
        JLabel nameLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_name"));
        namePanel.add(nameLabel);
        this.nameTextField = new JTextField();
        namePanel.add(this.nameTextField);
        this.nameTextField.setHorizontalAlignment(0);
        this.nameTextField.setColumns(30);
        JPanel panel_1 = new JPanel();
        contentPanel.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel altitudePanel = new JPanel();
        panel_1.add((Component)altitudePanel, "North");
        altitudePanel.setLayout(new BorderLayout(0, 0));
        JPanel bottomAltitudePanel = new JPanel();
        altitudePanel.add((Component)bottomAltitudePanel, "North");
        JLabel bottomAltLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_bottom_alt") + UnitUtil.getAltitudeUnit());
        bottomAltitudePanel.add(bottomAltLabel);
        this.bottomAltTextField = new IntegerTextField(1);
        this.bottomAltTextField.setHorizontalAlignment(0);
        bottomAltitudePanel.add(this.bottomAltTextField);
        this.bottomAltTextField.setColumns(10);
        this.bottomAltTypeComboBox = new StringComboBox(this.createBottomAltitudeTypeValues());
        this.bottomAltTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspacePolygonalDialog.this.bottomAltComboBoxAction();
            }
        });
        bottomAltitudePanel.add(this.bottomAltTypeComboBox);
        JPanel topAltitudePanel = new JPanel();
        altitudePanel.add((Component)topAltitudePanel, "Center");
        JLabel topAltLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_top_alt") + UnitUtil.getAltitudeUnit());
        topAltitudePanel.add(topAltLabel);
        this.topAltTextField = new IntegerTextField(1);
        this.topAltTextField.setHorizontalAlignment(0);
        this.topAltTextField.setColumns(10);
        topAltitudePanel.add(this.topAltTextField);
        this.topAltTypeComboBox = new StringComboBox(this.createTopAltitudeTypeValues());
        this.topAltTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspacePolygonalDialog.this.topAltComboBoxAction();
            }
        });
        topAltitudePanel.add(this.topAltTypeComboBox);
        JPanel panel = new JPanel();
        panel_1.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel airspaceTypePanel = new JPanel();
        panel.add((Component)airspaceTypePanel, "North");
        JLabel airspaceTypeLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_type"));
        airspaceTypePanel.add(airspaceTypeLabel);
        this.airspaceTypeComboBox = new StringComboBox(this.createAirspaceTypeValues(), true);
        airspaceTypePanel.add(this.airspaceTypeComboBox);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new CompoundBorder(new EmptyBorder(10, 100, 10, 100), new EtchedBorder(1, null, null)));
        panel_2.add((Component)panel_4, "Center");
        panel_4.setLayout(new BorderLayout(0, 0));
        JPanel panel_5 = new JPanel();
        panel_4.add((Component)panel_5, "Center");
        panel_5.setLayout(new BorderLayout(0, 0));
        this.verticesList = new JList<String>(new UserPointsListModel(userPoints));
        JScrollPane scrollPane = new JScrollPane(20, 31);
        panel_5.add((Component)scrollPane, "Center");
        scrollPane.setViewportView(this.verticesList);
        JPanel panel_6 = new JPanel();
        panel_6.setBorder(new EtchedBorder(1, null, null));
        panel_5.add((Component)panel_6, "South");
        JButton moveUpButton = new JButton("^^^");
        moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspacePolygonalDialog.this.moveUpAction();
            }
        });
        panel_6.add(moveUpButton);
        JButton moveDownButton = new JButton("vvv");
        moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspacePolygonalDialog.this.moveDownAction();
            }
        });
        panel_6.add(moveDownButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirspacePolygonalDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton skipButton = new JButton(Messages.getInstance().get("cancel_button"));
        skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirspacePolygonalDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(skipButton);
        this.setPreferredSize(new Dimension(450, 350));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateData();
    }

    private StringComboBoxItem[] createBottomAltitudeTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        values.add(new StringComboBoxItem(AltitudeType.GND.toString(), AltitudeType.GND.toString()));
        values.add(new StringComboBoxItem(AltitudeType.MSL.toString(), AltitudeType.MSL.toString()));
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private StringComboBoxItem[] createTopAltitudeTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        values.add(new StringComboBoxItem(AltitudeType.UNLIMITED.toString(), AltitudeType.UNLIMITED.toString()));
        values.add(new StringComboBoxItem(AltitudeType.MSL.toString(), AltitudeType.MSL.toString()));
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private StringComboBoxItem[] createAirspaceTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        TreeMap<String, String> mapValues = new TreeMap<String, String>();
        for (AirspaceType type : AirspaceType.values()) {
            String key = type.toString();
            if (Messages.getInstance().exists("airspace_type_" + key)) {
                key = Messages.getInstance().get("airspace_type_" + key);
            }
            mapValues.put(key, type.toString());
        }
        for (Map.Entry pair : mapValues.entrySet()) {
            values.add(new StringComboBoxItem((String)pair.getKey(), (String)pair.getValue()));
        }
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private void moveDownAction() {
        int[] idxs = this.verticesList.getSelectedIndices();
        if (idxs.length > 0 && idxs[idxs.length - 1] < this.getListModel().getSize() - 1) {
            int q = idxs.length - 1;
            while (q >= 0) {
                this.getListModel().moveDown(idxs[q]);
                int n = q--;
                idxs[n] = idxs[n] + 1;
            }
            this.verticesList.setSelectedIndices(idxs);
            this.updateMapShape();
        }
    }

    private void moveUpAction() {
        int[] idxs = this.verticesList.getSelectedIndices();
        if (idxs.length > 0 && idxs[0] > 0) {
            for (int q = 0; q < idxs.length; ++q) {
                this.getListModel().moveUp(idxs[q]);
            }
            this.updateMapShape();
        }
    }

    private UserPointsListModel getListModel() {
        return (UserPointsListModel)this.verticesList.getModel();
    }

    private void updateData() {
        this.bottomAltComboBoxAction();
        this.topAltComboBoxAction();
        this.updateMapShape();
    }

    private void bottomAltComboBoxAction() {
        this.bottomAltTextField.setEnabled(AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()));
    }

    private void topAltComboBoxAction() {
        this.topAltTextField.setEnabled(AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()));
    }

    private void updateMapShape() {
        List<UserPoint> userPoints = this.getListModel().getUserPoints();
        MapShapeVertex[] vertices = new MapShapeVertex[userPoints.size()];
        for (int i = 0; i < userPoints.size(); ++i) {
            vertices[i] = new MapShapeVertex(userPoints.get(i));
        }
        MapShape airspaceShape = new MapShape();
        airspaceShape.setVertices(vertices);
        MapObjectsBean.getInstance().setHighlightedMapShape(airspaceShape);
        MapFrame.getInstance().updateMap();
    }

    private void closeWindowAction() {
        MapObjectsBean.getInstance().setHighlightedMapShape(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void okAction() {
        if (this.doValidate()) {
            this.airspaceArea = new AirspaceArea();
            this.airspaceArea.setName(this.nameTextField.getText());
            ArrayList<AirspaceAreaVertex> vertices = new ArrayList<AirspaceAreaVertex>();
            for (UserPoint p : this.getListModel().getUserPoints()) {
                vertices.add(new AirspaceAreaVertex(p.getGpsPlace()));
            }
            this.airspaceArea.setVertices(vertices);
            this.airspaceArea.setType(AirspaceType.valueOf(this.airspaceTypeComboBox.getSelectedValue()));
            this.airspaceArea.setBottomAltitudeType(AltitudeType.valueOf(this.bottomAltTypeComboBox.getSelectedValue()));
            this.airspaceArea.setTopAltitudeType(AltitudeType.valueOf(this.topAltTypeComboBox.getSelectedValue()));
            if (this.bottomAltTextField.getValue() != null) {
                int alt = this.bottomAltTextField.getValue();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    alt = (int)Math.round(UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                }
                this.airspaceArea.setBottomAltitude(alt);
            }
            if (this.topAltTextField.getValue() != null) {
                int alt = this.topAltTextField.getValue();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    alt = (int)Math.round(UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                }
                this.airspaceArea.setTopAltitude(alt);
            }
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.nameTextField.getText())) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_name_empty"));
        }
        if (!this.airspaceTypeComboBox.isAnySelected()) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_type_not_selected"));
        }
        if (AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()) && this.bottomAltTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_bottom_alt_empty"));
        }
        if (AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()) && this.topAltTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_top_alt_empty"));
        }
        if (AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()) && AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()) && this.topAltTextField.getValue() != null && this.bottomAltTextField.getValue() != null && this.topAltTextField.getValue() <= this.bottomAltTextField.getValue()) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_invalid_altitude_range"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public AirspaceArea getAirspaceArea() {
        return this.airspaceArea;
    }

    public void setAirspaceArea(AirspaceArea airspaceArea) {
        this.airspaceArea = airspaceArea;
    }
}

