/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.StringComboBox;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.swing.textfield.DecimalTextField;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class UserPointsConvertToAirspaceCircularDialog
extends JDialog {
    private static final long serialVersionUID = -7855856846002841761L;
    private AirspaceArea airspaceArea;
    private IntegerTextField bottomAltTextField;
    private IntegerTextField topAltTextField;
    private DecimalTextField radiusTextField;
    private StringComboBox bottomAltTypeComboBox;
    private StringComboBox topAltTypeComboBox;
    private StringComboBox airspaceTypeComboBox;
    private JTextField nameTextField;
    private final UserPoint centerPoint;
    private JRadioButton nmRadioButton;
    private JRadioButton kmRadioButton;
    private JRadioButton smRadioButton;
    private JRadioButton ftRadioButton;

    public UserPointsConvertToAirspaceCircularDialog(JDialog mainDialog, UserPoint centerPoint) {
        super(mainDialog);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsConvertToAirspaceCircularDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.centerPoint = centerPoint;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel namePanel = new JPanel();
        contentPanel.add((Component)namePanel, "North");
        JLabel nameLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_name"));
        namePanel.add(nameLabel);
        this.nameTextField = new JTextField(centerPoint.getName());
        namePanel.add(this.nameTextField);
        this.nameTextField.setHorizontalAlignment(0);
        this.nameTextField.setColumns(30);
        JPanel panel_1 = new JPanel();
        contentPanel.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel altitudePanel = new JPanel();
        panel_1.add((Component)altitudePanel, "North");
        altitudePanel.setLayout(new BorderLayout(0, 0));
        JPanel bottomAltitudePanel = new JPanel();
        altitudePanel.add((Component)bottomAltitudePanel, "North");
        JLabel bottomAltLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_bottom_alt") + UnitUtil.getAltitudeUnit());
        bottomAltitudePanel.add(bottomAltLabel);
        this.bottomAltTextField = new IntegerTextField(1);
        this.bottomAltTextField.setHorizontalAlignment(0);
        bottomAltitudePanel.add(this.bottomAltTextField);
        this.bottomAltTextField.setColumns(10);
        this.bottomAltTypeComboBox = new StringComboBox(this.createBottomAltitudeTypeValues());
        this.bottomAltTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.bottomAltComboBoxAction();
            }
        });
        bottomAltitudePanel.add(this.bottomAltTypeComboBox);
        JPanel topAltitudePanel = new JPanel();
        altitudePanel.add((Component)topAltitudePanel, "Center");
        JLabel topAltLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_top_alt") + UnitUtil.getAltitudeUnit());
        topAltitudePanel.add(topAltLabel);
        this.topAltTextField = new IntegerTextField(1);
        this.topAltTextField.setHorizontalAlignment(0);
        this.topAltTextField.setColumns(10);
        topAltitudePanel.add(this.topAltTextField);
        this.topAltTypeComboBox = new StringComboBox(this.createTopAltitudeTypeValues());
        this.topAltTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.topAltComboBoxAction();
            }
        });
        topAltitudePanel.add(this.topAltTypeComboBox);
        JPanel panel = new JPanel();
        panel_1.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel airspaceTypePanel = new JPanel();
        panel.add((Component)airspaceTypePanel, "North");
        JLabel airspaceTypeLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_type"));
        airspaceTypePanel.add(airspaceTypeLabel);
        this.airspaceTypeComboBox = new StringComboBox(this.createAirspaceTypeValues(), true);
        airspaceTypePanel.add(this.airspaceTypeComboBox);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_2.add((Component)panel_4, "North");
        JLabel radiusLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_radius"));
        panel_4.add(radiusLabel);
        this.radiusTextField = new DecimalTextField(1);
        panel_4.add(this.radiusTextField);
        this.radiusTextField.setHorizontalAlignment(0);
        this.radiusTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
            }
        });
        this.radiusTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
                }
            }
        });
        this.radiusTextField.setColumns(10);
        JPanel panel_5 = new JPanel();
        panel_2.add((Component)panel_5, "Center");
        this.nmRadioButton = new JRadioButton("nm", "nm".equals(SettingsBean.getInstance().getParamUnitsDistance()));
        this.nmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
            }
        });
        panel_5.add(this.nmRadioButton);
        this.kmRadioButton = new JRadioButton("km", "km".equals(SettingsBean.getInstance().getParamUnitsDistance()));
        this.kmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
            }
        });
        panel_5.add(this.kmRadioButton);
        this.smRadioButton = new JRadioButton("sm", "sm".equals(SettingsBean.getInstance().getParamUnitsDistance()));
        this.smRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
            }
        });
        panel_5.add(this.smRadioButton);
        this.ftRadioButton = new JRadioButton("ft", "ft".equals(SettingsBean.getInstance().getParamUnitsDistance()));
        this.ftRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                UserPointsConvertToAirspaceCircularDialog.this.updateMapShape();
            }
        });
        panel_5.add(this.ftRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.nmRadioButton);
        buttonGroup.add(this.kmRadioButton);
        buttonGroup.add(this.smRadioButton);
        buttonGroup.add(this.ftRadioButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirspaceCircularDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton skipButton = new JButton(Messages.getInstance().get("cancel_button"));
        skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirspaceCircularDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(skipButton);
        this.setPreferredSize(new Dimension(450, 265));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateData();
    }

    private StringComboBoxItem[] createBottomAltitudeTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        values.add(new StringComboBoxItem(AltitudeType.GND.toString(), AltitudeType.GND.toString()));
        values.add(new StringComboBoxItem(AltitudeType.MSL.toString(), AltitudeType.MSL.toString()));
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private StringComboBoxItem[] createTopAltitudeTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        values.add(new StringComboBoxItem(AltitudeType.UNLIMITED.toString(), AltitudeType.UNLIMITED.toString()));
        values.add(new StringComboBoxItem(AltitudeType.MSL.toString(), AltitudeType.MSL.toString()));
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private StringComboBoxItem[] createAirspaceTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        TreeMap<String, String> mapValues = new TreeMap<String, String>();
        for (AirspaceType type : AirspaceType.values()) {
            String key = type.toString();
            if (Messages.getInstance().exists("airspace_type_" + key)) {
                key = Messages.getInstance().get("airspace_type_" + key);
            }
            mapValues.put(key, type.toString());
        }
        for (Map.Entry pair : mapValues.entrySet()) {
            values.add(new StringComboBoxItem((String)pair.getKey(), (String)pair.getValue()));
        }
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    private void updateData() {
        this.bottomAltComboBoxAction();
        this.topAltComboBoxAction();
        this.updateMapShape();
    }

    private void bottomAltComboBoxAction() {
        this.bottomAltTextField.setEnabled(AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()));
    }

    private void topAltComboBoxAction() {
        this.topAltTextField.setEnabled(AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()));
    }

    private void updateMapShape() {
        MapObjectsBean.getInstance().setHighlightedMapShape(null);
        if (this.radiusTextField.getValue() != null && this.getSelectedRadiusUnit() != null) {
            MapShape airspaceShape = new MapShape();
            airspaceShape.setCircleCenter(this.centerPoint.getGpsPlace());
            double radius = this.radiusTextField.getValue();
            if (!"nm".equals(this.getSelectedRadiusUnit())) {
                radius = UnitUtil.recalculateDistance(radius, this.getSelectedRadiusUnit(), "nm", false);
            }
            airspaceShape.setRadius(radius);
            MapObjectsBean.getInstance().setHighlightedMapShape(airspaceShape);
        }
        MapFrame.getInstance().updateMap();
    }

    private void closeWindowAction() {
        MapObjectsBean.getInstance().setHighlightedMapShape(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void okAction() {
        if (this.doValidate()) {
            int alt;
            this.airspaceArea = new AirspaceArea();
            this.airspaceArea.setName(this.nameTextField.getText());
            this.airspaceArea.setCircleCenterLat(this.centerPoint.getLat());
            this.airspaceArea.setCircleCenterLon(this.centerPoint.getLon());
            double radius = this.radiusTextField.getValue();
            if (!"nm".equals(this.getSelectedRadiusUnit())) {
                radius = UnitUtil.recalculateDistance(radius, this.getSelectedRadiusUnit(), "nm", false);
            }
            this.airspaceArea.setRadius(radius);
            this.airspaceArea.setType(AirspaceType.valueOf(this.airspaceTypeComboBox.getSelectedValue()));
            this.airspaceArea.setBottomAltitudeType(AltitudeType.valueOf(this.bottomAltTypeComboBox.getSelectedValue()));
            this.airspaceArea.setTopAltitudeType(AltitudeType.valueOf(this.topAltTypeComboBox.getSelectedValue()));
            if (this.bottomAltTextField.getValue() != null) {
                alt = this.bottomAltTextField.getValue();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    alt = (int)Math.round(UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                }
                this.airspaceArea.setBottomAltitude(alt);
            }
            if (this.topAltTextField.getValue() != null) {
                alt = this.topAltTextField.getValue();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    alt = (int)Math.round(UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                }
                this.airspaceArea.setTopAltitude(alt);
            }
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.nameTextField.getText())) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_name_empty"));
        }
        if (!this.airspaceTypeComboBox.isAnySelected()) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_type_not_selected"));
        }
        if (this.radiusTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_radius_empty"));
        }
        if (AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()) && this.bottomAltTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_bottom_alt_empty"));
        }
        if (AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()) && this.topAltTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_top_alt_empty"));
        }
        if (this.getSelectedRadiusUnit() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_radius_unit_not_selected"));
        }
        if (AltitudeType.MSL.toString().equals(this.bottomAltTypeComboBox.getSelectedValue()) && AltitudeType.MSL.toString().equals(this.topAltTypeComboBox.getSelectedValue()) && this.topAltTextField.getValue() != null && this.bottomAltTextField.getValue() != null && this.topAltTextField.getValue() <= this.bottomAltTextField.getValue()) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_invalid_altitude_range"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public AirspaceArea getAirspaceArea() {
        return this.airspaceArea;
    }

    private String getSelectedRadiusUnit() {
        if (this.nmRadioButton.isSelected()) {
            return "nm";
        }
        if (this.kmRadioButton.isSelected()) {
            return "km";
        }
        if (this.smRadioButton.isSelected()) {
            return "sm";
        }
        if (this.ftRadioButton.isSelected()) {
            return "ft";
        }
        return null;
    }
}

