/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.JTextFieldLimit;
import main.java.guru.vfrflight.gui.swing.textfield.DecimalTextField;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class UserPointsConvertToAirportDialog
extends JDialog {
    private static final long serialVersionUID = 4981277673643532599L;
    private UserPoint userPoint;
    private Airport airport;
    private JTextField identTextField;
    private DecimalTextField magvarTextField;
    private IntegerTextField elevationTextField;
    private JTextField nameTextField;

    public UserPointsConvertToAirportDialog(JDialog mainDialog, UserPoint userPoint) {
        super(mainDialog);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsConvertToAirportDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.userPoint = userPoint;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel namePanel = new JPanel();
        contentPanel.add((Component)namePanel, "North");
        JLabel identLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_ident"));
        namePanel.add(identLabel);
        this.identTextField = new JTextField();
        this.identTextField.setHorizontalAlignment(0);
        this.identTextField.setDocument(new JTextFieldLimit(4));
        namePanel.add(this.identTextField);
        this.identTextField.setColumns(5);
        JPanel panel_1 = new JPanel();
        contentPanel.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel typePanel = new JPanel();
        panel_1.add((Component)typePanel, "North");
        JLabel nameLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_name"));
        typePanel.add(nameLabel);
        this.nameTextField = new JTextField();
        this.nameTextField.setHorizontalAlignment(0);
        this.nameTextField.setColumns(30);
        typePanel.add(this.nameTextField);
        JPanel panel = new JPanel();
        panel_1.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel magvarElevPanel = new JPanel();
        panel.add((Component)magvarElevPanel, "North");
        JLabel magvarLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_magvar"));
        magvarElevPanel.add(magvarLabel);
        this.magvarTextField = new DecimalTextField(1);
        this.magvarTextField.setHorizontalAlignment(0);
        magvarElevPanel.add(this.magvarTextField);
        this.magvarTextField.setColumns(7);
        JLabel elevationLabel = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to_elevation") + UnitUtil.getAltitudeUnit());
        magvarElevPanel.add(elevationLabel);
        this.elevationTextField = new IntegerTextField(1);
        magvarElevPanel.add(this.elevationTextField);
        this.elevationTextField.setColumns(7);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirportDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton skipButton = new JButton(Messages.getInstance().get("skip_button"));
        skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertToAirportDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(skipButton);
        this.setPreferredSize(new Dimension(500, 190));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.updateData();
    }

    private void updateData() {
        GpsPlace place = this.userPoint.getGpsPlace();
        MapFrame.getInstance().centerOnPoint(place, 7);
        MapFrame.getInstance().setPlaceTempHighlightMode(place);
        if (this.userPoint.getName() != null) {
            int len = Math.min(this.userPoint.getName().length(), 4);
            this.identTextField.setText(this.userPoint.getName().substring(0, len).toUpperCase());
        }
        this.magvarTextField.setValue(NumberUtil.roundDouble(SettingsBean.getInstance().getDeclinationCalculator().getMagneticDeclination(place), 1));
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void okAction() {
        if (this.doValidate()) {
            this.airport = new Airport();
            this.airport.setIdent(this.identTextField.getText().trim().toUpperCase());
            this.airport.setName(this.nameTextField.getText().trim());
            this.airport.setLat(this.userPoint.getLat());
            this.airport.setLon(this.userPoint.getLon());
            this.airport.setMagvar(this.magvarTextField.getValue());
            if (this.elevationTextField.getValue() != null) {
                int alt = this.elevationTextField.getValue();
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    alt = (int)Math.round(UnitUtil.recalculateAltitude(alt, SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                }
                this.airport.setElev(alt);
            }
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.identTextField.getText()) || this.identTextField.getText().length() > 4) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_invalid_ident"));
        }
        if (this.magvarTextField.getValue() == null) {
            this.magvarTextField.setValue(SettingsBean.getInstance().getDeclinationCalculator().getMagneticDeclination(this.userPoint.getGpsPlace()));
        }
        if (this.elevationTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("user_points_convert_dialog_convert_to_empty_elevation"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public Airport getAirport() {
        return this.airport;
    }
}

