/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.userpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.StringComboBox;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.entity.VfrPoint;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsConvertToAirportDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsConvertToAirspaceCircularDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsConvertToAirspacePolygonalDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsConvertToNavaidDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.task.RefreshAirportsTask;
import main.java.guru.vfrflight.gui.task.RefreshAirspacesTask;
import main.java.guru.vfrflight.gui.task.RefreshCitiesTask;
import main.java.guru.vfrflight.gui.task.RefreshIfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshNdbsTask;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVfrPointsTask;
import main.java.guru.vfrflight.gui.task.RefreshVorsTask;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class UserPointsConvertDialog
extends JDialog {
    private static final long serialVersionUID = 4367659839568045879L;
    private StringComboBox targetObjectType;
    private List<UserPoint> userPoints;
    private UserPointsDialog mainDialog;
    private JCheckBox deleteUserPointsCheckBox;

    public UserPointsConvertDialog(UserPointsDialog mainDialog, List<UserPoint> userPoints) {
        super(mainDialog);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserPointsConvertDialog.this.closeWindowAction(true);
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.userPoints = userPoints;
        this.mainDialog = mainDialog;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)titlePanel, "Center");
        titlePanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        titlePanel.add((Component)panel, "North");
        JLabel label = new JLabel(Messages.getInstance().get("user_points_convert_dialog_convert_to"));
        panel.add(label);
        this.targetObjectType = new StringComboBox(this.createTargetObjectTypeValues());
        panel.add(this.targetObjectType);
        JPanel panel_1 = new JPanel();
        titlePanel.add((Component)panel_1, "Center");
        this.deleteUserPointsCheckBox = new JCheckBox(Messages.getInstance().get("user_points_convert_dialog_convert_to_delete_points_after_import"), true);
        panel_1.add(this.deleteUserPointsCheckBox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsConvertDialog.this.closeWindowAction(true);
            }
        });
        buttonPanel.add(cancelButton);
        this.setPreferredSize(new Dimension(400, 130));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private StringComboBoxItem[] createTargetObjectTypeValues() {
        ArrayList<StringComboBoxItem> values = new ArrayList<StringComboBoxItem>();
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_vfr_point"), MapObjectType.VFR_POINT.toString()));
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_ifr_point"), MapObjectType.IFR_POINT.toString()));
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_city"), MapObjectType.CITY.toString()));
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_navaid"), MapObjectType.NAVAID.toString()));
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_airport"), MapObjectType.AIRPORT.toString()));
        if (this.userPoints.size() > 1) {
            values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_polygon_airspace"), MapObjectType.AIRSPACE_AREA_POLYGONAL.toString()));
        }
        values.add(new StringComboBoxItem(Messages.getInstance().get("user_points_convert_dialog_circular_airspace"), MapObjectType.AIRSPACE_AREA_CIRCULAR.toString()));
        return values.toArray(new StringComboBoxItem[values.size()]);
    }

    public void showDialog() {
        this.mainDialog.setVisible(false);
        this.setVisible(true);
    }

    private void closeWindowAction(boolean showParent) {
        this.setVisible(false);
        if (showParent) {
            this.mainDialog.setVisible(true);
        }
    }

    private void okAction() {
        this.setVisible(false);
        boolean anythingConverted = false;
        if (MapObjectType.VFR_POINT.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToVfrPoints();
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshVfrPointsTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.IFR_POINT.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToIfrPoints();
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshIfrPointsTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.CITY.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToCities();
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshCitiesTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.NAVAID.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToNavaids();
            MapFrame.getInstance().setPlaceTempHighlightMode(null);
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshVorsTask(), new RefreshNdbsTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.AIRPORT.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToAirports();
            MapFrame.getInstance().setPlaceTempHighlightMode(null);
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshAirportsTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.AIRSPACE_AREA_POLYGONAL.toString().equals(this.targetObjectType.getSelectedValue())) {
            anythingConverted = this.convertToPolygonalAirspace();
            if (anythingConverted) {
                VfrUtil.setLayerVisibilityAction(new RefreshAirspacesTask(), new RefreshUserPointsTask());
            }
        } else if (MapObjectType.AIRSPACE_AREA_CIRCULAR.toString().equals(this.targetObjectType.getSelectedValue()) && (anythingConverted = this.convertToCircularAirspace())) {
            VfrUtil.setLayerVisibilityAction(new RefreshAirspacesTask(), new RefreshUserPointsTask());
        }
        if (anythingConverted) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("user_points_convert_dialog_convertion_finished"), "", 1);
        }
        this.closeWindowAction(false);
    }

    private boolean convertToCircularAirspace() {
        ArrayList<AirspaceArea> airspaces = new ArrayList<AirspaceArea>();
        UserPointFacade userPointsFacade = new UserPointFacade(DBUtil.getDataSource());
        for (UserPoint p : this.userPoints) {
            UserPointsConvertToAirspaceCircularDialog dialog = new UserPointsConvertToAirspaceCircularDialog(this, p);
            dialog.setVisible(true);
            if (dialog.getAirspaceArea() == null) continue;
            airspaces.add(dialog.getAirspaceArea());
            if (!this.deleteUserPointsCheckBox.isSelected()) continue;
            userPointsFacade.deleteUserPointById(p.getId());
        }
        if (airspaces.size() > 0) {
            AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
            airspaceFacade.insertAirspaces(airspaces, false);
            MapFrame.getInstance().syncUIWithDataInDB();
        }
        return airspaces.size() > 0;
    }

    private boolean convertToPolygonalAirspace() {
        UserPointsConvertToAirspacePolygonalDialog dialog = new UserPointsConvertToAirspacePolygonalDialog(this, this.userPoints);
        dialog.setVisible(true);
        if (dialog.getAirspaceArea() != null) {
            AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
            airspaceFacade.insertAirspace(dialog.getAirspaceArea(), null);
            this.afterImportAction();
        }
        return dialog.getAirspaceArea() != null;
    }

    private boolean convertToAirports() {
        ArrayList<Airport> airports = new ArrayList<Airport>();
        UserPointFacade userPointsFacade = new UserPointFacade(DBUtil.getDataSource());
        for (UserPoint p : this.userPoints) {
            UserPointsConvertToAirportDialog dialog = new UserPointsConvertToAirportDialog(this, p);
            dialog.setVisible(true);
            if (dialog.getAirport() == null) continue;
            airports.add(dialog.getAirport());
            if (!this.deleteUserPointsCheckBox.isSelected()) continue;
            userPointsFacade.deleteUserPointById(p.getId());
        }
        if (airports.size() > 0) {
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            airportFacade.insertAirports(airports, false);
            MapFrame.getInstance().syncUIWithDataInDB();
        }
        return airports.size() > 0;
    }

    private boolean convertToNavaids() {
        ArrayList<Navaid> navaids = new ArrayList<Navaid>();
        UserPointFacade userPointsFacade = new UserPointFacade(DBUtil.getDataSource());
        for (UserPoint p : this.userPoints) {
            UserPointsConvertToNavaidDialog dialog = new UserPointsConvertToNavaidDialog(this, p);
            dialog.setVisible(true);
            if (dialog.getNavaid() == null) continue;
            navaids.add(dialog.getNavaid());
            if (!this.deleteUserPointsCheckBox.isSelected()) continue;
            userPointsFacade.deleteUserPointById(p.getId());
        }
        if (navaids.size() > 0) {
            NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
            navaidFacade.insertNavaids(navaids, false);
            MapFrame.getInstance().syncUIWithDataInDB();
        }
        return navaids.size() > 0;
    }

    private boolean convertToVfrPoints() {
        ArrayList<VfrPoint> vfrPoints = new ArrayList<VfrPoint>();
        for (UserPoint p : this.userPoints) {
            vfrPoints.add(new VfrPoint(p));
        }
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        airportFacade.insertVfrPoints(vfrPoints, false);
        this.afterImportAction();
        return vfrPoints.size() > 0;
    }

    private boolean convertToIfrPoints() {
        ArrayList<Waypoint> ifrPoints = new ArrayList<Waypoint>();
        for (UserPoint p : this.userPoints) {
            ifrPoints.add(new Waypoint(p));
        }
        IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(DBUtil.getDataSource());
        ifrRouteFacade.insertIfrPoints(ifrPoints, false);
        this.afterImportAction();
        return ifrPoints.size() > 0;
    }

    private boolean convertToCities() {
        ArrayList<City> cities = new ArrayList<City>();
        for (UserPoint p : this.userPoints) {
            cities.add(new City(p));
        }
        CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
        cityFacade.insertCities(new HashSet<City>(cities), false);
        this.afterImportAction();
        return cities.size() > 0;
    }

    private void afterImportAction() {
        if (this.deleteUserPointsCheckBox.isSelected()) {
            this.removeUserPointsFromDB();
        }
        MapFrame.getInstance().syncUIWithDataInDB();
    }

    private void removeUserPointsFromDB() {
        UserPointFacade facade = new UserPointFacade(DBUtil.getDataSource());
        for (UserPoint point : this.userPoints) {
            facade.deleteUserPointById(point.getId());
        }
    }
}

